/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import com.mohistmc.util.i18n.i18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScoreboardSaveData
extends WorldSavedData {
    private static final Logger field_151481_a = LogManager.getLogger();
    private Scoreboard field_96507_a;
    private CompoundNBT field_96506_b;

    public ScoreboardSaveData() {
        super("scoreboard");
    }

    public void func_96499_a(Scoreboard p_96499_1_) {
        this.field_96507_a = p_96499_1_;
        if (this.field_96506_b != null) {
            this.func_76184_a(this.field_96506_b);
        }
    }

    @Override
    public void func_76184_a(CompoundNBT p_76184_1_) {
        if (this.field_96507_a == null) {
            this.field_96506_b = p_76184_1_;
        } else {
            this.func_96501_b(p_76184_1_.func_150295_c("Objectives", 10));
            this.field_96507_a.func_197905_a(p_76184_1_.func_150295_c("PlayerScores", 10));
            if (p_76184_1_.func_150297_b("DisplaySlots", 10)) {
                this.func_96504_c(p_76184_1_.func_74775_l("DisplaySlots"));
            }
            if (p_76184_1_.func_150297_b("Teams", 9)) {
                this.func_96498_a(p_76184_1_.func_150295_c("Teams", 10));
            }
        }
    }

    protected void func_96498_a(ListNBT p_96498_1_) {
        for (int i = 0; i < p_96498_1_.size(); ++i) {
            Team.CollisionRule team$collisionrule;
            Team.Visible team$visible1;
            Team.Visible team$visible;
            IFormattableTextComponent itextcomponent2;
            IFormattableTextComponent itextcomponent1;
            CompoundNBT compoundnbt = p_96498_1_.func_150305_b(i);
            String s = compoundnbt.func_74779_i("Name");
            if (s.length() > 16) {
                s = s.substring(0, 16);
            }
            ScorePlayerTeam scoreplayerteam = this.field_96507_a.func_96527_f(s);
            IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_(compoundnbt.func_74779_i("DisplayName"));
            if (itextcomponent != null) {
                scoreplayerteam.func_96664_a((ITextComponent)itextcomponent);
            }
            if (compoundnbt.func_150297_b("TeamColor", 8)) {
                scoreplayerteam.func_178774_a(TextFormatting.func_96300_b(compoundnbt.func_74779_i("TeamColor")));
            }
            if (compoundnbt.func_150297_b("AllowFriendlyFire", 99)) {
                scoreplayerteam.func_96660_a(compoundnbt.func_74767_n("AllowFriendlyFire"));
            }
            if (compoundnbt.func_150297_b("SeeFriendlyInvisibles", 99)) {
                scoreplayerteam.func_98300_b(compoundnbt.func_74767_n("SeeFriendlyInvisibles"));
            }
            if (compoundnbt.func_150297_b("MemberNamePrefix", 8) && (itextcomponent1 = ITextComponent.Serializer.func_240643_a_(compoundnbt.func_74779_i("MemberNamePrefix"))) != null) {
                scoreplayerteam.func_207408_a((ITextComponent)itextcomponent1);
            }
            if (compoundnbt.func_150297_b("MemberNameSuffix", 8) && (itextcomponent2 = ITextComponent.Serializer.func_240643_a_(compoundnbt.func_74779_i("MemberNameSuffix"))) != null) {
                scoreplayerteam.func_207409_b((ITextComponent)itextcomponent2);
            }
            if (compoundnbt.func_150297_b("NameTagVisibility", 8) && (team$visible = Team.Visible.func_178824_a((String)compoundnbt.func_74779_i("NameTagVisibility"))) != null) {
                scoreplayerteam.func_178772_a(team$visible);
            }
            if (compoundnbt.func_150297_b("DeathMessageVisibility", 8) && (team$visible1 = Team.Visible.func_178824_a((String)compoundnbt.func_74779_i("DeathMessageVisibility"))) != null) {
                scoreplayerteam.func_178773_b(team$visible1);
            }
            if (compoundnbt.func_150297_b("CollisionRule", 8) && (team$collisionrule = Team.CollisionRule.func_186686_a((String)compoundnbt.func_74779_i("CollisionRule"))) != null) {
                scoreplayerteam.func_186682_a(team$collisionrule);
            }
            this.func_96502_a(scoreplayerteam, compoundnbt.func_150295_c("Players", 8));
        }
    }

    protected void func_96502_a(ScorePlayerTeam p_96502_1_, ListNBT p_96502_2_) {
        for (int i = 0; i < p_96502_2_.size(); ++i) {
            this.field_96507_a.func_197901_a(p_96502_2_.func_150307_f(i), p_96502_1_);
        }
    }

    protected void func_96504_c(CompoundNBT p_96504_1_) {
        for (int i = 0; i < 19; ++i) {
            if (!p_96504_1_.func_150297_b("slot_" + i, 8)) continue;
            String s = p_96504_1_.func_74779_i("slot_" + i);
            ScoreObjective scoreobjective = this.field_96507_a.func_96518_b(s);
            this.field_96507_a.func_96530_a(i, scoreobjective);
        }
    }

    protected void func_96501_b(ListNBT p_96501_1_) {
        for (int i = 0; i < p_96501_1_.size(); ++i) {
            CompoundNBT compoundnbt = p_96501_1_.func_150305_b(i);
            ScoreCriteria.func_216390_a((String)compoundnbt.func_74779_i("CriteriaName")).ifPresent(p_215164_2_ -> {
                String s = compoundnbt.func_74779_i("Name");
                if (s.length() > 16) {
                    s = s.substring(0, 16);
                }
                IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_(compoundnbt.func_74779_i("DisplayName"));
                ScoreCriteria.RenderType scorecriteria$rendertype = ScoreCriteria.RenderType.func_211839_a((String)compoundnbt.func_74779_i("RenderType"));
                this.field_96507_a.func_199868_a(s, p_215164_2_, (ITextComponent)itextcomponent, scorecriteria$rendertype);
            });
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT p_189551_1_) {
        if (this.field_96507_a == null) {
            field_151481_a.warn(i18n.get((String)"scoreboardsavedata.1"));
            return p_189551_1_;
        }
        p_189551_1_.func_218657_a("Objectives", (INBT)this.func_96505_b());
        p_189551_1_.func_218657_a("PlayerScores", (INBT)this.field_96507_a.func_197902_i());
        p_189551_1_.func_218657_a("Teams", (INBT)this.func_96496_a());
        this.func_96497_d(p_189551_1_);
        return p_189551_1_;
    }

    protected ListNBT func_96496_a() {
        ListNBT listnbt = new ListNBT();
        for (ScorePlayerTeam scoreplayerteam : this.field_96507_a.func_96525_g()) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("Name", scoreplayerteam.func_96661_b());
            compoundnbt.func_74778_a("DisplayName", ITextComponent.Serializer.func_150696_a(scoreplayerteam.func_96669_c()));
            if (scoreplayerteam.func_178775_l().func_175746_b() >= 0) {
                compoundnbt.func_74778_a("TeamColor", scoreplayerteam.func_178775_l().func_96297_d());
            }
            compoundnbt.func_74757_a("AllowFriendlyFire", scoreplayerteam.func_96665_g());
            compoundnbt.func_74757_a("SeeFriendlyInvisibles", scoreplayerteam.func_98297_h());
            compoundnbt.func_74778_a("MemberNamePrefix", ITextComponent.Serializer.func_150696_a(scoreplayerteam.func_207406_e()));
            compoundnbt.func_74778_a("MemberNameSuffix", ITextComponent.Serializer.func_150696_a(scoreplayerteam.func_207407_f()));
            compoundnbt.func_74778_a("NameTagVisibility", scoreplayerteam.func_178770_i().field_178830_e);
            compoundnbt.func_74778_a("DeathMessageVisibility", scoreplayerteam.func_178771_j().field_178830_e);
            compoundnbt.func_74778_a("CollisionRule", scoreplayerteam.func_186681_k().field_186693_e);
            ListNBT listnbt1 = new ListNBT();
            for (String s : scoreplayerteam.func_96670_d()) {
                listnbt1.add((Object)StringNBT.func_229705_a_(s));
            }
            compoundnbt.func_218657_a("Players", (INBT)listnbt1);
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    protected void func_96497_d(CompoundNBT p_96497_1_) {
        CompoundNBT compoundnbt = new CompoundNBT();
        boolean flag = false;
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreobjective = this.field_96507_a.func_96539_a(i);
            if (scoreobjective == null) continue;
            compoundnbt.func_74778_a("slot_" + i, scoreobjective.func_96679_b());
            flag = true;
        }
        if (flag) {
            p_96497_1_.func_218657_a("DisplaySlots", compoundnbt);
        }
    }

    protected ListNBT func_96505_b() {
        ListNBT listnbt = new ListNBT();
        for (ScoreObjective scoreobjective : this.field_96507_a.func_96514_c()) {
            if (scoreobjective.func_96680_c() == null) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("Name", scoreobjective.func_96679_b());
            compoundnbt.func_74778_a("CriteriaName", scoreobjective.func_96680_c().func_96636_a());
            compoundnbt.func_74778_a("DisplayName", ITextComponent.Serializer.func_150696_a(scoreobjective.func_96678_d()));
            compoundnbt.func_74778_a("RenderType", scoreobjective.func_199865_f().func_211838_a());
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }
}

