/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.mohistmc.eventhandler.dispatcher.BlockEventDispatcher;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.TallBlockItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SPlayerDiggingPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerInteractionManager {
    private static final Logger field_225418_c = LogManager.getLogger();
    public ServerWorld field_73092_a;
    public ServerPlayerEntity field_73090_b;
    private GameType field_73091_c = GameType.NOT_SET;
    private GameType field_241813_e_ = GameType.NOT_SET;
    private boolean field_73088_d;
    private int field_73089_e;
    private BlockPos field_180240_f = BlockPos.field_177992_a;
    private int field_73100_i;
    private boolean field_73097_j;
    private BlockPos field_180241_i = BlockPos.field_177992_a;
    private int field_73093_n;
    private int field_73094_o = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPos interactPosition;
    public Hand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractionManager(ServerWorld p_i50702_1_) {
        this.field_73092_a = p_i50702_1_;
    }

    public void func_73076_a(GameType p_73076_1_) {
        this.func_241820_a(p_73076_1_, p_73076_1_ != this.field_73091_c ? this.field_73091_c : this.field_241813_e_);
    }

    public void func_241820_a(GameType p_241820_1_, GameType p_241820_2_) {
        this.field_241813_e_ = p_241820_2_;
        this.field_73091_c = p_241820_1_;
        p_241820_1_.func_77147_a(this.field_73090_b.field_71075_bZ);
        this.field_73090_b.func_71016_p();
        this.field_73090_b.field_71133_b.func_184103_al().func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_GAME_MODE, new ServerPlayerEntity[]{this.field_73090_b}));
        this.field_73092_a.func_72854_c();
    }

    public GameType func_73081_b() {
        return this.field_73091_c;
    }

    public GameType func_241815_c_() {
        return this.field_241813_e_;
    }

    public boolean func_180239_c() {
        return this.field_73091_c.func_77144_e();
    }

    public boolean func_73083_d() {
        return this.field_73091_c.func_77145_d();
    }

    public void func_73077_b(GameType p_73077_1_) {
        if (this.field_73091_c == GameType.NOT_SET) {
            this.field_73091_c = p_73077_1_;
        }
        this.func_73076_a(this.field_73091_c);
    }

    public void func_73075_a() {
        this.field_73100_i = MinecraftServer.currentTick;
        if (this.field_73097_j) {
            BlockState blockstate = this.field_73092_a.func_180495_p(this.field_180241_i);
            if (blockstate.isAir((IBlockReader)((Object)this.field_73092_a), this.field_180241_i)) {
                this.field_73097_j = false;
            } else {
                float f = this.func_229859_a_(blockstate, this.field_180241_i, this.field_73093_n);
                if (f >= 1.0f) {
                    this.field_73097_j = false;
                    this.func_180237_b(this.field_180241_i);
                }
            }
        } else if (this.field_73088_d) {
            BlockState blockstate1 = this.field_73092_a.func_180495_p(this.field_180240_f);
            if (blockstate1.isAir((IBlockReader)((Object)this.field_73092_a), this.field_180240_f)) {
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
                this.field_73094_o = -1;
                this.field_73088_d = false;
            } else {
                this.func_229859_a_(blockstate1, this.field_180240_f, this.field_73089_e);
            }
        }
    }

    private float func_229859_a_(BlockState p_229859_1_, BlockPos p_229859_2_, int p_229859_3_) {
        int i = this.field_73100_i - p_229859_3_;
        float f = p_229859_1_.func_185903_a(this.field_73090_b, (IBlockReader)((Object)this.field_73090_b.field_70170_p), p_229859_2_) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.field_73094_o) {
            this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), p_229859_2_, j);
            this.field_73094_o = j;
        }
        return f;
    }

    public void func_225416_a(BlockPos p_225416_1_, CPlayerDiggingPacket.Action p_225416_2_, Direction p_225416_3_, int p_225416_4_) {
        double d0 = this.field_73090_b.func_226277_ct_() - ((double)p_225416_1_.func_177958_n() + 0.5);
        double d1 = this.field_73090_b.func_226278_cu_() - ((double)p_225416_1_.func_177956_o() + 0.5) + 1.5;
        double d2 = this.field_73090_b.func_226281_cx_() - ((double)p_225416_1_.func_177952_p() + 0.5);
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        double dist = this.field_73090_b.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0;
        PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_73090_b, (BlockPos)p_225416_1_, (Direction)p_225416_3_);
        if (event.isCanceled() || !this.func_73083_d() && event.getUseItem() == Event.Result.DENY) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, false, "mod canceled"));
            this.field_73092_a.func_184138_a(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), this.field_73092_a.func_180495_p(p_225416_1_), 3);
            return;
        }
        if (d3 > (dist *= dist)) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, false, "too far"));
        } else if (p_225416_1_.func_177956_o() >= p_225416_4_) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, false, "too high"));
        } else if (p_225416_2_ == CPlayerDiggingPacket.Action.START_DESTROY_BLOCK) {
            if (!this.field_73092_a.func_175660_a(this.field_73090_b, p_225416_1_)) {
                CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_73090_b, (Action)Action.LEFT_CLICK_BLOCK, (BlockPos)p_225416_1_, (Direction)p_225416_3_, (ItemStack)this.field_73090_b.field_71071_by.func_70448_g(), (Hand)Hand.MAIN_HAND);
                this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, false, "may not interact"));
                TileEntity tileentity = this.field_73092_a.func_175625_s(p_225416_1_);
                if (tileentity != null) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)tileentity.func_189518_D_());
                }
                return;
            }
            PlayerInteractEvent playerInteractEvent = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_73090_b, (Action)Action.LEFT_CLICK_BLOCK, (BlockPos)p_225416_1_, (Direction)p_225416_3_, (ItemStack)this.field_73090_b.field_71071_by.func_70448_g(), (Hand)Hand.MAIN_HAND);
            if (playerInteractEvent.isCancelled()) {
                this.field_73090_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), p_225416_1_));
                TileEntity tileentity = this.field_73092_a.func_175625_s(p_225416_1_);
                if (tileentity != null) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)tileentity.func_189518_D_());
                }
                return;
            }
            if (this.func_73083_d()) {
                this.func_229860_a_(p_225416_1_, p_225416_2_, "creative destroy");
                return;
            }
            if (this.field_73090_b.func_223729_a(this.field_73092_a, p_225416_1_, this.field_73091_c)) {
                this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, false, "block action restricted"));
                return;
            }
            this.field_73089_e = this.field_73100_i;
            float f = 1.0f;
            BlockState blockstate = this.field_73092_a.func_180495_p(p_225416_1_);
            if (playerInteractEvent.useInteractedBlock() == Event.Result.DENY) {
                BlockState data = this.field_73092_a.func_180495_p(p_225416_1_);
                if (data.func_177230_c() instanceof DoorBlock) {
                    boolean bottom = data.func_177229_b(DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
                    this.field_73090_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), p_225416_1_));
                    this.field_73090_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), bottom ? p_225416_1_.func_177984_a() : p_225416_1_.func_177977_b()));
                } else if (data.func_177230_c() instanceof TrapDoorBlock) {
                    this.field_73090_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), p_225416_1_));
                }
            } else if (!blockstate.isAir((IBlockReader)((Object)this.field_73092_a), p_225416_1_)) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    blockstate.func_196942_a(this.field_73092_a, p_225416_1_, this.field_73090_b);
                }
                f = blockstate.func_185903_a(this.field_73090_b, (IBlockReader)((Object)this.field_73090_b.field_70170_p), p_225416_1_);
            }
            if (playerInteractEvent.useItemInHand() == Event.Result.DENY) {
                if (f > 1.0f) {
                    this.field_73090_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), p_225416_1_));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent((PlayerEntity)this.field_73090_b, (int)p_225416_1_.func_177958_n(), (int)p_225416_1_.func_177956_o(), (int)p_225416_1_.func_177952_p(), (ItemStack)this.field_73090_b.field_71071_by.func_70448_g(), (f >= 1.0f ? 1 : 0) != 0);
            if (blockEvent.isCancelled()) {
                this.field_73090_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), p_225416_1_));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f = 2.0f;
            }
            if (!blockstate.isAir((IBlockReader)((Object)this.field_73092_a), p_225416_1_) && f >= 1.0f) {
                this.func_229860_a_(p_225416_1_, p_225416_2_, "insta mine");
            } else {
                if (this.field_73088_d) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(this.field_180240_f, this.field_73092_a.func_180495_p(this.field_180240_f), CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, false, "abort destroying since another started (client insta mine, server disagreed)"));
                }
                this.field_73088_d = true;
                this.field_180240_f = p_225416_1_.func_185334_h();
                int i = (int)(f * 10.0f);
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), p_225416_1_, i);
                this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, true, "actual start of destroying"));
                this.field_73094_o = i;
            }
        } else if (p_225416_2_ == CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK) {
            if (p_225416_1_.equals(this.field_180240_f)) {
                int j = this.field_73100_i - this.field_73089_e;
                BlockState blockstate1 = this.field_73092_a.func_180495_p(p_225416_1_);
                if (!blockstate1.func_196958_f()) {
                    float f1 = blockstate1.func_185903_a(this.field_73090_b, (IBlockReader)((Object)this.field_73090_b.field_70170_p), p_225416_1_) * (float)(j + 1);
                    if (f1 >= 0.7f) {
                        this.field_73088_d = false;
                        this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), p_225416_1_, -1);
                        this.func_229860_a_(p_225416_1_, p_225416_2_, "destroyed");
                        return;
                    }
                    if (!this.field_73097_j) {
                        this.field_73088_d = false;
                        this.field_73097_j = true;
                        this.field_180241_i = p_225416_1_;
                        this.field_73093_n = this.field_73089_e;
                    }
                }
            }
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, true, "stopped destroying"));
        } else if (p_225416_2_ == CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK) {
            this.field_73088_d = false;
            if (!Objects.equals(this.field_180240_f, p_225416_1_)) {
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
                this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(this.field_180240_f, this.field_73092_a.func_180495_p(this.field_180240_f), p_225416_2_, true, "aborted mismatched destroying"));
            }
            this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), p_225416_1_, -1);
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_225416_1_, this.field_73092_a.func_180495_p(p_225416_1_), p_225416_2_, true, "aborted destroying"));
        }
    }

    public void func_229860_a_(BlockPos p_229860_1_, CPlayerDiggingPacket.Action p_229860_2_, String p_229860_3_) {
        if (this.func_180237_b(p_229860_1_)) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_229860_1_, this.field_73092_a.func_180495_p(p_229860_1_), p_229860_2_, true, p_229860_3_));
        } else {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerDiggingPacket(p_229860_1_, this.field_73092_a.func_180495_p(p_229860_1_), p_229860_2_, false, p_229860_3_));
        }
    }

    public boolean func_180237_b(BlockPos p_180237_1_) {
        boolean flag;
        BlockState blockstate = this.field_73092_a.func_180495_p(p_180237_1_);
        int exp = ForgeHooks.onBlockBreakEvent((World)this.field_73092_a, (GameType)this.field_73091_c, (ServerPlayerEntity)this.field_73090_b, (BlockPos)p_180237_1_);
        if (exp == -1) {
            return false;
        }
        TileEntity tileentity = this.field_73092_a.func_175625_s(p_180237_1_);
        Block block = blockstate.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !this.field_73090_b.func_195070_dx()) {
            this.field_73092_a.func_184138_a(p_180237_1_, blockstate, blockstate, 3);
            return false;
        }
        if (this.field_73090_b.func_184614_ca().onBlockStartBreak(p_180237_1_, this.field_73090_b)) {
            return false;
        }
        if (this.field_73090_b.func_223729_a(this.field_73092_a, p_180237_1_, this.field_73091_c)) {
            return false;
        }
        if (this.func_73083_d()) {
            this.removeBlock(p_180237_1_, false);
            return true;
        }
        ItemStack itemstack = this.field_73090_b.func_184614_ca();
        ItemStack itemstack1 = itemstack.func_77946_l();
        boolean flag1 = blockstate.canHarvestBlock((IBlockReader)((Object)this.field_73092_a), p_180237_1_, this.field_73090_b);
        itemstack.func_179548_a(this.field_73092_a, blockstate, p_180237_1_, this.field_73090_b);
        if (itemstack.func_190926_b() && !itemstack1.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this.field_73090_b, (ItemStack)itemstack1, (Hand)Hand.MAIN_HAND);
        }
        if ((flag = this.removeBlock(p_180237_1_, flag1)) && flag1 && BlockEventDispatcher.isDropItems) {
            block.func_180657_a(this.field_73092_a, this.field_73090_b, p_180237_1_, blockstate, tileentity, itemstack1);
        }
        if (flag && exp > 0) {
            blockstate.func_177230_c().func_180637_b(this.field_73092_a, p_180237_1_, exp);
        }
        return true;
    }

    private boolean removeBlock(BlockPos p_180235_1_, boolean canHarvest) {
        BlockState state = this.field_73092_a.func_180495_p(p_180235_1_);
        boolean removed = state.removedByPlayer(this.field_73092_a, p_180235_1_, this.field_73090_b, canHarvest, this.field_73092_a.func_204610_c(p_180235_1_));
        if (removed) {
            state.func_177230_c().func_176206_d(this.field_73092_a, p_180235_1_, state);
        }
        return removed;
    }

    public ActionResultType func_187250_a(ServerPlayerEntity p_187250_1_, World p_187250_2_, ItemStack p_187250_3_, Hand p_187250_4_) {
        if (this.field_73091_c == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        if (p_187250_1_.func_184811_cZ().func_185141_a(p_187250_3_.func_77973_b())) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onItemRightClick((PlayerEntity)p_187250_1_, (Hand)p_187250_4_);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = p_187250_3_.func_190916_E();
        int j = p_187250_3_.func_77952_i();
        ActionResult<ItemStack> actionresult = p_187250_3_.func_77957_a(p_187250_2_, p_187250_1_, p_187250_4_);
        ItemStack itemstack = (ItemStack)((Object)actionresult.func_188398_b());
        if (itemstack == p_187250_3_ && itemstack.func_190916_E() == i && itemstack.func_77988_m() <= 0 && itemstack.func_77952_i() == j) {
            return actionresult.func_188397_a();
        }
        if (actionresult.func_188397_a() == ActionResultType.FAIL && itemstack.func_77988_m() > 0 && !p_187250_1_.func_184587_cr()) {
            return actionresult.func_188397_a();
        }
        p_187250_1_.func_184611_a(p_187250_4_, itemstack);
        if (this.func_73083_d()) {
            itemstack.func_190920_e(i);
            if (itemstack.func_77984_f() && itemstack.func_77952_i() != j) {
                itemstack.func_196085_b(j);
            }
        }
        if (itemstack.func_190926_b()) {
            p_187250_1_.func_184611_a(p_187250_4_, ItemStack.field_190927_a);
        }
        if (!p_187250_1_.func_184587_cr()) {
            p_187250_1_.func_71120_a(p_187250_1_.field_71069_bz);
        }
        return actionresult.func_188397_a();
    }

    public ActionResultType func_219441_a(ServerPlayerEntity p_219441_1_, World p_219441_2_, ItemStack p_219441_3_, Hand p_219441_4_, BlockRayTraceResult p_219441_5_) {
        BlockPos blockpos = p_219441_5_.func_216350_a();
        BlockState blockstate = p_219441_2_.func_180495_p(blockpos);
        ActionResultType enuminteractionresult = ActionResultType.PASS;
        boolean cancelledBlock = false;
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)p_219441_1_, (Hand)p_219441_4_, (BlockPos)blockpos, (BlockRayTraceResult)p_219441_5_);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (this.field_73091_c == GameType.SPECTATOR) {
            INamedContainerProvider inamedcontainerprovider = blockstate.func_215699_b(p_219441_2_, blockpos);
            boolean bl = cancelledBlock = !(inamedcontainerprovider instanceof INamedContainerProvider);
        }
        if (p_219441_1_.func_184811_cZ().func_185141_a(p_219441_3_.func_77973_b())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent eventCB = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)p_219441_1_, (Action)Action.RIGHT_CLICK_BLOCK, (BlockPos)blockpos, (Direction)p_219441_5_.func_216354_b(), (ItemStack)p_219441_3_, (boolean)cancelledBlock, (Hand)p_219441_4_);
        this.firedInteract = true;
        this.interactResult = eventCB.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockpos.func_185334_h();
        this.interactHand = p_219441_4_;
        this.interactItemStack = p_219441_3_.func_77946_l();
        if (eventCB.useInteractedBlock() == Event.Result.DENY) {
            if (blockstate.func_177230_c() instanceof DoorBlock) {
                boolean bottom = blockstate.func_177229_b(DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
                p_219441_1_.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), bottom ? blockpos.func_177984_a() : blockpos.func_177977_b()));
            } else if (blockstate.func_177230_c() instanceof CakeBlock) {
                p_219441_1_.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.func_77973_b() instanceof TallBlockItem) {
                p_219441_1_.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), blockpos.func_177972_a(p_219441_5_.func_216354_b()).func_177984_a()));
                p_219441_1_.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)this.field_73092_a), blockpos.func_177984_a()));
            }
        } else {
            ActionResultType actionresulttype;
            ActionResultType result;
            if (this.field_73091_c == GameType.SPECTATOR) {
                INamedContainerProvider inamedcontainerprovider = blockstate.func_215699_b(p_219441_2_, blockpos);
                if (inamedcontainerprovider != null) {
                    p_219441_1_.func_213829_a(inamedcontainerprovider);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            ItemUseContext itemusecontext = new ItemUseContext((PlayerEntity)p_219441_1_, p_219441_4_, p_219441_5_);
            if (event.getUseItem() != Event.Result.DENY && (result = p_219441_3_.onItemUseFirst(itemusecontext)) != ActionResultType.PASS) {
                return result;
            }
            boolean flag = !p_219441_1_.func_184614_ca().func_190926_b() || !p_219441_1_.func_184592_cb().func_190926_b();
            boolean flag1 = p_219441_1_.func_226563_dT_() && flag && (!p_219441_1_.func_184614_ca().doesSneakBypassUse((IWorldReader)((Object)p_219441_2_), blockpos, p_219441_1_) || !p_219441_1_.func_184592_cb().doesSneakBypassUse((IWorldReader)((Object)p_219441_2_), blockpos, p_219441_1_));
            ItemStack itemstack = p_219441_3_.func_77946_l();
            if ((event.getUseBlock() == Event.Result.ALLOW || event.getUseBlock() != Event.Result.DENY && !flag1) && (actionresulttype = blockstate.func_227031_a_(p_219441_2_, p_219441_1_, p_219441_4_, p_219441_5_)).func_226246_a_()) {
                CriteriaTriggers.field_232607_M_.func_226695_a_(p_219441_1_, blockpos, itemstack);
                return actionresulttype;
            }
            if (event.getUseItem() == Event.Result.ALLOW || !p_219441_3_.func_190926_b() && !this.interactResult) {
                ActionResultType actionresulttype1;
                if (event.getUseItem() == Event.Result.DENY) {
                    return ActionResultType.PASS;
                }
                if (this.func_73083_d()) {
                    int i = p_219441_3_.func_190916_E();
                    actionresulttype1 = p_219441_3_.func_196084_a(itemusecontext);
                    p_219441_3_.func_190920_e(i);
                } else {
                    actionresulttype1 = p_219441_3_.func_196084_a(itemusecontext);
                }
                if (actionresulttype1.func_226246_a_()) {
                    CriteriaTriggers.field_232607_M_.func_226695_a_(p_219441_1_, blockpos, itemstack);
                }
                return actionresulttype1;
            }
            return ActionResultType.PASS;
        }
        p_219441_1_.getBukkitEntity().updateInventory();
        enuminteractionresult = eventCB.useItemInHand() != Event.Result.ALLOW ? ActionResultType.SUCCESS : ActionResultType.PASS;
        return enuminteractionresult;
    }

    public void func_73080_a(ServerWorld p_73080_1_) {
        this.field_73092_a = p_73080_1_;
    }
}

