/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mohistmc.util.i18n.i18n;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.BanEntry;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import net.minecraft.util.StringUtils;
import net.minecraft.world.storage.FolderName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.SpigotConfig;

public class PreYggdrasilConverter {
    private static final Logger field_152732_e = LogManager.getLogger();
    public static final File field_152728_a = new File("banned-ips.txt");
    public static final File field_152729_b = new File("banned-players.txt");
    public static final File field_152730_c = new File("ops.txt");
    public static final File field_152731_d = new File("white-list.txt");

    static List<String> func_152721_a(File p_152721_0_, Map<String, String[]> p_152721_1_) throws IOException {
        List list = Files.readLines((File)p_152721_0_, (Charset)StandardCharsets.UTF_8);
        for (String s : list) {
            if ((s = s.trim()).startsWith("#") || s.length() < 1) continue;
            String[] astring = s.split("\\|");
            p_152721_1_.put(astring[0].toLowerCase(Locale.ROOT), astring);
        }
        return list;
    }

    private static void func_152717_a(MinecraftServer p_152717_0_, Collection<String> p_152717_1_, ProfileLookupCallback p_152717_2_) {
        String[] astring = (String[])p_152717_1_.stream().filter(p_201150_0_ -> !StringUtils.func_151246_b((String)p_201150_0_)).toArray(String[]::new);
        if (p_152717_0_.func_71266_T() || SpigotConfig.bungee) {
            p_152717_0_.func_152359_aw().findProfilesByNames(astring, Agent.MINECRAFT, p_152717_2_);
        } else {
            for (String s : astring) {
                UUID uuid = PlayerEntity.func_146094_a(new GameProfile((UUID)null, s));
                GameProfile gameprofile = new GameProfile(uuid, s);
                p_152717_2_.onProfileLookupSucceeded(gameprofile);
            }
        }
    }

    public static boolean func_152724_a(final MinecraftServer p_152724_0_) {
        final BanList banlist = new BanList(PlayerList.field_152613_a);
        if (field_152729_b.exists() && field_152729_b.isFile()) {
            if (banlist.func_152691_c().exists()) {
                try {
                    banlist.func_152679_g();
                }
                catch (IOException ioexception1) {
                    field_152732_e.warn("Could not load existing file {}", (Object)banlist.func_152691_c().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                PreYggdrasilConverter.func_152721_a(field_152729_b, map);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_152724_0_.func_152358_ax().func_152649_a(p_onProfileLookupSucceeded_1_);
                        String[] astring = (String[])map.get(p_onProfileLookupSucceeded_1_.getName().toLowerCase(Locale.ROOT));
                        if (astring == null) {
                            field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.1", (Object[])new Object[]{p_onProfileLookupSucceeded_1_.getName()}));
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date date = astring.length > 1 ? PreYggdrasilConverter.func_152713_b(astring[1], null) : null;
                        String s = astring.length > 2 ? astring[2] : null;
                        Date date1 = astring.length > 3 ? PreYggdrasilConverter.func_152713_b(astring[3], null) : null;
                        String s1 = astring.length > 4 ? astring[4] : null;
                        banlist.func_152687_a((UserListEntry)new ProfileBanEntry(p_onProfileLookupSucceeded_1_, date, s, date1, s1));
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.2", (Object[])new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_}));
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                    }
                };
                PreYggdrasilConverter.func_152717_a(p_152724_0_, map.keySet(), profilelookupcallback);
                banlist.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152729_b);
                return true;
            }
            catch (IOException ioexception) {
                field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.3", (Object[])new Object[]{ioexception}));
                return false;
            }
            catch (ConversionError preyggdrasilconverter$conversionerror) {
                field_152732_e.error(i18n.get((String)"preyggdrasilconverter.4", (Object[])new Object[]{preyggdrasilconverter$conversionerror}));
                return false;
            }
        }
        return true;
    }

    public static boolean func_152722_b(MinecraftServer p_152722_0_) {
        IPBanList ipbanlist = new IPBanList(PlayerList.field_152614_b);
        if (field_152728_a.exists() && field_152728_a.isFile()) {
            if (ipbanlist.func_152691_c().exists()) {
                try {
                    ipbanlist.func_152679_g();
                }
                catch (IOException ioexception1) {
                    field_152732_e.warn("Could not load existing file {}", (Object)ipbanlist.func_152691_c().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                PreYggdrasilConverter.func_152721_a(field_152728_a, map);
                for (String s : map.keySet()) {
                    String[] astring = (String[])map.get(s);
                    Date date = astring.length > 1 ? PreYggdrasilConverter.func_152713_b(astring[1], null) : null;
                    String s1 = astring.length > 2 ? astring[2] : null;
                    Date date1 = astring.length > 3 ? PreYggdrasilConverter.func_152713_b(astring[3], null) : null;
                    String s2 = astring.length > 4 ? astring[4] : null;
                    ipbanlist.func_152687_a((UserListEntry)new IPBanEntry(s, date, s1, date1, s2));
                }
                ipbanlist.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152728_a);
                return true;
            }
            catch (IOException ioexception) {
                field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.5", (Object[])new Object[]{ioexception}));
                return false;
            }
        }
        return true;
    }

    public static boolean func_152718_c(final MinecraftServer p_152718_0_) {
        final OpList oplist = new OpList(PlayerList.field_152615_c);
        if (field_152730_c.exists() && field_152730_c.isFile()) {
            if (oplist.func_152691_c().exists()) {
                try {
                    oplist.func_152679_g();
                }
                catch (IOException ioexception1) {
                    field_152732_e.warn("Could not load existing file {}", (Object)oplist.func_152691_c().getName());
                }
            }
            try {
                List list = Files.readLines((File)field_152730_c, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_152718_0_.func_152358_ax().func_152649_a(p_onProfileLookupSucceeded_1_);
                        oplist.func_152687_a(new OpEntry(p_onProfileLookupSucceeded_1_, p_152718_0_.func_110455_j(), false));
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.6", (Object[])new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_}));
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                    }
                };
                PreYggdrasilConverter.func_152717_a(p_152718_0_, list, profilelookupcallback);
                oplist.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152730_c);
                return true;
            }
            catch (IOException ioexception) {
                field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.7", (Object[])new Object[]{ioexception}));
                return false;
            }
            catch (ConversionError preyggdrasilconverter$conversionerror) {
                field_152732_e.error(i18n.get((String)"preyggdrasilconverter.8", (Object[])new Object[]{preyggdrasilconverter$conversionerror}));
                return false;
            }
        }
        return true;
    }

    public static boolean func_152710_d(final MinecraftServer p_152710_0_) {
        final WhiteList whitelist = new WhiteList(PlayerList.field_152616_d);
        if (field_152731_d.exists() && field_152731_d.isFile()) {
            if (whitelist.func_152691_c().exists()) {
                try {
                    whitelist.func_152679_g();
                }
                catch (IOException ioexception1) {
                    field_152732_e.warn("Could not load existing file {}", (Object)whitelist.func_152691_c().getName());
                }
            }
            try {
                List list = Files.readLines((File)field_152731_d, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_152710_0_.func_152358_ax().func_152649_a(p_onProfileLookupSucceeded_1_);
                        whitelist.func_152687_a((UserListEntry)new WhitelistEntry(p_onProfileLookupSucceeded_1_));
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.9", (Object[])new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_}));
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                    }
                };
                PreYggdrasilConverter.func_152717_a(p_152710_0_, list, profilelookupcallback);
                whitelist.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152731_d);
                return true;
            }
            catch (IOException ioexception) {
                field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.10", (Object[])new Object[]{ioexception}));
                return false;
            }
            catch (ConversionError preyggdrasilconverter$conversionerror) {
                field_152732_e.error(i18n.get((String)"preyggdrasilconverter.11", (Object[])new Object[]{preyggdrasilconverter$conversionerror}));
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID func_187473_a(final MinecraftServer p_187473_0_, String p_187473_1_) {
        if (!StringUtils.func_151246_b((String)p_187473_1_) && p_187473_1_.length() <= 16) {
            GameProfile gameprofile = p_187473_0_.func_152358_ax().func_152655_a(p_187473_1_);
            if (gameprofile != null && gameprofile.getId() != null) {
                return gameprofile.getId();
            }
            if (!p_187473_0_.func_71264_H() && p_187473_0_.func_71266_T()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_187473_0_.func_152358_ax().func_152649_a(p_onProfileLookupSucceeded_1_);
                        list.add(p_onProfileLookupSucceeded_1_);
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.12", (Object[])new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_}));
                    }
                };
                PreYggdrasilConverter.func_152717_a(p_187473_0_, Lists.newArrayList((Object[])new String[]{p_187473_1_}), profilelookupcallback);
                return !list.isEmpty() && ((GameProfile)list.get(0)).getId() != null ? ((GameProfile)list.get(0)).getId() : null;
            }
            return PlayerEntity.func_146094_a(new GameProfile((UUID)null, p_187473_1_));
        }
        try {
            return UUID.fromString(p_187473_1_);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public static boolean func_152723_a(final DedicatedServer p_152723_0_) {
        final File file1 = PreYggdrasilConverter.func_219585_g(p_152723_0_);
        final File file2 = new File(file1.getParentFile(), "playerdata");
        final File file3 = new File(file1.getParentFile(), "unknownplayers");
        if (file1.exists() && file1.isDirectory()) {
            File[] afile = file1.listFiles();
            ArrayList list = Lists.newArrayList();
            for (File file4 : afile) {
                String s1;
                String s = file4.getName();
                if (!s.toLowerCase(Locale.ROOT).endsWith(".dat") || (s1 = s.substring(0, s.length() - ".dat".length())).isEmpty()) continue;
                list.add(s1);
            }
            try {
                Object[] astring = list.toArray(new String[list.size()]);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback((String[])astring){
                    final /* synthetic */ String[] val$astring;
                    {
                        this.val$astring = stringArray;
                    }

                    public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                        p_152723_0_.func_152358_ax().func_152649_a(p_onProfileLookupSucceeded_1_);
                        UUID uuid = p_onProfileLookupSucceeded_1_.getId();
                        if (uuid == null) {
                            throw new ConversionError("Missing UUID for user profile " + p_onProfileLookupSucceeded_1_.getName());
                        }
                        this.func_152743_a(file2, this.func_152744_a(p_onProfileLookupSucceeded_1_), uuid.toString());
                    }

                    public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.13", (Object[])new Object[]{p_onProfileLookupFailed_1_.getName(), p_onProfileLookupFailed_2_}));
                        if (!(p_onProfileLookupFailed_2_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_onProfileLookupFailed_1_.getName() + " from backend systems", p_onProfileLookupFailed_2_);
                        }
                        String s2 = this.func_152744_a(p_onProfileLookupFailed_1_);
                        this.func_152743_a(file3, s2, s2);
                    }

                    private void func_152743_a(File p_152743_1_, String p_152743_2_, String p_152743_3_) {
                        File file5 = new File(file1, p_152743_2_ + ".dat");
                        File file6 = new File(p_152743_1_, p_152743_3_ + ".dat");
                        CompoundNBT root = null;
                        try {
                            root = CompressedStreamTools.func_74796_a(new FileInputStream(file5));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (root != null) {
                            if (!root.func_74764_b("bukkit")) {
                                root.func_218657_a("bukkit", new CompoundNBT());
                            }
                            CompoundNBT data = root.func_74775_l("bukkit");
                            data.func_74778_a("lastKnownName", p_152743_2_);
                            try {
                                CompressedStreamTools.func_74799_a(root, new FileOutputStream(file3));
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                        }
                        PreYggdrasilConverter.func_152711_b(p_152743_1_);
                        if (!file5.renameTo(file6)) {
                            throw new ConversionError("Could not convert file for " + p_152743_2_);
                        }
                    }

                    private String func_152744_a(GameProfile p_152744_1_) {
                        String s2 = null;
                        for (String s3 : this.val$astring) {
                            if (s3 == null || !s3.equalsIgnoreCase(p_152744_1_.getName())) continue;
                            s2 = s3;
                            break;
                        }
                        if (s2 == null) {
                            throw new ConversionError("Could not find the filename for " + p_152744_1_.getName() + " anymore");
                        }
                        return s2;
                    }
                };
                PreYggdrasilConverter.func_152717_a(p_152723_0_, Lists.newArrayList((Object[])astring), profilelookupcallback);
                return true;
            }
            catch (ConversionError preyggdrasilconverter$conversionerror) {
                field_152732_e.error(i18n.get((String)"preyggdrasilconverter.14", (Object[])new Object[]{preyggdrasilconverter$conversionerror}));
                return false;
            }
        }
        return true;
    }

    private static void func_152711_b(File p_152711_0_) {
        if (p_152711_0_.exists() ? !p_152711_0_.isDirectory() : !p_152711_0_.mkdirs()) {
            throw new ConversionError("Can't create directory " + p_152711_0_.getName() + " in world save directory.");
        }
    }

    public static boolean func_219587_e(MinecraftServer p_219587_0_) {
        boolean flag = PreYggdrasilConverter.func_152712_b();
        return flag && PreYggdrasilConverter.func_219589_f(p_219587_0_);
    }

    private static boolean func_152712_b() {
        boolean flag = false;
        if (field_152729_b.exists() && field_152729_b.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (field_152728_a.exists() && field_152728_a.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (field_152730_c.exists() && field_152730_c.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (field_152731_d.exists() && field_152731_d.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.15"));
        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.16"));
        if (flag) {
            field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.17", (Object[])new Object[]{field_152729_b.getName()}));
        }
        if (flag1) {
            field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.18", (Object[])new Object[]{field_152728_a.getName()}));
        }
        if (flag2) {
            field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.19", (Object[])new Object[]{field_152730_c.getName()}));
        }
        if (flag3) {
            field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.20", (Object[])new Object[]{field_152731_d.getName()}));
        }
        return false;
    }

    private static boolean func_219589_f(MinecraftServer p_219589_0_) {
        File file1 = PreYggdrasilConverter.func_219585_g(p_219589_0_);
        if (!file1.exists() || !file1.isDirectory() || file1.list().length <= 0 && file1.delete()) {
            return true;
        }
        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.21"));
        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.22"));
        field_152732_e.warn(i18n.get((String)"preyggdrasilconverter.23", (Object[])new Object[]{file1.getPath()}));
        return false;
    }

    private static File func_219585_g(MinecraftServer p_219585_0_) {
        return p_219585_0_.func_240776_a_(FolderName.field_237248_d_).toFile();
    }

    private static void func_152727_c(File p_152727_0_) {
        File file1 = new File(p_152727_0_.getName() + ".converted");
        p_152727_0_.renameTo(file1);
    }

    private static Date func_152713_b(String p_152713_0_, Date p_152713_1_) {
        Date date;
        try {
            date = BanEntry.field_73698_a.parse(p_152713_0_);
        }
        catch (ParseException parseexception) {
            date = p_152713_1_;
        }
        return date;
    }

    static class ConversionError
    extends RuntimeException {
        private ConversionError(String p_i1206_1_, Throwable p_i1206_2_) {
            super(p_i1206_1_, p_i1206_2_);
        }

        private ConversionError(String p_i1207_1_) {
            super(p_i1207_1_);
        }
    }
}

