/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.management.BanEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProfileBanEntry
extends BanEntry<GameProfile> {
    public ProfileBanEntry(GameProfile p_i1134_1_) {
        this(p_i1134_1_, (Date)null, (String)null, (Date)null, (String)null);
    }

    public ProfileBanEntry(GameProfile p_i1135_1_, @Nullable Date p_i1135_2_, @Nullable String p_i1135_3_, @Nullable Date p_i1135_4_, @Nullable String p_i1135_5_) {
        super(p_i1135_1_, p_i1135_2_, p_i1135_3_, p_i1135_4_, p_i1135_5_);
    }

    public ProfileBanEntry(JsonObject p_i1136_1_) {
        super(ProfileBanEntry.func_152648_b(p_i1136_1_), p_i1136_1_);
    }

    @Override
    protected void func_152641_a(JsonObject p_152641_1_) {
        if (this.func_152640_f() != null) {
            p_152641_1_.addProperty("uuid", ((GameProfile)this.func_152640_f()).getId() == null ? "" : ((GameProfile)this.func_152640_f()).getId().toString());
            p_152641_1_.addProperty("name", ((GameProfile)this.func_152640_f()).getName());
            super.func_152641_a(p_152641_1_);
        }
    }

    @Override
    public ITextComponent func_199041_e() {
        GameProfile gameprofile = (GameProfile)this.func_152640_f();
        return new StringTextComponent(gameprofile.getName() != null ? gameprofile.getName() : Objects.toString(gameprofile.getId(), "(Unknown)"));
    }

    private static GameProfile func_152648_b(JsonObject p_152648_0_) {
        UUID uuid = null;
        String name = null;
        if (p_152648_0_.has("uuid")) {
            String s = p_152648_0_.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (p_152648_0_.has("name")) {
            name = p_152648_0_.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new GameProfile(uuid, name);
        }
        return null;
    }

    @Override
    public Date getCreated() {
        return this.field_73694_d;
    }

    private static <T> T checkExpiry(T object, JsonObject jsonobject) {
        Date expires = null;
        try {
            expires = jsonobject.has("expires") ? BanEntry.field_73698_a.parse(jsonobject.get("expires").getAsString()) : null;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (expires == null || expires.after(new Date())) {
            return object;
        }
        return null;
    }
}

