/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.state.Property;

public class IntegerProperty
extends Property<Integer> {
    private final ImmutableSet<Integer> field_177720_a;
    public final int min;
    public final int max;

    protected IntegerProperty(String p_i45648_1_, int p_i45648_2_, int p_i45648_3_) {
        super(p_i45648_1_, Integer.class);
        this.min = p_i45648_2_;
        this.max = p_i45648_3_;
        if (p_i45648_2_ < 0) {
            throw new IllegalArgumentException("Min value of " + p_i45648_1_ + " must be 0 or greater");
        }
        if (p_i45648_3_ <= p_i45648_2_) {
            throw new IllegalArgumentException("Max value of " + p_i45648_1_ + " must be greater than min (" + p_i45648_2_ + ")");
        }
        HashSet set = Sets.newHashSet();
        for (int i = p_i45648_2_; i <= p_i45648_3_; ++i) {
            set.add(i);
        }
        this.field_177720_a = ImmutableSet.copyOf((Collection)set);
    }

    public Collection<Integer> func_177700_c() {
        return this.field_177720_a;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof IntegerProperty && super.equals(p_equals_1_)) {
            IntegerProperty integerproperty = (IntegerProperty)((Object)p_equals_1_);
            return this.field_177720_a.equals(integerproperty.field_177720_a);
        }
        return false;
    }

    public int func_206906_c() {
        return 31 * super.func_206906_c() + this.field_177720_a.hashCode();
    }

    public static IntegerProperty func_177719_a(String p_177719_0_, int p_177719_1_, int p_177719_2_) {
        return new IntegerProperty(p_177719_0_, p_177719_1_, p_177719_2_);
    }

    public Optional<Integer> func_185929_b(String p_185929_1_) {
        try {
            Integer integer = Integer.valueOf(p_185929_1_);
            return this.field_177720_a.contains((Object)integer) ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException numberformatexception) {
            return Optional.empty();
        }
    }

    public String func_177702_a(Integer p_177702_1_) {
        return p_177702_1_.toString();
    }
}

