/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class BeehiveTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final List<Bee> field_226958_a_ = Lists.newArrayList();
    @Nullable
    public BlockPos field_226959_b_ = null;
    public int maxBees = 3;

    public BeehiveTileEntity() {
        super(TileEntityType.field_226985_G_);
    }

    @Override
    public void func_70296_d() {
        if (this.func_226968_d_()) {
            this.func_226963_a_(null, this.field_145850_b.func_180495_p(this.func_174877_v()), State.EMERGENCY);
        }
        super.func_70296_d();
    }

    public boolean func_226968_d_() {
        if (this.field_145850_b == null) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.func_218278_a(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(1, 1, 1))) {
            if (!(this.field_145850_b.func_180495_p(blockpos).func_177230_c() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean func_226969_f_() {
        return this.field_226958_a_.isEmpty();
    }

    public boolean func_226970_h_() {
        return this.field_226958_a_.size() == this.maxBees;
    }

    public void func_226963_a_(@Nullable PlayerEntity p_226963_1_, BlockState p_226963_2_, State p_226963_3_) {
        List<Entity> list = this.func_226965_a_(p_226963_2_, p_226963_3_);
        if (p_226963_1_ != null) {
            for (Entity entity : list) {
                if (!(entity instanceof BeeEntity)) continue;
                BeeEntity beeentity = (BeeEntity)entity;
                if (!(p_226963_1_.func_213303_ch().func_72436_e(entity.func_213303_ch()) <= 16.0)) continue;
                if (!this.func_226972_k_()) {
                    beeentity.setGoalTarget(p_226963_1_, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    continue;
                }
                beeentity.func_226450_t_(400);
            }
        }
    }

    private List<Entity> func_226965_a_(BlockState p_226965_1_, State p_226965_2_) {
        return this.releaseBees(p_226965_1_, p_226965_2_, false);
    }

    public List<Entity> releaseBees(BlockState p_226965_1_, State p_226965_2_, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.field_226958_a_.removeIf(p_226966_4_ -> this.releaseBee(p_226965_1_, (Bee)p_226966_4_, list, p_226965_2_, force));
        return list;
    }

    public void func_226961_a_(Entity p_226961_1_, boolean p_226961_2_) {
        this.func_226962_a_(p_226961_1_, p_226961_2_, 0);
    }

    public int func_226971_j_() {
        return this.field_226958_a_.size();
    }

    public static int func_226964_a_(BlockState p_226964_0_) {
        return p_226964_0_.func_177229_b(BeehiveBlock.field_226873_c_);
    }

    public boolean func_226972_k_() {
        return CampfireBlock.func_235474_a_(this.field_145850_b, this.func_174877_v());
    }

    protected void func_226973_l_() {
        DebugPacketSender.func_229750_a_((BeehiveTileEntity)this);
    }

    public void func_226962_a_(Entity p_226962_1_, boolean p_226962_2_, int p_226962_3_) {
        if (this.field_226958_a_.size() < this.maxBees) {
            if (this.field_145850_b != null) {
                EntityEnterBlockEvent event = new EntityEnterBlockEvent((org.bukkit.entity.Entity)p_226962_1_.getBukkitEntity(), (Block)CraftBlock.at((IWorld)this.field_145850_b, (BlockPos)this.func_174877_v()));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (p_226962_1_ instanceof BeeEntity) {
                        ((BeeEntity)p_226962_1_).func_226450_t_(400);
                    }
                    return;
                }
            }
            p_226962_1_.func_184210_p();
            p_226962_1_.func_184226_ay();
            CompoundNBT compoundnbt = new CompoundNBT();
            p_226962_1_.func_70039_c(compoundnbt);
            this.field_226958_a_.add(new Bee(compoundnbt, p_226962_3_, p_226962_2_ ? 2400 : 600));
            if (this.field_145850_b != null) {
                BeeEntity beeentity;
                if (p_226962_1_ instanceof BeeEntity && (beeentity = (BeeEntity)p_226962_1_).func_226425_er_() && (!this.func_226975_x_() || this.field_145850_b.field_73012_v.nextBoolean())) {
                    this.field_226959_b_ = beeentity.func_226424_eq_();
                }
                BlockPos blockpos = this.func_174877_v();
                this.field_145850_b.func_184148_a(null, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            p_226962_1_.func_70106_y();
        }
    }

    private boolean func_235651_a_(BlockState p_235651_1_, Bee p_235651_2_, @Nullable List<Entity> p_235651_3_, State p_235651_4_) {
        return this.releaseBee(p_235651_1_, p_235651_2_, p_235651_3_, p_235651_4_, false);
    }

    private boolean releaseBee(BlockState p_235651_1_, Bee p_235651_2_, @Nullable List<Entity> p_235651_3_, State p_235651_4_, boolean force) {
        boolean flag;
        if (!force && (this.field_145850_b.func_226690_K_() || this.field_145850_b.func_72896_J()) && p_235651_4_ != State.EMERGENCY) {
            return false;
        }
        BlockPos blockpos = this.func_174877_v();
        CompoundNBT compoundnbt = p_235651_2_.field_226977_a_;
        compoundnbt.func_82580_o("Passengers");
        compoundnbt.func_82580_o("Leash");
        compoundnbt.func_82580_o("UUID");
        Direction direction = (Direction)((Object)p_235651_1_.func_177229_b(BeehiveBlock.field_226872_b_));
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        boolean bl = flag = !this.field_145850_b.func_180495_p(blockpos1).func_196952_d((IBlockReader)((Object)this.field_145850_b), blockpos1).func_197766_b();
        if (flag && p_235651_4_ != State.EMERGENCY) {
            return false;
        }
        Entity entity = EntityType.func_220335_a(compoundnbt, this.field_145850_b, p_226960_0_ -> p_226960_0_);
        if (entity != null) {
            if (entity instanceof BeeEntity) {
                float f = entity.func_213311_cf();
                double d0 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d1 = (double)blockpos.func_177958_n() + 0.5 + d0 * (double)direction.func_82601_c();
                double d2 = (double)blockpos.func_177956_o() + 0.5 - (double)(entity.func_213302_cg() / 2.0f);
                double d3 = (double)blockpos.func_177952_p() + 0.5 + d0 * (double)direction.func_82599_e();
                entity.func_70012_b(d1, d2, d3, entity.field_70177_z, entity.field_70125_A);
            }
            if (!this.field_145850_b.addEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (!entity.func_200600_R().func_220341_a(EntityTypeTags.field_226155_c_)) {
                return false;
            }
            if (entity instanceof BeeEntity) {
                BeeEntity beeentity = (BeeEntity)entity;
                if (this.func_226975_x_() && !beeentity.func_226425_er_() && this.field_145850_b.field_73012_v.nextFloat() < 0.9f) {
                    beeentity.func_226431_g_(this.field_226959_b_);
                }
                if (p_235651_4_ == State.HONEY_DELIVERED) {
                    int i;
                    beeentity.func_226413_eG_();
                    if (p_235651_1_.func_177230_c().func_203417_a(BlockTags.field_226151_aa_) && (i = BeehiveTileEntity.func_226964_a_(p_235651_1_)) < 5) {
                        int j;
                        int n = j = this.field_145850_b.field_73012_v.nextInt(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)p_235651_1_.func_206870_a(BeehiveBlock.field_226873_c_, i + j));
                    }
                }
                this.func_235650_a_(p_235651_2_.field_226978_b_, beeentity);
                if (p_235651_3_ != null) {
                    p_235651_3_.add(beeentity);
                }
            }
            this.field_145850_b.func_184133_a(null, blockpos, SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void func_235650_a_(int p_235650_1_, BeeEntity p_235650_2_) {
        int i = p_235650_2_.func_70874_b();
        if (i < 0) {
            p_235650_2_.func_70873_a(Math.min(0, i + p_235650_1_));
        } else if (i > 0) {
            p_235650_2_.func_70873_a(Math.max(0, i - p_235650_1_));
        }
        p_235650_2_.func_204700_e(Math.max(0, p_235650_2_.func_234178_eO_() - p_235650_1_));
        p_235650_2_.func_226426_eu_();
    }

    private boolean func_226975_x_() {
        return this.field_226959_b_ != null;
    }

    private void func_226976_y_() {
        Iterator<Bee> iterator = this.field_226958_a_.iterator();
        BlockState blockstate = this.func_195044_w();
        while (iterator.hasNext()) {
            Bee beehivetileentity$bee = iterator.next();
            if (beehivetileentity$bee.field_226978_b_ > beehivetileentity$bee.field_226979_c_) {
                State beehivetileentity$state;
                State state = beehivetileentity$state = beehivetileentity$bee.field_226977_a_.func_74767_n("HasNectar") ? State.HONEY_DELIVERED : State.BEE_RELEASED;
                if (this.func_235651_a_(blockstate, beehivetileentity$bee, null, beehivetileentity$state)) {
                    iterator.remove();
                } else {
                    beehivetileentity$bee.field_226978_b_ = beehivetileentity$bee.field_226979_c_ / 2;
                }
            } else {
                beehivetileentity$bee.field_226978_b_++;
            }
            beehivetileentity$bee.field_226978_b_++;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.func_226976_y_();
            BlockPos blockpos = this.func_174877_v();
            if (this.field_226958_a_.size() > 0 && this.field_145850_b.func_201674_k().nextDouble() < 0.005) {
                double d0 = (double)blockpos.func_177958_n() + 0.5;
                double d1 = blockpos.func_177956_o();
                double d2 = (double)blockpos.func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, d0, d1, d2, SoundEvents.field_226134_ai_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.func_226973_l_();
        }
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.field_226958_a_.clear();
        ListNBT listnbt = p_230337_2_.func_150295_c("Bees", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Bee beehivetileentity$bee = new Bee(compoundnbt.func_74775_l("EntityData"), compoundnbt.func_74762_e("TicksInHive"), compoundnbt.func_74762_e("MinOccupationTicks"));
            this.field_226958_a_.add(beehivetileentity$bee);
        }
        this.field_226959_b_ = null;
        if (p_230337_2_.func_74764_b("FlowerPos")) {
            this.field_226959_b_ = NBTUtil.func_186861_c(p_230337_2_.func_74775_l("FlowerPos"));
        }
        if (p_230337_2_.func_74764_b("Bukkit.MaxEntities")) {
            this.maxBees = p_230337_2_.func_74762_e("Bukkit.MaxEntities");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        p_189515_1_.func_218657_a("Bees", (INBT)this.func_226974_m_());
        if (this.func_226975_x_()) {
            p_189515_1_.func_218657_a("FlowerPos", NBTUtil.func_186859_a(this.field_226959_b_));
        }
        p_189515_1_.func_74768_a("Bukkit.MaxEntities", this.maxBees);
        return p_189515_1_;
    }

    public ListNBT func_226974_m_() {
        ListNBT listnbt = new ListNBT();
        for (Bee beehivetileentity$bee : this.field_226958_a_) {
            beehivetileentity$bee.field_226977_a_.func_82580_o("UUID");
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_218657_a("EntityData", beehivetileentity$bee.field_226977_a_);
            compoundnbt.func_74768_a("TicksInHive", beehivetileentity$bee.field_226978_b_);
            compoundnbt.func_74768_a("MinOccupationTicks", beehivetileentity$bee.field_226979_c_);
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    public static enum State {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    static class Bee {
        private final CompoundNBT field_226977_a_;
        private int field_226978_b_;
        private final int field_226979_c_;

        private Bee(CompoundNBT p_i225767_1_, int p_i225767_2_, int p_i225767_3_) {
            p_i225767_1_.func_82580_o("UUID");
            this.field_226977_a_ = p_i225767_1_;
            this.field_226978_b_ = p_i225767_2_;
            this.field_226979_c_ = p_i225767_3_;
        }
    }
}

