/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodStats {
    public int field_75127_a = 20;
    public float field_75125_b = 5.0f;
    public float field_75126_c;
    private int field_75123_d;
    private int field_75124_e = 20;
    private PlayerEntity entityhuman;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;

    public FoodStats() {
        this.entityhuman = null;
    }

    public FoodStats(PlayerEntity entityhuman) {
        Validate.notNull((Object)entityhuman);
        this.entityhuman = entityhuman;
    }

    public void func_75122_a(int p_75122_1_, float p_75122_2_) {
        this.field_75127_a = Math.min(p_75122_1_ + this.field_75127_a, 20);
        this.field_75125_b = Math.min(this.field_75125_b + (float)p_75122_1_ * p_75122_2_ * 2.0f, (float)this.field_75127_a);
    }

    public void func_221410_a(Item p_221410_1_, ItemStack p_221410_2_) {
        if (p_221410_1_.func_219971_r()) {
            Food food = p_221410_1_.func_219967_s();
            if (this.entityhuman == null) {
                this.func_75122_a(food.func_221466_a(), food.func_221469_b());
            } else {
                int oldFoodLevel = this.field_75127_a;
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent((PlayerEntity)this.entityhuman, (int)(food.func_221466_a() + oldFoodLevel), (ItemStack)p_221410_2_);
                if (!event.isCancelled()) {
                    this.func_75122_a(event.getFoodLevel() - oldFoodLevel, food.func_221469_b());
                }
                ((ServerPlayerEntity)this.entityhuman).getBukkitEntity().sendHealthUpdate();
            }
        }
    }

    public void func_75118_a(PlayerEntity p_75118_1_) {
        boolean flag;
        Difficulty difficulty = p_75118_1_.field_70170_p.func_175659_aa();
        this.field_75124_e = this.field_75127_a;
        if (this.field_75126_c > 4.0f) {
            this.field_75126_c -= 4.0f;
            if (this.field_75125_b > 0.0f) {
                this.field_75125_b = Math.max(this.field_75125_b - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                if (this.entityhuman == null) {
                    this.field_75127_a = Math.max(this.field_75127_a - 1, 0);
                } else {
                    FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent((PlayerEntity)this.entityhuman, (int)Math.max(this.field_75127_a - 1, 0));
                    if (!event.isCancelled()) {
                        this.field_75127_a = event.getFoodLevel();
                    }
                    ((ServerPlayerEntity)this.entityhuman).field_71135_a.func_147359_a((IPacket<?>)new SUpdateHealthPacket(((ServerPlayerEntity)this.entityhuman).getBukkitEntity().getScaledHealth(), this.field_75127_a, this.field_75125_b));
                }
            }
        }
        if ((flag = p_75118_1_.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i)) && this.field_75125_b > 0.0f && p_75118_1_.func_70996_bM() && this.field_75127_a >= 20) {
            ++this.field_75123_d;
            if (this.field_75123_d >= 10) {
                float f = Math.min(this.field_75125_b, 6.0f);
                p_75118_1_.regainReason_SATIATED();
                p_75118_1_.func_70691_i(f / 6.0f);
                p_75118_1_.regainReason_CUSTOM();
                p_75118_1_.withExhaustionReason(EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.func_75113_a(f);
                p_75118_1_.setDefaultExhaustionReason();
                this.field_75123_d = 0;
            }
        } else if (flag && this.field_75127_a >= 18 && p_75118_1_.func_70996_bM()) {
            ++this.field_75123_d;
            if (this.field_75123_d >= 80) {
                p_75118_1_.regainReason_SATIATED();
                p_75118_1_.func_70691_i(1.0f);
                p_75118_1_.regainReason_CUSTOM();
                p_75118_1_.withExhaustionReason(EntityExhaustionEvent.ExhaustionReason.REGEN);
                p_75118_1_.func_71020_j(this.entityhuman == null ? 6.0f : this.entityhuman.field_70170_p.spigotConfig.regenExhaustion);
                p_75118_1_.setDefaultExhaustionReason();
                this.field_75123_d = 0;
            }
        } else if (this.field_75127_a <= 0) {
            ++this.field_75123_d;
            if (this.field_75123_d >= 80) {
                if (p_75118_1_.func_110143_aJ() > 10.0f || difficulty == Difficulty.HARD || p_75118_1_.func_110143_aJ() > 1.0f && difficulty == Difficulty.NORMAL) {
                    p_75118_1_.func_70097_a(DamageSource.field_76366_f, 1.0f);
                }
                this.field_75123_d = 0;
            }
        } else {
            this.field_75123_d = 0;
        }
    }

    public void func_75112_a(CompoundNBT p_75112_1_) {
        if (p_75112_1_.func_150297_b("foodLevel", 99)) {
            this.field_75127_a = p_75112_1_.func_74762_e("foodLevel");
            this.field_75123_d = p_75112_1_.func_74762_e("foodTickTimer");
            this.field_75125_b = p_75112_1_.func_74760_g("foodSaturationLevel");
            this.field_75126_c = p_75112_1_.func_74760_g("foodExhaustionLevel");
        }
    }

    public void func_75117_b(CompoundNBT p_75117_1_) {
        p_75117_1_.func_74768_a("foodLevel", this.field_75127_a);
        p_75117_1_.func_74768_a("foodTickTimer", this.field_75123_d);
        p_75117_1_.func_74776_a("foodSaturationLevel", this.field_75125_b);
        p_75117_1_.func_74776_a("foodExhaustionLevel", this.field_75126_c);
    }

    public int func_75116_a() {
        return this.field_75127_a;
    }

    public boolean func_75121_c() {
        return this.field_75127_a < 20;
    }

    public void func_75113_a(float p_75113_1_) {
        this.field_75126_c = Math.min(this.field_75126_c + p_75113_1_, 40.0f);
    }

    public float func_75115_e() {
        return this.field_75125_b;
    }

    public void func_75114_a(int p_75114_1_) {
        this.field_75127_a = p_75114_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75119_b(float p_75119_1_) {
        this.field_75125_b = p_75119_1_;
    }
}

