/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ArbitraryBitLengthIntArray;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.BlockStateFlatteningMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkPaletteFormat
extends DataFix {
    private static final Logger field_199145_a = LogManager.getLogger();
    private static final BitSet field_199146_b = new BitSet(256);
    private static final BitSet field_199147_c = new BitSet(256);
    private static final Dynamic<?> field_199148_d = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:pumpkin'}");
    private static final Dynamic<?> field_199149_e = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:podzol',Properties:{snowy:'true'}}");
    private static final Dynamic<?> field_199150_f = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:grass_block',Properties:{snowy:'true'}}");
    private static final Dynamic<?> field_199151_g = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:mycelium',Properties:{snowy:'true'}}");
    private static final Dynamic<?> field_199152_h = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:sunflower',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199153_i = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:lilac',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199154_j = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:tall_grass',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199155_k = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:large_fern',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199156_l = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:rose_bush',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199157_m = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:peony',Properties:{half:'upper'}}");
    private static final Map<String, Dynamic<?>> field_199158_n = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_209306_0_ -> {
        p_209306_0_.put("minecraft:air0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:flower_pot'}"));
        p_209306_0_.put("minecraft:red_flower0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_poppy'}"));
        p_209306_0_.put("minecraft:red_flower1", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_blue_orchid'}"));
        p_209306_0_.put("minecraft:red_flower2", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_allium'}"));
        p_209306_0_.put("minecraft:red_flower3", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_azure_bluet'}"));
        p_209306_0_.put("minecraft:red_flower4", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_red_tulip'}"));
        p_209306_0_.put("minecraft:red_flower5", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_orange_tulip'}"));
        p_209306_0_.put("minecraft:red_flower6", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_white_tulip'}"));
        p_209306_0_.put("minecraft:red_flower7", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_pink_tulip'}"));
        p_209306_0_.put("minecraft:red_flower8", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_oxeye_daisy'}"));
        p_209306_0_.put("minecraft:yellow_flower0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_dandelion'}"));
        p_209306_0_.put("minecraft:sapling0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_oak_sapling'}"));
        p_209306_0_.put("minecraft:sapling1", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_spruce_sapling'}"));
        p_209306_0_.put("minecraft:sapling2", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_birch_sapling'}"));
        p_209306_0_.put("minecraft:sapling3", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_jungle_sapling'}"));
        p_209306_0_.put("minecraft:sapling4", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_acacia_sapling'}"));
        p_209306_0_.put("minecraft:sapling5", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_dark_oak_sapling'}"));
        p_209306_0_.put("minecraft:red_mushroom0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_red_mushroom'}"));
        p_209306_0_.put("minecraft:brown_mushroom0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_brown_mushroom'}"));
        p_209306_0_.put("minecraft:deadbush0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_dead_bush'}"));
        p_209306_0_.put("minecraft:tallgrass2", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_fern'}"));
        p_209306_0_.put("minecraft:cactus0", BlockStateFlatteningMap.func_210049_b(2240));
    });
    private static final Map<String, Dynamic<?>> field_199159_o = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_209308_0_ -> {
        ChunkPaletteFormat.func_209300_a(p_209308_0_, 0, "skeleton", "skull");
        ChunkPaletteFormat.func_209300_a(p_209308_0_, 1, "wither_skeleton", "skull");
        ChunkPaletteFormat.func_209300_a(p_209308_0_, 2, "zombie", "head");
        ChunkPaletteFormat.func_209300_a(p_209308_0_, 3, "player", "head");
        ChunkPaletteFormat.func_209300_a(p_209308_0_, 4, "creeper", "head");
        ChunkPaletteFormat.func_209300_a(p_209308_0_, 5, "dragon", "head");
    });
    private static final Map<String, Dynamic<?>> field_199160_p = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_209298_0_ -> {
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "oak_door", 1024);
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "iron_door", 1136);
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "spruce_door", 3088);
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "birch_door", 3104);
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "jungle_door", 3120);
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "acacia_door", 3136);
        ChunkPaletteFormat.func_209301_a(p_209298_0_, "dark_oak_door", 3152);
    });
    private static final Map<String, Dynamic<?>> field_199161_q = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_209302_0_ -> {
        for (int i = 0; i < 26; ++i) {
            p_209302_0_.put("true" + i, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:note_block',Properties:{powered:'true',note:'" + i + "'}}"));
            p_209302_0_.put("false" + i, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:note_block',Properties:{powered:'false',note:'" + i + "'}}"));
        }
    });
    private static final Int2ObjectMap<String> field_199162_r = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), p_209296_0_ -> {
        p_209296_0_.put(0, (Object)"white");
        p_209296_0_.put(1, (Object)"orange");
        p_209296_0_.put(2, (Object)"magenta");
        p_209296_0_.put(3, (Object)"light_blue");
        p_209296_0_.put(4, (Object)"yellow");
        p_209296_0_.put(5, (Object)"lime");
        p_209296_0_.put(6, (Object)"pink");
        p_209296_0_.put(7, (Object)"gray");
        p_209296_0_.put(8, (Object)"light_gray");
        p_209296_0_.put(9, (Object)"cyan");
        p_209296_0_.put(10, (Object)"purple");
        p_209296_0_.put(11, (Object)"blue");
        p_209296_0_.put(12, (Object)"brown");
        p_209296_0_.put(13, (Object)"green");
        p_209296_0_.put(14, (Object)"red");
        p_209296_0_.put(15, (Object)"black");
    });
    private static final Map<String, Dynamic<?>> field_199163_s = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_209304_0_ -> {
        for (Int2ObjectMap.Entry entry : field_199162_r.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "red")) continue;
            ChunkPaletteFormat.func_209307_a(p_209304_0_, entry.getIntKey(), (String)entry.getValue());
        }
    });
    private static final Map<String, Dynamic<?>> field_199164_t = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_209299_0_ -> {
        for (Int2ObjectMap.Entry entry : field_199162_r.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "white")) continue;
            ChunkPaletteFormat.func_209297_b(p_209299_0_, 15 - entry.getIntKey(), (String)entry.getValue());
        }
    });
    private static final Dynamic<?> field_199165_u = BlockStateFlatteningMap.func_210049_b(0);

    public ChunkPaletteFormat(Schema p_i49676_1_, boolean p_i49676_2_) {
        super(p_i49676_1_, p_i49676_2_);
    }

    private static void func_209300_a(Map<String, Dynamic<?>> p_209300_0_, int p_209300_1_, String p_209300_2_, String p_209300_3_) {
        p_209300_0_.put(p_209300_1_ + "north", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209300_2_ + "_wall_" + p_209300_3_ + "',Properties:{facing:'north'}}"));
        p_209300_0_.put(p_209300_1_ + "east", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209300_2_ + "_wall_" + p_209300_3_ + "',Properties:{facing:'east'}}"));
        p_209300_0_.put(p_209300_1_ + "south", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209300_2_ + "_wall_" + p_209300_3_ + "',Properties:{facing:'south'}}"));
        p_209300_0_.put(p_209300_1_ + "west", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209300_2_ + "_wall_" + p_209300_3_ + "',Properties:{facing:'west'}}"));
        for (int i = 0; i < 16; ++i) {
            p_209300_0_.put(p_209300_1_ + "" + i, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209300_2_ + "_" + p_209300_3_ + "',Properties:{rotation:'" + i + "'}}"));
        }
    }

    private static void func_209301_a(Map<String, Dynamic<?>> p_209301_0_, String p_209301_1_, int p_209301_2_) {
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 4));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperleftfalsefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 8));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperleftfalsetrue", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 10));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperrightfalsefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 9));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperrightfalsetrue", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 11));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "eastupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 3));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 7));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperrightfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "northupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 1));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 5));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperrightfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "southupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 2));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(p_209301_2_ + 6));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperrightfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        p_209301_0_.put("minecraft:" + p_209301_1_ + "westupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209301_1_ + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
    }

    private static void func_209307_a(Map<String, Dynamic<?>> p_209307_0_, int p_209307_1_, String p_209307_2_) {
        p_209307_0_.put("southfalsefoot" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}"));
        p_209307_0_.put("westfalsefoot" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}"));
        p_209307_0_.put("northfalsefoot" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}"));
        p_209307_0_.put("eastfalsefoot" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}"));
        p_209307_0_.put("southfalsehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'south',occupied:'false',part:'head'}}"));
        p_209307_0_.put("westfalsehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'west',occupied:'false',part:'head'}}"));
        p_209307_0_.put("northfalsehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'north',occupied:'false',part:'head'}}"));
        p_209307_0_.put("eastfalsehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'east',occupied:'false',part:'head'}}"));
        p_209307_0_.put("southtruehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'south',occupied:'true',part:'head'}}"));
        p_209307_0_.put("westtruehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'west',occupied:'true',part:'head'}}"));
        p_209307_0_.put("northtruehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'north',occupied:'true',part:'head'}}"));
        p_209307_0_.put("easttruehead" + p_209307_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209307_2_ + "_bed',Properties:{facing:'east',occupied:'true',part:'head'}}"));
    }

    private static void func_209297_b(Map<String, Dynamic<?>> p_209297_0_, int p_209297_1_, String p_209297_2_) {
        for (int i = 0; i < 16; ++i) {
            p_209297_0_.put("" + i + "_" + p_209297_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209297_2_ + "_banner',Properties:{rotation:'" + i + "'}}"));
        }
        p_209297_0_.put("north_" + p_209297_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209297_2_ + "_wall_banner',Properties:{facing:'north'}}"));
        p_209297_0_.put("south_" + p_209297_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209297_2_ + "_wall_banner',Properties:{facing:'south'}}"));
        p_209297_0_.put("west_" + p_209297_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209297_2_ + "_wall_banner',Properties:{facing:'west'}}"));
        p_209297_0_.put("east_" + p_209297_1_, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + p_209297_2_ + "_wall_banner',Properties:{facing:'east'}}"));
    }

    public static String func_209726_a(Dynamic<?> p_209726_0_) {
        return p_209726_0_.get("Name").asString("");
    }

    public static String func_209719_a(Dynamic<?> p_209719_0_, String p_209719_1_) {
        return p_209719_0_.get("Properties").get(p_209719_1_).asString("");
    }

    public static int func_209724_a(IntIdentityHashBiMap<Dynamic<?>> p_209724_0_, Dynamic<?> p_209724_1_) {
        int i = p_209724_0_.func_148757_b(p_209724_1_);
        if (i == -1) {
            i = p_209724_0_.func_186808_c(p_209724_1_);
        }
        return i;
    }

    private Dynamic<?> func_209712_b(Dynamic<?> p_209712_1_) {
        Optional optional = p_209712_1_.get("Level").result();
        return optional.isPresent() && ((Dynamic)optional.get()).get("Sections").asStreamOpt().result().isPresent() ? p_209712_1_.set("Level", new UpgradeChunk((Dynamic)optional.get()).func_210058_a()) : p_209712_1_;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.field_211287_c);
        Type type1 = this.getOutputSchema().getType(TypeReferences.field_211287_c);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, type1, this::func_209712_b);
    }

    public static int func_210957_a(boolean p_210957_0_, boolean p_210957_1_, boolean p_210957_2_, boolean p_210957_3_) {
        int i = 0;
        if (p_210957_2_) {
            i = p_210957_1_ ? (i |= 2) : (p_210957_0_ ? (i |= 0x80) : (i |= 1));
        } else if (p_210957_3_) {
            i = p_210957_0_ ? (i |= 0x20) : (p_210957_1_ ? (i |= 8) : (i |= 0x10));
        } else if (p_210957_1_) {
            i |= 4;
        } else if (p_210957_0_) {
            i |= 0x40;
        }
        return i;
    }

    static {
        field_199147_c.set(2);
        field_199147_c.set(3);
        field_199147_c.set(110);
        field_199147_c.set(140);
        field_199147_c.set(144);
        field_199147_c.set(25);
        field_199147_c.set(86);
        field_199147_c.set(26);
        field_199147_c.set(176);
        field_199147_c.set(177);
        field_199147_c.set(175);
        field_199147_c.set(64);
        field_199147_c.set(71);
        field_199147_c.set(193);
        field_199147_c.set(194);
        field_199147_c.set(195);
        field_199147_c.set(196);
        field_199147_c.set(197);
        field_199146_b.set(54);
        field_199146_b.set(146);
        field_199146_b.set(25);
        field_199146_b.set(26);
        field_199146_b.set(51);
        field_199146_b.set(53);
        field_199146_b.set(67);
        field_199146_b.set(108);
        field_199146_b.set(109);
        field_199146_b.set(114);
        field_199146_b.set(128);
        field_199146_b.set(134);
        field_199146_b.set(135);
        field_199146_b.set(136);
        field_199146_b.set(156);
        field_199146_b.set(163);
        field_199146_b.set(164);
        field_199146_b.set(180);
        field_199146_b.set(203);
        field_199146_b.set(55);
        field_199146_b.set(85);
        field_199146_b.set(113);
        field_199146_b.set(188);
        field_199146_b.set(189);
        field_199146_b.set(190);
        field_199146_b.set(191);
        field_199146_b.set(192);
        field_199146_b.set(93);
        field_199146_b.set(94);
        field_199146_b.set(101);
        field_199146_b.set(102);
        field_199146_b.set(160);
        field_199146_b.set(106);
        field_199146_b.set(107);
        field_199146_b.set(183);
        field_199146_b.set(184);
        field_199146_b.set(185);
        field_199146_b.set(186);
        field_199146_b.set(187);
        field_199146_b.set(132);
        field_199146_b.set(139);
        field_199146_b.set(199);
    }

    static final class UpgradeChunk {
        private int field_199227_a;
        private final Section[] field_199228_b = new Section[16];
        private final Dynamic<?> field_199229_c;
        private final int field_199230_d;
        private final int field_199231_e;
        private final Int2ObjectMap<Dynamic<?>> field_199232_f = new Int2ObjectLinkedOpenHashMap(16);

        public UpgradeChunk(Dynamic<?> p_i231449_1_) {
            this.field_199229_c = p_i231449_1_;
            this.field_199230_d = p_i231449_1_.get("xPos").asInt(0) << 4;
            this.field_199231_e = p_i231449_1_.get("zPos").asInt(0) << 4;
            p_i231449_1_.get("TileEntities").asStreamOpt().result().ifPresent(p_210061_1_ -> p_210061_1_.forEach(p_233150_1_ -> {
                int j4;
                int l3 = p_233150_1_.get("x").asInt(0) - this.field_199230_d & 0xF;
                int i4 = p_233150_1_.get("y").asInt(0);
                int k4 = i4 << 8 | (j4 = p_233150_1_.get("z").asInt(0) - this.field_199231_e & 0xF) << 4 | l3;
                if (this.field_199232_f.put(k4, p_233150_1_) != null) {
                    field_199145_a.warn(i18n.get((String)"chunkpaletteformat.1", (Object[])new Object[]{this.field_199230_d, this.field_199231_e, l3, i4, j4}));
                }
            }));
            boolean flag = p_i231449_1_.get("convertedFromAlphaFormat").asBoolean(false);
            p_i231449_1_.get("Sections").asStreamOpt().result().ifPresent(p_210062_1_ -> p_210062_1_.forEach(p_210065_1_ -> {
                Section chunkpaletteformat$section1 = new Section((Dynamic<?>)p_210065_1_);
                this.field_199227_a = chunkpaletteformat$section1.func_199207_b(this.field_199227_a);
                this.field_199228_b[chunkpaletteformat$section1.field_199212_c] = chunkpaletteformat$section1;
            }));
            for (Section chunkpaletteformat$section : this.field_199228_b) {
                if (chunkpaletteformat$section == null) continue;
                block14: for (Map.Entry entry : chunkpaletteformat$section.field_199215_f.entrySet()) {
                    int i = chunkpaletteformat$section.field_199212_c << 12;
                    switch ((Integer)entry.getKey()) {
                        case 2: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s12;
                                int i3 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic11 = this.func_210064_a(i3 |= i);
                                if (!"minecraft:grass_block".equals(ChunkPaletteFormat.func_209726_a(dynamic11)) || !"minecraft:snow".equals(s12 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(i3, Direction.UP)))) && !"minecraft:snow_layer".equals(s12)) continue;
                                this.func_210060_a(i3, field_199150_f);
                            }
                            continue block14;
                        }
                        case 3: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s11;
                                int l2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic10 = this.func_210064_a(l2 |= i);
                                if (!"minecraft:podzol".equals(ChunkPaletteFormat.func_209726_a(dynamic10)) || !"minecraft:snow".equals(s11 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(l2, Direction.UP)))) && !"minecraft:snow_layer".equals(s11)) continue;
                                this.func_210060_a(l2, field_199149_e);
                            }
                            continue block14;
                        }
                        case 25: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int k2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic9 = this.func_210059_c(k2 |= i);
                                if (dynamic9 == null) continue;
                                String s10 = Boolean.toString(dynamic9.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(dynamic9.get("note").asInt(0), 0), 24);
                                this.func_210060_a(k2, field_199161_q.getOrDefault(s10, (Dynamic)field_199161_q.get("false0")));
                            }
                            continue block14;
                        }
                        case 26: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int k3;
                                int j2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic8 = this.func_210066_b(j2 |= i);
                                Dynamic<?> dynamic14 = this.func_210064_a(j2);
                                if (dynamic8 == null || (k3 = dynamic8.get("color").asInt(0)) == 14 || k3 < 0 || k3 >= 16) continue;
                                String s16 = ChunkPaletteFormat.func_209719_a(dynamic14, "facing") + ChunkPaletteFormat.func_209719_a(dynamic14, "occupied") + ChunkPaletteFormat.func_209719_a(dynamic14, "part") + k3;
                                if (!field_199163_s.containsKey(s16)) continue;
                                this.func_210060_a(j2, (Dynamic)field_199163_s.get(s16));
                            }
                            continue block14;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                Dynamic<?> dynamic13;
                                int i2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic7 = this.func_210064_a(i2 |= i);
                                if (!ChunkPaletteFormat.func_209726_a(dynamic7).endsWith("_door") || !"lower".equals(ChunkPaletteFormat.func_209719_a(dynamic13 = this.func_210064_a(i2), "half"))) continue;
                                int j3 = UpgradeChunk.func_199223_a(i2, Direction.UP);
                                Dynamic<?> dynamic15 = this.func_210064_a(j3);
                                String s1 = ChunkPaletteFormat.func_209726_a(dynamic13);
                                if (!s1.equals(ChunkPaletteFormat.func_209726_a(dynamic15))) continue;
                                String s2 = ChunkPaletteFormat.func_209719_a(dynamic13, "facing");
                                String s3 = ChunkPaletteFormat.func_209719_a(dynamic13, "open");
                                String s4 = flag ? "left" : ChunkPaletteFormat.func_209719_a(dynamic15, "hinge");
                                String s5 = flag ? "false" : ChunkPaletteFormat.func_209719_a(dynamic15, "powered");
                                this.func_210060_a(i2, (Dynamic)field_199160_p.get(s1 + s2 + "lower" + s4 + s3 + s5));
                                this.func_210060_a(j3, (Dynamic)field_199160_p.get(s1 + s2 + "upper" + s4 + s3 + s5));
                            }
                            continue block14;
                        }
                        case 86: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s9;
                                int l1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic6 = this.func_210064_a(l1 |= i);
                                if (!"minecraft:carved_pumpkin".equals(ChunkPaletteFormat.func_209726_a(dynamic6)) || !"minecraft:grass_block".equals(s9 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(l1, Direction.DOWN)))) && !"minecraft:dirt".equals(s9)) continue;
                                this.func_210060_a(l1, field_199148_d);
                            }
                            continue block14;
                        }
                        case 110: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s8;
                                int k1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic5 = this.func_210064_a(k1 |= i);
                                if (!"minecraft:mycelium".equals(ChunkPaletteFormat.func_209726_a(dynamic5)) || !"minecraft:snow".equals(s8 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(k1, Direction.UP)))) && !"minecraft:snow_layer".equals(s8)) continue;
                                this.func_210060_a(k1, field_199151_g);
                            }
                            continue block14;
                        }
                        case 140: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int j1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic4 = this.func_210059_c(j1 |= i);
                                if (dynamic4 == null) continue;
                                String s7 = dynamic4.get("Item").asString("") + dynamic4.get("Data").asInt(0);
                                this.func_210060_a(j1, field_199158_n.getOrDefault(s7, (Dynamic)field_199158_n.get("minecraft:air0")));
                            }
                            continue block14;
                        }
                        case 144: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic3 = this.func_210066_b(i1 |= i);
                                if (dynamic3 == null) continue;
                                String s6 = String.valueOf(dynamic3.get("SkullType").asInt(0));
                                String s14 = ChunkPaletteFormat.func_209719_a(this.func_210064_a(i1), "facing");
                                String s15 = !"up".equals(s14) && !"down".equals(s14) ? s6 + s14 : s6 + String.valueOf(dynamic3.get("Rot").asInt(0));
                                dynamic3.remove("SkullType");
                                dynamic3.remove("facing");
                                dynamic3.remove("Rot");
                                this.func_210060_a(i1, field_199159_o.getOrDefault(s15, (Dynamic)field_199159_o.get("0north")));
                            }
                            continue block14;
                        }
                        case 175: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int l = (Integer)intListIterator.next();
                                Dynamic<?> dynamic2 = this.func_210064_a(l |= i);
                                if (!"upper".equals(ChunkPaletteFormat.func_209719_a(dynamic2, "half"))) continue;
                                Dynamic<?> dynamic12 = this.func_210064_a(UpgradeChunk.func_199223_a(l, Direction.DOWN));
                                String s13 = ChunkPaletteFormat.func_209726_a(dynamic12);
                                if ("minecraft:sunflower".equals(s13)) {
                                    this.func_210060_a(l, field_199152_h);
                                    continue;
                                }
                                if ("minecraft:lilac".equals(s13)) {
                                    this.func_210060_a(l, field_199153_i);
                                    continue;
                                }
                                if ("minecraft:tall_grass".equals(s13)) {
                                    this.func_210060_a(l, field_199154_j);
                                    continue;
                                }
                                if ("minecraft:large_fern".equals(s13)) {
                                    this.func_210060_a(l, field_199155_k);
                                    continue;
                                }
                                if ("minecraft:rose_bush".equals(s13)) {
                                    this.func_210060_a(l, field_199156_l);
                                    continue;
                                }
                                if (!"minecraft:peony".equals(s13)) continue;
                                this.func_210060_a(l, field_199157_m);
                            }
                            continue block14;
                        }
                        case 176: 
                        case 177: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int k;
                                int j = (Integer)intListIterator.next();
                                Dynamic<?> dynamic = this.func_210066_b(j |= i);
                                Dynamic<?> dynamic1 = this.func_210064_a(j);
                                if (dynamic == null || (k = dynamic.get("Base").asInt(0)) == 15 || k < 0 || k >= 16) continue;
                                String s = ChunkPaletteFormat.func_209719_a(dynamic1, (Integer)entry.getKey() == 176 ? "rotation" : "facing") + "_" + k;
                                if (!field_199164_t.containsKey(s)) continue;
                                this.func_210060_a(j, (Dynamic)field_199164_t.get(s));
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> func_210066_b(int p_210066_1_) {
            return (Dynamic)this.field_199232_f.get(p_210066_1_);
        }

        @Nullable
        private Dynamic<?> func_210059_c(int p_210059_1_) {
            return (Dynamic)this.field_199232_f.remove(p_210059_1_);
        }

        public static int func_199223_a(int p_199223_0_, Direction p_199223_1_) {
            switch (p_199223_1_.func_210940_b()) {
                case X: {
                    int i = (p_199223_0_ & 0xF) + p_199223_1_.func_210939_a().func_210937_a();
                    return i >= 0 && i <= 15 ? p_199223_0_ & 0xFFFFFFF0 | i : -1;
                }
                case Y: {
                    int j = (p_199223_0_ >> 8) + p_199223_1_.func_210939_a().func_210937_a();
                    return j >= 0 && j <= 255 ? p_199223_0_ & 0xFF | j << 8 : -1;
                }
                case Z: {
                    int k = (p_199223_0_ >> 4 & 0xF) + p_199223_1_.func_210939_a().func_210937_a();
                    return k >= 0 && k <= 15 ? p_199223_0_ & 0xFFFFFF0F | k << 4 : -1;
                }
            }
            return -1;
        }

        private void func_210060_a(int p_210060_1_, Dynamic<?> p_210060_2_) {
            Section chunkpaletteformat$section;
            if (p_210060_1_ >= 0 && p_210060_1_ <= 65535 && (chunkpaletteformat$section = this.func_199221_d(p_210060_1_)) != null) {
                chunkpaletteformat$section.func_210053_a(p_210060_1_ & 0xFFF, p_210060_2_);
            }
        }

        @Nullable
        private Section func_199221_d(int p_199221_1_) {
            int i = p_199221_1_ >> 12;
            return i < this.field_199228_b.length ? this.field_199228_b[i] : null;
        }

        public Dynamic<?> func_210064_a(int p_210064_1_) {
            if (p_210064_1_ >= 0 && p_210064_1_ <= 65535) {
                Section chunkpaletteformat$section = this.func_199221_d(p_210064_1_);
                return chunkpaletteformat$section == null ? field_199165_u : chunkpaletteformat$section.func_210056_a(p_210064_1_ & 0xFFF);
            }
            return field_199165_u;
        }

        public Dynamic<?> func_210058_a() {
            Dynamic dynamic = this.field_199229_c;
            dynamic = this.field_199232_f.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.field_199232_f.values().stream()));
            Dynamic dynamic1 = dynamic.emptyMap();
            ArrayList list = Lists.newArrayList();
            for (Section chunkpaletteformat$section : this.field_199228_b) {
                if (chunkpaletteformat$section == null) continue;
                list.add(chunkpaletteformat$section.func_210051_a());
                dynamic1 = dynamic1.set(String.valueOf(chunkpaletteformat$section.field_199212_c), dynamic1.createIntList(Arrays.stream(chunkpaletteformat$section.field_199216_g.toIntArray())));
            }
            Dynamic dynamic2 = dynamic.emptyMap();
            dynamic2 = dynamic2.set("Sides", dynamic2.createByte((byte)this.field_199227_a));
            dynamic2 = dynamic2.set("Indices", dynamic1);
            return dynamic.set("UpgradeData", dynamic2).set("Sections", dynamic2.createList(list.stream()));
        }
    }

    static class Section {
        private final IntIdentityHashBiMap<Dynamic<?>> field_199210_a = new IntIdentityHashBiMap(32);
        private final List<Dynamic<?>> field_199211_b;
        private final Dynamic<?> field_199213_d;
        private final boolean field_199214_e;
        private final Int2ObjectMap<IntList> field_199215_f = new Int2ObjectLinkedOpenHashMap();
        private final IntList field_199216_g = new IntArrayList();
        public final int field_199212_c;
        private final Set<Dynamic<?>> field_199217_h = Sets.newIdentityHashSet();
        private final int[] field_199218_i = new int[4096];

        public Section(Dynamic<?> p_i231448_1_) {
            this.field_199211_b = Lists.newArrayList();
            this.field_199213_d = p_i231448_1_;
            this.field_199212_c = p_i231448_1_.get("Y").asInt(0);
            this.field_199214_e = p_i231448_1_.get("Blocks").result().isPresent();
        }

        public Dynamic<?> func_210056_a(int p_210056_1_) {
            if (p_210056_1_ >= 0 && p_210056_1_ <= 4095) {
                Dynamic dynamic = (Dynamic)this.field_199210_a.func_148745_a(this.field_199218_i[p_210056_1_]);
                return dynamic == null ? field_199165_u : dynamic;
            }
            return field_199165_u;
        }

        public void func_210053_a(int p_210053_1_, Dynamic<?> p_210053_2_) {
            if (this.field_199217_h.add(p_210053_2_)) {
                this.field_199211_b.add("%%FILTER_ME%%".equals(ChunkPaletteFormat.func_209726_a(p_210053_2_)) ? field_199165_u : p_210053_2_);
            }
            this.field_199218_i[p_210053_1_] = ChunkPaletteFormat.func_209724_a(this.field_199210_a, p_210053_2_);
        }

        public int func_199207_b(int p_199207_1_) {
            if (!this.field_199214_e) {
                return p_199207_1_;
            }
            ByteBuffer bytebuffer = (ByteBuffer)this.field_199213_d.get("Blocks").asByteBufferOpt().result().get();
            NibbleArray chunkpaletteformat$nibblearray = this.field_199213_d.get("Data").asByteBufferOpt().map(p_210055_0_ -> new NibbleArray(DataFixUtils.toArray((ByteBuffer)p_210055_0_))).result().orElseGet(NibbleArray::new);
            NibbleArray chunkpaletteformat$nibblearray1 = this.field_199213_d.get("Add").asByteBufferOpt().map(p_210052_0_ -> new NibbleArray(DataFixUtils.toArray((ByteBuffer)p_210052_0_))).result().orElseGet(NibbleArray::new);
            this.field_199217_h.add(field_199165_u);
            ChunkPaletteFormat.func_209724_a(this.field_199210_a, field_199165_u);
            this.field_199211_b.add(field_199165_u);
            for (int i = 0; i < 4096; ++i) {
                int j = i & 0xF;
                int k = i >> 8 & 0xF;
                int l = i >> 4 & 0xF;
                int i1 = chunkpaletteformat$nibblearray1.func_210932_a(j, k, l) << 12 | (bytebuffer.get(i) & 0xFF) << 4 | chunkpaletteformat$nibblearray.func_210932_a(j, k, l);
                if (field_199147_c.get(i1 >> 4)) {
                    this.func_199205_a(i1 >> 4, i);
                }
                if (field_199146_b.get(i1 >> 4)) {
                    int j1 = ChunkPaletteFormat.func_210957_a(j == 0, j == 15, l == 0, l == 15);
                    if (j1 == 0) {
                        this.field_199216_g.add(i);
                    } else {
                        p_199207_1_ |= j1;
                    }
                }
                this.func_210053_a(i, BlockStateFlatteningMap.func_210049_b(i1));
            }
            return p_199207_1_;
        }

        private void func_199205_a(int p_199205_1_, int p_199205_2_) {
            IntList intlist = (IntList)this.field_199215_f.get(p_199205_1_);
            if (intlist == null) {
                intlist = new IntArrayList();
                this.field_199215_f.put(p_199205_1_, (Object)intlist);
            }
            intlist.add(p_199205_2_);
        }

        public Dynamic<?> func_210051_a() {
            Dynamic dynamic = this.field_199213_d;
            if (!this.field_199214_e) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.field_199211_b.stream()));
            int i = Math.max(4, DataFixUtils.ceillog2((int)this.field_199217_h.size()));
            ArbitraryBitLengthIntArray arbitrarybitlengthintarray = new ArbitraryBitLengthIntArray(i, 4096);
            for (int j = 0; j < this.field_199218_i.length; ++j) {
                arbitrarybitlengthintarray.func_233049_a_(j, this.field_199218_i[j]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(arbitrarybitlengthintarray.func_233047_a_())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            return dynamic.remove("Add");
        }
    }

    static class NibbleArray {
        private final byte[] field_210935_a;

        public NibbleArray() {
            this.field_210935_a = new byte[2048];
        }

        public NibbleArray(byte[] p_i49577_1_) {
            this.field_210935_a = p_i49577_1_;
            if (p_i49577_1_.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + p_i49577_1_.length);
            }
        }

        public int func_210932_a(int p_210932_1_, int p_210932_2_, int p_210932_3_) {
            int i = this.func_210934_b(p_210932_2_ << 8 | p_210932_3_ << 4 | p_210932_1_);
            return this.func_210933_a(p_210932_2_ << 8 | p_210932_3_ << 4 | p_210932_1_) ? this.field_210935_a[i] & 0xF : this.field_210935_a[i] >> 4 & 0xF;
        }

        private boolean func_210933_a(int p_210933_1_) {
            return (p_210933_1_ & 1) == 0;
        }

        private int func_210934_b(int p_210934_1_) {
            return p_210934_1_ >> 1;
        }
    }

    public static enum Direction {
        DOWN(Offset.NEGATIVE, Axis.Y),
        UP(Offset.POSITIVE, Axis.Y),
        NORTH(Offset.NEGATIVE, Axis.Z),
        SOUTH(Offset.POSITIVE, Axis.Z),
        WEST(Offset.NEGATIVE, Axis.X),
        EAST(Offset.POSITIVE, Axis.X);

        private final Axis field_210941_g;
        private final Offset field_210942_h;

        private Direction(Offset p_i49576_3_, Axis p_i49576_4_) {
            this.field_210941_g = p_i49576_4_;
            this.field_210942_h = p_i49576_3_;
        }

        public Offset func_210939_a() {
            return this.field_210942_h;
        }

        public Axis func_210940_b() {
            return this.field_210941_g;
        }

        public static enum Offset {
            POSITIVE(1),
            NEGATIVE(-1);

            private final int field_210938_c;

            private Offset(int p_i49694_3_) {
                this.field_210938_c = p_i49694_3_;
            }

            public int func_210937_a() {
                return this.field_210938_c;
            }
        }

        public static enum Axis {
            X,
            Y,
            Z;

        }
    }
}

