/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.vector;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Immutable
public class Vector3i
implements Comparable<Vector3i> {
    public static final Codec<Vector3i> field_239781_c_ = Codec.INT_STREAM.comapFlatMap(p_239783_0_ -> Util.func_240987_a_(p_239783_0_, 3).map(p_239784_0_ -> new Vector3i(p_239784_0_[0], p_239784_0_[1], p_239784_0_[2])), p_239782_0_ -> IntStream.of(p_239782_0_.func_177958_n(), p_239782_0_.func_177956_o(), p_239782_0_.func_177952_p()));
    public static final Vector3i field_177959_e = new Vector3i(0, 0, 0);
    private int field_177962_a;
    private int field_177960_b;
    private int field_177961_c;

    public Vector3i(int p_i46007_1_, int p_i46007_2_, int p_i46007_3_) {
        this.field_177962_a = p_i46007_1_;
        this.field_177960_b = p_i46007_2_;
        this.field_177961_c = p_i46007_3_;
    }

    public Vector3i(double p_i46008_1_, double p_i46008_3_, double p_i46008_5_) {
        this(MathHelper.func_76128_c((double)p_i46008_1_), MathHelper.func_76128_c((double)p_i46008_3_), MathHelper.func_76128_c((double)p_i46008_5_));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vector3i)) {
            return false;
        }
        Vector3i vector3i = (Vector3i)p_equals_1_;
        if (this.func_177958_n() != vector3i.func_177958_n()) {
            return false;
        }
        if (this.func_177956_o() != vector3i.func_177956_o()) {
            return false;
        }
        return this.func_177952_p() == vector3i.func_177952_p();
    }

    public int hashCode() {
        return (this.func_177956_o() + this.func_177952_p() * 31) * 31 + this.func_177958_n();
    }

    @Override
    public int compareTo(Vector3i p_compareTo_1_) {
        if (this.func_177956_o() == p_compareTo_1_.func_177956_o()) {
            return this.func_177952_p() == p_compareTo_1_.func_177952_p() ? this.func_177958_n() - p_compareTo_1_.func_177958_n() : this.func_177952_p() - p_compareTo_1_.func_177952_p();
        }
        return this.func_177956_o() - p_compareTo_1_.func_177956_o();
    }

    public int func_177958_n() {
        return this.field_177962_a;
    }

    public int func_177956_o() {
        return this.field_177960_b;
    }

    public int func_177952_p() {
        return this.field_177961_c;
    }

    public void func_223471_o(int p_223471_1_) {
        this.field_177962_a = p_223471_1_;
    }

    public void func_185336_p(int p_185336_1_) {
        this.field_177960_b = p_185336_1_;
    }

    public void func_223472_q(int p_223472_1_) {
        this.field_177961_c = p_223472_1_;
    }

    public Vector3i func_177984_a() {
        return this.func_177981_b(1);
    }

    public Vector3i func_177981_b(int p_177981_1_) {
        return this.func_177967_a(Direction.UP, p_177981_1_);
    }

    public Vector3i func_177977_b() {
        return this.func_177979_c(1);
    }

    public Vector3i func_177979_c(int p_177979_1_) {
        return this.func_177967_a(Direction.DOWN, p_177979_1_);
    }

    public Vector3i func_177967_a(Direction p_177967_1_, int p_177967_2_) {
        return p_177967_2_ == 0 ? this : new Vector3i(this.func_177958_n() + p_177967_1_.func_82601_c() * p_177967_2_, this.func_177956_o() + p_177967_1_.func_96559_d() * p_177967_2_, this.func_177952_p() + p_177967_1_.func_82599_e() * p_177967_2_);
    }

    public Vector3i func_177955_d(Vector3i p_177955_1_) {
        return new Vector3i(this.func_177956_o() * p_177955_1_.func_177952_p() - this.func_177952_p() * p_177955_1_.func_177956_o(), this.func_177952_p() * p_177955_1_.func_177958_n() - this.func_177958_n() * p_177955_1_.func_177952_p(), this.func_177958_n() * p_177955_1_.func_177956_o() - this.func_177956_o() * p_177955_1_.func_177958_n());
    }

    public boolean func_218141_a(Vector3i p_218141_1_, double p_218141_2_) {
        return this.func_218140_a(p_218141_1_.func_177958_n(), p_218141_1_.func_177956_o(), p_218141_1_.func_177952_p(), false) < p_218141_2_ * p_218141_2_;
    }

    public boolean func_218137_a(IPosition p_218137_1_, double p_218137_2_) {
        return this.func_218140_a(p_218137_1_.func_82615_a(), p_218137_1_.func_82617_b(), p_218137_1_.func_82616_c(), true) < p_218137_2_ * p_218137_2_;
    }

    public final double distanceSquared(Vector3i baseblockposition) {
        return this.func_177951_i(baseblockposition);
    }

    public double func_177951_i(Vector3i p_177951_1_) {
        return this.func_218140_a(p_177951_1_.func_177958_n(), p_177951_1_.func_177956_o(), p_177951_1_.func_177952_p(), true);
    }

    public double func_218138_a(IPosition p_218138_1_, boolean p_218138_2_) {
        return this.func_218140_a(p_218138_1_.func_82615_a(), p_218138_1_.func_82617_b(), p_218138_1_.func_82616_c(), p_218138_2_);
    }

    public double func_218140_a(double p_218140_1_, double p_218140_3_, double p_218140_5_, boolean p_218140_7_) {
        double d0 = p_218140_7_ ? 0.5 : 0.0;
        double d1 = (double)this.func_177958_n() + d0 - p_218140_1_;
        double d2 = (double)this.func_177956_o() + d0 - p_218140_3_;
        double d3 = (double)this.func_177952_p() + d0 - p_218140_5_;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public int func_218139_n(Vector3i p_218139_1_) {
        float f = Math.abs(p_218139_1_.func_177958_n() - this.func_177958_n());
        float f1 = Math.abs(p_218139_1_.func_177956_o() - this.func_177956_o());
        float f2 = Math.abs(p_218139_1_.func_177952_p() - this.func_177952_p());
        return (int)(f + f1 + f2);
    }

    public int func_243648_a(Direction.Axis p_243648_1_) {
        return p_243648_1_.func_196052_a(this.field_177962_a, this.field_177960_b, this.field_177961_c);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.func_177958_n()).add("y", this.func_177956_o()).add("z", this.func_177952_p()).toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_229422_x_() {
        return "" + this.func_177958_n() + ", " + this.func_177956_o() + ", " + this.func_177952_p();
    }
}

