/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoverEvent {
    private static final Logger field_240660_a_ = LogManager.getLogger();
    private final Action<?> field_150704_a;
    private final Object field_150703_b;

    public <T> HoverEvent(Action<T> p_i232564_1_, T p_i232564_2_) {
        this.field_150704_a = p_i232564_1_;
        this.field_150703_b = p_i232564_2_;
    }

    public Action<?> func_150701_a() {
        return this.field_150704_a;
    }

    @Nullable
    public <T> T func_240662_a_(Action<T> p_240662_1_) {
        return (T)(this.field_150704_a == p_240662_1_ ? ((Action)p_240662_1_).func_240674_b_(this.field_150703_b) : null);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            HoverEvent hoverevent = (HoverEvent)p_equals_1_;
            return this.field_150704_a == hoverevent.field_150704_a && Objects.equals(this.field_150703_b, hoverevent.field_150703_b);
        }
        return false;
    }

    public String toString() {
        return "HoverEvent{action=" + this.field_150704_a + ", value='" + this.field_150703_b + '\'' + '}';
    }

    public int hashCode() {
        int i = this.field_150704_a.hashCode();
        return 31 * i + (this.field_150703_b != null ? this.field_150703_b.hashCode() : 0);
    }

    @Nullable
    public static HoverEvent func_240661_a_(JsonObject p_240661_0_) {
        String s = JSONUtils.func_151219_a((JsonObject)p_240661_0_, (String)"action", (String)null);
        if (s == null) {
            return null;
        }
        Action action = Action.func_150684_a(s);
        if (action == null) {
            return null;
        }
        JsonElement jsonelement = p_240661_0_.get("contents");
        if (jsonelement != null) {
            return action.func_240668_a_(jsonelement);
        }
        IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240641_a_(p_240661_0_.get("value"));
        return itextcomponent != null ? action.func_240670_a_((ITextComponent)itextcomponent) : null;
    }

    public JsonObject func_240663_b_() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("action", this.field_150704_a.func_150685_b());
        jsonobject.add("contents", this.field_150704_a.func_240669_a_(this.field_150703_b));
        return jsonobject;
    }

    public static class ItemHover {
        private final Item field_240685_a_;
        private final int field_240686_b_;
        @Nullable
        private final CompoundNBT field_240687_c_;
        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        private ItemStack field_240688_d_;

        ItemHover(Item p_i232567_1_, int p_i232567_2_, @Nullable CompoundNBT p_i232567_3_) {
            this.field_240685_a_ = p_i232567_1_;
            this.field_240686_b_ = p_i232567_2_;
            this.field_240687_c_ = p_i232567_3_;
        }

        public ItemHover(ItemStack p_i232568_1_) {
            this(p_i232568_1_.func_77973_b(), p_i232568_1_.func_190916_E(), p_i232568_1_.func_77978_p() != null ? p_i232568_1_.func_77978_p().func_74737_b() : null);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                ItemHover hoverevent$itemhover = (ItemHover)p_equals_1_;
                return this.field_240686_b_ == hoverevent$itemhover.field_240686_b_ && ((Object)((Object)this.field_240685_a_)).equals((Object)hoverevent$itemhover.field_240685_a_) && Objects.equals(this.field_240687_c_, hoverevent$itemhover.field_240687_c_);
            }
            return false;
        }

        public int hashCode() {
            int i = ((Object)((Object)this.field_240685_a_)).hashCode();
            i = 31 * i + this.field_240686_b_;
            return 31 * i + (this.field_240687_c_ != null ? this.field_240687_c_.hashCode() : 0);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_240689_a_() {
            if (this.field_240688_d_ == null) {
                this.field_240688_d_ = new ItemStack(this.field_240685_a_, this.field_240686_b_);
                if (this.field_240687_c_ != null) {
                    this.field_240688_d_.func_77982_d(this.field_240687_c_);
                }
            }
            return this.field_240688_d_;
        }

        private static ItemHover func_240694_b_(JsonElement p_240694_0_) {
            if (p_240694_0_.isJsonPrimitive()) {
                return new ItemHover((Item)((Object)Registry.field_212630_s.func_82594_a(new ResourceLocation(p_240694_0_.getAsString()))), 1, null);
            }
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_240694_0_, (String)"item");
            Item item = (Item)((Object)Registry.field_212630_s.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"id"))));
            int i = JSONUtils.func_151208_a((JsonObject)jsonobject, (String)"count", (int)1);
            if (jsonobject.has("tag")) {
                String s = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"tag");
                try {
                    CompoundNBT compoundnbt = JsonToNBT.func_180713_a(s);
                    return new ItemHover(item, i, compoundnbt);
                }
                catch (CommandSyntaxException commandsyntaxexception) {
                    field_240660_a_.warn(i18n.get((String)"hoverevent.1", (Object[])new Object[]{s}), (Throwable)commandsyntaxexception);
                }
            }
            return new ItemHover(item, i, null);
        }

        @Nullable
        private static ItemHover func_240695_b_(ITextComponent p_240695_0_) {
            try {
                CompoundNBT compoundnbt = JsonToNBT.func_180713_a(p_240695_0_.getString());
                return new ItemHover(ItemStack.func_199557_a(compoundnbt));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                field_240660_a_.warn(i18n.get((String)"hoverevent.2", (Object[])new Object[]{p_240695_0_}), (Throwable)commandsyntaxexception);
                return null;
            }
        }

        private JsonElement func_240693_b_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", Registry.field_212630_s.func_177774_c((Object)this.field_240685_a_).toString());
            if (this.field_240686_b_ != 1) {
                jsonobject.addProperty("count", (Number)this.field_240686_b_);
            }
            if (this.field_240687_c_ != null) {
                jsonobject.addProperty("tag", this.field_240687_c_.toString());
            }
            return jsonobject;
        }
    }

    public static class EntityHover {
        public final EntityType<?> field_240677_a_;
        public final UUID field_240678_b_;
        @Nullable
        public final ITextComponent field_240679_c_;
        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        private List<ITextComponent> field_240680_d_;

        public EntityHover(EntityType<?> p_i232566_1_, UUID p_i232566_2_, @Nullable ITextComponent p_i232566_3_) {
            this.field_240677_a_ = p_i232566_1_;
            this.field_240678_b_ = p_i232566_2_;
            this.field_240679_c_ = p_i232566_3_;
        }

        @Nullable
        public static EntityHover func_240682_a_(JsonElement p_240682_0_) {
            if (!p_240682_0_.isJsonObject()) {
                return null;
            }
            JsonObject jsonobject = p_240682_0_.getAsJsonObject();
            EntityType entitytype = (EntityType)((Object)Registry.field_212629_r.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"type"))));
            UUID uuid = UUID.fromString(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"id"));
            IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240641_a_(jsonobject.get("name"));
            return new EntityHover(entitytype, uuid, (ITextComponent)itextcomponent);
        }

        @Nullable
        public static EntityHover func_240683_a_(ITextComponent p_240683_0_) {
            try {
                CompoundNBT compoundnbt = JsonToNBT.func_180713_a(p_240683_0_.getString());
                IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_(compoundnbt.func_74779_i("name"));
                EntityType entitytype = (EntityType)((Object)Registry.field_212629_r.func_82594_a(new ResourceLocation(compoundnbt.func_74779_i("type"))));
                UUID uuid = UUID.fromString(compoundnbt.func_74779_i("id"));
                return new EntityHover(entitytype, uuid, (ITextComponent)itextcomponent);
            }
            catch (JsonSyntaxException | CommandSyntaxException jsonsyntaxexception) {
                return null;
            }
        }

        public JsonElement func_240681_a_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("type", Registry.field_212629_r.func_177774_c(this.field_240677_a_).toString());
            jsonobject.addProperty("id", this.field_240678_b_.toString());
            if (this.field_240679_c_ != null) {
                jsonobject.add("name", ITextComponent.Serializer.func_200528_b(this.field_240679_c_));
            }
            return jsonobject;
        }

        @OnlyIn(value=Dist.CLIENT)
        public List<ITextComponent> func_240684_b_() {
            if (this.field_240680_d_ == null) {
                this.field_240680_d_ = Lists.newArrayList();
                if (this.field_240679_c_ != null) {
                    this.field_240680_d_.add(this.field_240679_c_);
                }
                this.field_240680_d_.add((ITextComponent)((Object)new TranslationTextComponent("gui.entity_tooltip.type", this.field_240677_a_.func_212546_e())));
                this.field_240680_d_.add((ITextComponent)new StringTextComponent(this.field_240678_b_.toString()));
            }
            return this.field_240680_d_;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                EntityHover hoverevent$entityhover = (EntityHover)p_equals_1_;
                return ((Object)this.field_240677_a_).equals(hoverevent$entityhover.field_240677_a_) && this.field_240678_b_.equals(hoverevent$entityhover.field_240678_b_) && Objects.equals(this.field_240679_c_, hoverevent$entityhover.field_240679_c_);
            }
            return false;
        }

        public int hashCode() {
            int i = ((Object)this.field_240677_a_).hashCode();
            i = 31 * i + this.field_240678_b_.hashCode();
            return 31 * i + (this.field_240679_c_ != null ? this.field_240679_c_.hashCode() : 0);
        }
    }

    public static class Action<T> {
        public static final Action<ITextComponent> field_230550_a_ = new Action<ITextComponent>("show_text", true, ITextComponent.Serializer::func_240641_a_, ITextComponent.Serializer::func_200528_b, Function.identity());
        public static final Action<ItemHover> field_230551_b_ = new Action<ItemHover>("show_item", true, p_240673_0_ -> ItemHover.access$300(p_240673_0_), p_240676_0_ -> ItemHover.access$200(p_240676_0_), p_240675_0_ -> ItemHover.access$100(p_240675_0_));
        public static final Action<EntityHover> field_230552_c_ = new Action<EntityHover>("show_entity", true, EntityHover::func_240682_a_, EntityHover::func_240681_a_, EntityHover::func_240683_a_);
        private static final Map<String, Action> field_150690_d = (Map)Stream.of(field_230550_a_, field_230551_b_, field_230552_c_).collect(ImmutableMap.toImmutableMap(Action::func_150685_b, p_240671_0_ -> p_240671_0_));
        private final String field_150688_f;
        private final boolean field_150691_e;
        private final Function<JsonElement, T> field_240665_g_;
        private final Function<T, JsonElement> field_240666_h_;
        private final Function<ITextComponent, T> field_240667_i_;

        public Action(String p_i232565_1_, boolean p_i232565_2_, Function<JsonElement, T> p_i232565_3_, Function<T, JsonElement> p_i232565_4_, Function<ITextComponent, T> p_i232565_5_) {
            this.field_150688_f = p_i232565_1_;
            this.field_150691_e = p_i232565_2_;
            this.field_240665_g_ = p_i232565_3_;
            this.field_240666_h_ = p_i232565_4_;
            this.field_240667_i_ = p_i232565_5_;
        }

        public boolean func_150686_a() {
            return this.field_150691_e;
        }

        public String func_150685_b() {
            return this.field_150688_f;
        }

        @Nullable
        public static Action func_150684_a(String p_150684_0_) {
            return field_150690_d.get(p_150684_0_);
        }

        private T func_240674_b_(Object p_240674_1_) {
            return (T)p_240674_1_;
        }

        @Nullable
        public HoverEvent func_240668_a_(JsonElement p_240668_1_) {
            T t = this.field_240665_g_.apply(p_240668_1_);
            return t == null ? null : new HoverEvent(this, t);
        }

        @Nullable
        public HoverEvent func_240670_a_(ITextComponent p_240670_1_) {
            T t = this.field_240667_i_.apply(p_240670_1_);
            return t == null ? null : new HoverEvent(this, t);
        }

        public JsonElement func_240669_a_(Object p_240669_1_) {
            return this.field_240666_h_.apply(this.func_240674_b_(p_240669_1_));
        }

        public String toString() {
            return "<action " + this.field_150688_f + ">";
        }
    }
}

