/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.SuppressedExceptions;

public final class RegionFileCache
implements AutoCloseable {
    private final Long2ObjectLinkedOpenHashMap<RegionFile> field_219102_c = new Long2ObjectLinkedOpenHashMap();
    private final File field_219101_a;
    private final boolean field_235986_c_;

    RegionFileCache(File p_i231895_1_, boolean p_i231895_2_) {
        this.field_219101_a = p_i231895_1_;
        this.field_235986_c_ = p_i231895_2_;
    }

    private RegionFile func_219098_a(ChunkPos p_219098_1_) throws IOException {
        return this.loadFile(p_219098_1_, false);
    }

    private RegionFile loadFile(ChunkPos pos, boolean existingOnly) throws IOException {
        long i = ChunkPos.func_77272_a(pos.func_222241_h(), pos.func_222242_i());
        RegionFile regionfile = (RegionFile)this.field_219102_c.getAndMoveToFirst(i);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.field_219102_c.size() >= 256) {
            ((RegionFile)this.field_219102_c.removeLast()).close();
        }
        if (!this.field_219101_a.exists()) {
            this.field_219101_a.mkdirs();
        }
        File file1 = new File(this.field_219101_a, "r." + pos.func_222241_h() + "." + pos.func_222242_i() + ".mca");
        if (existingOnly && !file1.exists()) {
            return null;
        }
        RegionFile regionfile1 = new RegionFile(file1, this.field_219101_a, this.field_235986_c_);
        this.field_219102_c.putAndMoveToFirst(i, (Object)regionfile1);
        return regionfile1;
    }

    @Nullable
    public CompoundNBT func_219099_e(ChunkPos p_219099_1_) throws IOException {
        Object object;
        RegionFile regionfile = this.loadFile(p_219099_1_, true);
        if (regionfile == null) {
            return null;
        }
        try (DataInputStream datainputstream = regionfile.func_222666_a(p_219099_1_);){
            if (datainputstream != null) {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74794_a(datainputstream);
                return compoundNBT;
            }
            object = null;
        }
        return object;
    }

    protected void func_219100_a(ChunkPos p_219100_1_, CompoundNBT p_219100_2_) throws IOException {
        RegionFile regionfile = this.loadFile(p_219100_1_, false);
        try (DataOutputStream dataoutputstream = regionfile.func_222661_c(p_219100_1_);){
            CompressedStreamTools.func_74800_a(p_219100_2_, dataoutputstream);
        }
    }

    @Override
    public void close() throws IOException {
        SuppressedExceptions suppressedexceptions = new SuppressedExceptions();
        for (RegionFile regionfile : this.field_219102_c.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                suppressedexceptions.func_233003_a_((Throwable)ioexception);
            }
        }
        suppressedexceptions.func_233002_a_();
    }

    public void func_235987_a_() throws IOException {
        for (RegionFile regionfile : this.field_219102_c.values()) {
            regionfile.func_235985_a_();
        }
    }
}

