/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mohistmc.util.i18n.i18n;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JigsawManager {
    private static final Logger field_214892_b = LogManager.getLogger();

    public static void func_242837_a(DynamicRegistries p_242837_0_, VillageConfig p_242837_1_, IPieceFactory p_242837_2_, ChunkGenerator p_242837_3_, TemplateManager p_242837_4_, BlockPos p_242837_5_, List<? super AbstractVillagePiece> p_242837_6_, Random p_242837_7_, boolean p_242837_8_, boolean p_242837_9_) {
        Structure.func_236397_g_();
        MutableRegistry<JigsawPattern> mutableregistry = p_242837_0_.func_243612_b(Registry.field_243555_ax);
        Rotation rotation = Rotation.func_222466_a((Random)p_242837_7_);
        JigsawPattern jigsawpattern = (JigsawPattern)p_242837_1_.func_242810_c().get();
        JigsawPiece jigsawpiece = jigsawpattern.func_214944_a(p_242837_7_);
        AbstractVillagePiece abstractvillagepiece = p_242837_2_.create(p_242837_4_, jigsawpiece, p_242837_5_, jigsawpiece.func_214850_d(), rotation, jigsawpiece.func_214852_a(p_242837_4_, p_242837_5_, rotation));
        MutableBoundingBox mutableboundingbox = abstractvillagepiece.func_74874_b();
        int i = (mutableboundingbox.field_78893_d + mutableboundingbox.field_78897_a) / 2;
        int j = (mutableboundingbox.field_78892_f + mutableboundingbox.field_78896_c) / 2;
        int k = p_242837_9_ ? p_242837_5_.func_177956_o() + p_242837_3_.func_222532_b(i, j, Heightmap.Type.WORLD_SURFACE_WG) : p_242837_5_.func_177956_o();
        int l = mutableboundingbox.field_78895_b + abstractvillagepiece.func_214830_d();
        abstractvillagepiece.func_181138_a(0, k - l, 0);
        p_242837_6_.add((AbstractVillagePiece)abstractvillagepiece);
        if (p_242837_1_.func_236534_a_() > 0) {
            int i1 = 80;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(i - 80, k - 80, j - 80, i + 80 + 1, k + 80 + 1, j + 80 + 1);
            Assembler jigsawmanager$assembler = new Assembler((Registry)mutableregistry, p_242837_1_.func_236534_a_(), p_242837_2_, p_242837_3_, p_242837_4_, p_242837_6_, p_242837_7_);
            jigsawmanager$assembler.field_214888_g.addLast(new Entry(abstractvillagepiece, new MutableObject((Object)VoxelShapes.func_197878_a(VoxelShapes.func_197881_a(axisalignedbb), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(mutableboundingbox)), IBooleanFunction.field_223234_e_)), k + 80, 0));
            while (!jigsawmanager$assembler.field_214888_g.isEmpty()) {
                Entry jigsawmanager$entry = (Entry)jigsawmanager$assembler.field_214888_g.removeFirst();
                jigsawmanager$assembler.func_236831_a_(jigsawmanager$entry.field_214876_a, (MutableObject<VoxelShape>)jigsawmanager$entry.field_214877_b, jigsawmanager$entry.field_214878_c, jigsawmanager$entry.field_214879_d, p_242837_8_);
            }
        }
    }

    public static void func_242838_a(DynamicRegistries p_242838_0_, AbstractVillagePiece p_242838_1_, int p_242838_2_, IPieceFactory p_242838_3_, ChunkGenerator p_242838_4_, TemplateManager p_242838_5_, List<? super AbstractVillagePiece> p_242838_6_, Random p_242838_7_) {
        MutableRegistry<JigsawPattern> mutableregistry = p_242838_0_.func_243612_b(Registry.field_243555_ax);
        Assembler jigsawmanager$assembler = new Assembler((Registry)mutableregistry, p_242838_2_, p_242838_3_, p_242838_4_, p_242838_5_, p_242838_6_, p_242838_7_);
        jigsawmanager$assembler.field_214888_g.addLast(new Entry(p_242838_1_, new MutableObject((Object)VoxelShapes.field_216389_a), 0, 0));
        while (!jigsawmanager$assembler.field_214888_g.isEmpty()) {
            Entry jigsawmanager$entry = (Entry)jigsawmanager$assembler.field_214888_g.removeFirst();
            jigsawmanager$assembler.func_236831_a_(jigsawmanager$entry.field_214876_a, (MutableObject<VoxelShape>)jigsawmanager$entry.field_214877_b, jigsawmanager$entry.field_214878_c, jigsawmanager$entry.field_214879_d, false);
        }
    }

    public static interface IPieceFactory {
        public AbstractVillagePiece create(TemplateManager var1, JigsawPiece var2, BlockPos var3, int var4, Rotation var5, MutableBoundingBox var6);
    }

    static final class Entry {
        private final AbstractVillagePiece field_214876_a;
        private final MutableObject<VoxelShape> field_214877_b;
        private final int field_214878_c;
        private final int field_214879_d;

        private Entry(AbstractVillagePiece p_i232042_1_, MutableObject<VoxelShape> p_i232042_2_, int p_i232042_3_, int p_i232042_4_) {
            this.field_214876_a = p_i232042_1_;
            this.field_214877_b = p_i232042_2_;
            this.field_214878_c = p_i232042_3_;
            this.field_214879_d = p_i232042_4_;
        }
    }

    static final class Assembler {
        private final Registry<JigsawPattern> field_242839_a;
        private final int field_214882_a;
        private final IPieceFactory field_214883_b;
        private final ChunkGenerator field_214884_c;
        private final TemplateManager field_214885_d;
        private final List<? super AbstractVillagePiece> field_214886_e;
        private final Random field_214887_f;
        private final Deque<Entry> field_214888_g = Queues.newArrayDeque();

        private Assembler(Registry<JigsawPattern> p_i242005_1_, int p_i242005_2_, IPieceFactory p_i242005_3_, ChunkGenerator p_i242005_4_, TemplateManager p_i242005_5_, List<? super AbstractVillagePiece> p_i242005_6_, Random p_i242005_7_) {
            this.field_242839_a = p_i242005_1_;
            this.field_214882_a = p_i242005_2_;
            this.field_214883_b = p_i242005_3_;
            this.field_214884_c = p_i242005_4_;
            this.field_214885_d = p_i242005_5_;
            this.field_214886_e = p_i242005_6_;
            this.field_214887_f = p_i242005_7_;
        }

        private void func_236831_a_(AbstractVillagePiece p_236831_1_, MutableObject<VoxelShape> p_236831_2_, int p_236831_3_, int p_236831_4_, boolean p_236831_5_) {
            JigsawPiece jigsawpiece = p_236831_1_.func_214826_b();
            BlockPos blockpos = p_236831_1_.func_214828_c();
            Rotation rotation = p_236831_1_.func_214809_Y_();
            JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = jigsawpiece.func_214854_c();
            boolean flag = jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            MutableBoundingBox mutableboundingbox = p_236831_1_.func_74874_b();
            int i = mutableboundingbox.field_78895_b;
            block0: for (Template.BlockInfo template$blockinfo : jigsawpiece.func_214849_a(this.field_214885_d, blockpos, rotation, this.field_214887_f)) {
                Direction direction = JigsawBlock.func_235508_h_((BlockState)template$blockinfo.field_186243_b);
                BlockPos blockpos1 = template$blockinfo.field_186242_a;
                BlockPos blockpos2 = blockpos1.func_177972_a(direction);
                int j = blockpos1.func_177956_o() - i;
                int k = -1;
                ResourceLocation resourcelocation = new ResourceLocation(template$blockinfo.field_186244_c.func_74779_i("pool"));
                Optional<JigsawPattern> optional = this.field_242839_a.func_241873_b(resourcelocation);
                if (optional.isPresent() && (optional.get().func_214946_c() != 0 || Objects.equals(resourcelocation, JigsawPatternRegistry.field_244091_a.func_240901_a_()))) {
                    ResourceLocation resourcelocation1 = optional.get().func_214948_a();
                    Optional<JigsawPattern> optional1 = this.field_242839_a.func_241873_b(resourcelocation1);
                    if (optional1.isPresent() && (optional1.get().func_214946_c() != 0 || Objects.equals(resourcelocation1, JigsawPatternRegistry.field_244091_a.func_240901_a_()))) {
                        JigsawPiece jigsawpiece1;
                        int l;
                        MutableObject<VoxelShape> mutableobject1;
                        boolean flag1 = mutableboundingbox.func_175898_b(blockpos2);
                        if (flag1) {
                            mutableobject1 = mutableobject;
                            l = i;
                            if (mutableobject.getValue() == null) {
                                mutableobject.setValue((Object)VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(mutableboundingbox)));
                            }
                        } else {
                            mutableobject1 = p_236831_2_;
                            l = p_236831_3_;
                        }
                        ArrayList list = Lists.newArrayList();
                        if (p_236831_4_ != this.field_214882_a) {
                            list.addAll(optional.get().func_214943_b(this.field_214887_f));
                        }
                        list.addAll(optional1.get().func_214943_b(this.field_214887_f));
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (jigsawpiece1 = (JigsawPiece)iterator.next()) != EmptyJigsawPiece.field_214856_a) {
                            for (Rotation rotation1 : Rotation.func_222467_b((Random)this.field_214887_f)) {
                                List list1 = jigsawpiece1.func_214849_a(this.field_214885_d, BlockPos.field_177992_a, rotation1, this.field_214887_f);
                                MutableBoundingBox mutableboundingbox1 = jigsawpiece1.func_214852_a(this.field_214885_d, BlockPos.field_177992_a, rotation1);
                                int i1 = p_236831_5_ && mutableboundingbox1.func_78882_c() <= 16 ? list1.stream().mapToInt(p_242841_2_ -> {
                                    if (!mutableboundingbox1.func_175898_b(p_242841_2_.field_186242_a.func_177972_a(JigsawBlock.func_235508_h_((BlockState)p_242841_2_.field_186243_b)))) {
                                        return 0;
                                    }
                                    ResourceLocation resourcelocation2 = new ResourceLocation(p_242841_2_.field_186244_c.func_74779_i("pool"));
                                    Optional<JigsawPattern> optional2 = this.field_242839_a.func_241873_b(resourcelocation2);
                                    Optional<Integer> optional3 = optional2.flatMap(p_242843_1_ -> this.field_242839_a.func_241873_b(p_242843_1_.func_214948_a()));
                                    int k3 = optional2.map(p_242842_1_ -> p_242842_1_.func_214945_a(this.field_214885_d)).orElse(0);
                                    int l3 = optional3.map(p_242840_1_ -> p_242840_1_.func_214945_a(this.field_214885_d)).orElse(0);
                                    return Math.max(k3, l3);
                                }).max().orElse(0) : 0;
                                for (Template.BlockInfo template$blockinfo1 : list1) {
                                    int i3;
                                    int i2;
                                    if (!JigsawBlock.func_220171_a((Template.BlockInfo)template$blockinfo, (Template.BlockInfo)template$blockinfo1)) continue;
                                    BlockPos blockpos3 = template$blockinfo1.field_186242_a;
                                    BlockPos blockpos4 = new BlockPos(blockpos2.func_177958_n() - blockpos3.func_177958_n(), blockpos2.func_177956_o() - blockpos3.func_177956_o(), blockpos2.func_177952_p() - blockpos3.func_177952_p());
                                    MutableBoundingBox mutableboundingbox2 = jigsawpiece1.func_214852_a(this.field_214885_d, blockpos4, rotation1);
                                    int j1 = mutableboundingbox2.field_78895_b;
                                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour1 = jigsawpiece1.func_214854_c();
                                    boolean flag2 = jigsawpattern$placementbehaviour1 == JigsawPattern.PlacementBehaviour.RIGID;
                                    int k1 = blockpos3.func_177956_o();
                                    int l1 = j - k1 + JigsawBlock.func_235508_h_((BlockState)template$blockinfo.field_186243_b).func_96559_d();
                                    if (flag && flag2) {
                                        i2 = i + l1;
                                    } else {
                                        if (k == -1) {
                                            k = this.field_214884_c.func_222532_b(blockpos1.func_177958_n(), blockpos1.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                        }
                                        i2 = k - k1;
                                    }
                                    int j2 = i2 - j1;
                                    MutableBoundingBox mutableboundingbox3 = mutableboundingbox2.func_215127_b(0, j2, 0);
                                    BlockPos blockpos5 = blockpos4.func_177982_a(0, j2, 0);
                                    if (i1 > 0) {
                                        int k2 = Math.max(i1 + 1, mutableboundingbox3.field_78894_e - mutableboundingbox3.field_78895_b);
                                        mutableboundingbox3.field_78894_e = mutableboundingbox3.field_78895_b + k2;
                                    }
                                    if (VoxelShapes.func_197879_c((VoxelShape)mutableobject1.getValue(), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(mutableboundingbox3).func_186664_h(0.25)), IBooleanFunction.field_223232_c_)) continue;
                                    mutableobject1.setValue((Object)VoxelShapes.func_197882_b((VoxelShape)mutableobject1.getValue(), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(mutableboundingbox3)), IBooleanFunction.field_223234_e_));
                                    int j3 = p_236831_1_.func_214830_d();
                                    int l2 = flag2 ? j3 - l1 : jigsawpiece1.func_214850_d();
                                    AbstractVillagePiece abstractvillagepiece = this.field_214883_b.create(this.field_214885_d, jigsawpiece1, blockpos5, l2, rotation1, mutableboundingbox3);
                                    if (flag) {
                                        i3 = i + j;
                                    } else if (flag2) {
                                        i3 = i2 + k1;
                                    } else {
                                        if (k == -1) {
                                            k = this.field_214884_c.func_222532_b(blockpos1.func_177958_n(), blockpos1.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                        }
                                        i3 = k + l1 / 2;
                                    }
                                    p_236831_1_.func_214831_a(new JigsawJunction(blockpos2.func_177958_n(), i3 - j + j3, blockpos2.func_177952_p(), l1, jigsawpattern$placementbehaviour1));
                                    abstractvillagepiece.func_214831_a(new JigsawJunction(blockpos1.func_177958_n(), i3 - k1 + l2, blockpos1.func_177952_p(), -l1, jigsawpattern$placementbehaviour));
                                    this.field_214886_e.add((AbstractVillagePiece)abstractvillagepiece);
                                    if (p_236831_4_ + 1 > this.field_214882_a) continue block0;
                                    this.field_214888_g.addLast(new Entry(abstractvillagepiece, mutableobject1, l, p_236831_4_ + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    field_214892_b.warn(i18n.get((String)"jigsawmanager.1", (Object[])new Object[]{resourcelocation1}));
                    continue;
                }
                field_214892_b.warn(i18n.get((String)"jigsawmanager.2", (Object[])new Object[]{resourcelocation}));
            }
        }
    }
}

