/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TemplateStructurePiece
extends StructurePiece {
    private static final Logger field_214825_d = LogManager.getLogger();
    protected Template field_186176_a;
    protected PlacementSettings field_186177_b;
    protected BlockPos field_186178_c;

    public TemplateStructurePiece(IStructurePieceType p_i51338_1_, int p_i51338_2_) {
        super(p_i51338_1_, p_i51338_2_);
    }

    public TemplateStructurePiece(IStructurePieceType p_i51339_1_, CompoundNBT p_i51339_2_) {
        super(p_i51339_1_, p_i51339_2_);
        this.field_186178_c = new BlockPos(p_i51339_2_.func_74762_e("TPX"), p_i51339_2_.func_74762_e("TPY"), p_i51339_2_.func_74762_e("TPZ"));
    }

    protected void func_186173_a(Template p_186173_1_, BlockPos p_186173_2_, PlacementSettings p_186173_3_) {
        this.field_186176_a = p_186173_1_;
        this.func_186164_a(Direction.NORTH);
        this.field_186178_c = p_186173_2_;
        this.field_186177_b = p_186173_3_;
        this.field_74887_e = p_186173_1_.func_215388_b(p_186173_3_, p_186173_2_);
    }

    @Override
    protected void func_143011_b(CompoundNBT p_143011_1_) {
        p_143011_1_.func_74768_a("TPX", this.field_186178_c.func_177958_n());
        p_143011_1_.func_74768_a("TPY", this.field_186178_c.func_177956_o());
        p_143011_1_.func_74768_a("TPZ", this.field_186178_c.func_177952_p());
    }

    @Override
    public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        this.field_186177_b.func_186223_a(p_230383_5_);
        this.field_74887_e = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
        if (this.field_186176_a.func_237146_a_((IServerWorld)p_230383_1_, this.field_186178_c, p_230383_7_, this.field_186177_b, p_230383_4_, 2)) {
            for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_185779_df)) {
                StructureMode structuremode;
                if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                this.func_186175_a(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, (IServerWorld)p_230383_1_, p_230383_4_, p_230383_5_);
            }
            for (Template.BlockInfo template$blockinfo1 : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_226904_lY_)) {
                if (template$blockinfo1.field_186244_c == null) continue;
                String s = template$blockinfo1.field_186244_c.func_74779_i("final_state");
                BlockStateParser blockstateparser = new BlockStateParser(new StringReader(s), false);
                BlockState blockstate = Blocks.field_150350_a.func_176223_P();
                try {
                    blockstateparser.func_197243_a(true);
                    BlockState blockstate1 = blockstateparser.func_197249_b();
                    if (blockstate1 != null) {
                        blockstate = blockstate1;
                    } else {
                        field_214825_d.error(i18n.get((String)"templatestructurepiece.1", (Object[])new Object[]{s, template$blockinfo1.field_186242_a}));
                    }
                }
                catch (CommandSyntaxException commandsyntaxexception) {
                    field_214825_d.error(i18n.get((String)"templatestructurepiece.2", (Object[])new Object[]{s, template$blockinfo1.field_186242_a}));
                }
                p_230383_1_.func_180501_a(template$blockinfo1.field_186242_a, blockstate, 3);
            }
        }
        return true;
    }

    protected abstract void func_186175_a(String var1, BlockPos var2, IServerWorld var3, Random var4, MutableBoundingBox var5);

    @Override
    public void func_181138_a(int p_181138_1_, int p_181138_2_, int p_181138_3_) {
        super.func_181138_a(p_181138_1_, p_181138_2_, p_181138_3_);
        this.field_186178_c = this.field_186178_c.func_177982_a(p_181138_1_, p_181138_2_, p_181138_3_);
    }

    @Override
    public Rotation func_214809_Y_() {
        return this.field_186177_b.func_186215_c();
    }
}

