/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DataFixer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.FileUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemplateManager {
    private static final Logger field_195431_a = LogManager.getLogger();
    private final Map<ResourceLocation, Template> field_186240_a = Maps.newConcurrentMap();
    private final DataFixer field_191154_c;
    private IResourceManager field_237130_d_;
    private final Path field_195433_e;

    public TemplateManager(IResourceManager p_i232119_1_, SaveFormat.LevelSave p_i232119_2_, DataFixer p_i232119_3_) {
        this.field_237130_d_ = p_i232119_1_;
        this.field_191154_c = p_i232119_3_;
        this.field_195433_e = p_i232119_2_.func_237285_a_(FolderName.field_237250_f_).normalize();
    }

    public Template func_200220_a(ResourceLocation p_200220_1_) {
        Template template = this.func_200219_b(p_200220_1_);
        if (template == null) {
            template = new Template();
            this.field_186240_a.put(p_200220_1_, template);
        }
        return template;
    }

    @Nullable
    public Template func_200219_b(ResourceLocation p_200219_1_) {
        return this.field_186240_a.computeIfAbsent(p_200219_1_, p_209204_1_ -> {
            Template template = this.func_195428_d((ResourceLocation)p_209204_1_);
            return template != null ? template : this.func_209201_e((ResourceLocation)p_209204_1_);
        });
    }

    public void func_195410_a(IResourceManager p_195410_1_) {
        this.field_237130_d_ = p_195410_1_;
        this.field_186240_a.clear();
    }

    @Nullable
    private Template func_209201_e(ResourceLocation p_209201_1_) {
        Template template;
        block9: {
            ResourceLocation resourcelocation = new ResourceLocation(p_209201_1_.func_110624_b(), "structures/" + p_209201_1_.func_110623_a() + ".nbt");
            IResource iresource = this.field_237130_d_.func_199002_a(resourcelocation);
            try {
                template = this.func_209205_a(iresource.func_199027_b());
                if (iresource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (iresource != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException filenotfoundexception) {
                    return null;
                }
                catch (Throwable throwable3) {
                    field_195431_a.error(i18n.get((String)"templatemanager.1", (Object[])new Object[]{p_209201_1_, throwable3.toString()}));
                    return null;
                }
            }
            iresource.close();
        }
        return template;
    }

    @Nullable
    private Template func_195428_d(ResourceLocation p_195428_1_) {
        Template template;
        if (!this.field_195433_e.toFile().isDirectory()) {
            return null;
        }
        Path path = this.func_209510_b(p_195428_1_, ".nbt");
        FileInputStream inputstream = new FileInputStream(path.toFile());
        try {
            template = this.func_209205_a(inputstream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputstream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException filenotfoundexception) {
                return null;
            }
            catch (IOException ioexception) {
                field_195431_a.error(i18n.get((String)"templatemanager.2", (Object[])new Object[]{path}), (Throwable)ioexception);
                return null;
            }
        }
        ((InputStream)inputstream).close();
        return template;
    }

    private Template func_209205_a(InputStream p_209205_1_) throws IOException {
        CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(p_209205_1_);
        return this.func_227458_a_(compoundnbt);
    }

    public Template func_227458_a_(CompoundNBT p_227458_1_) {
        if (!p_227458_1_.func_150297_b("DataVersion", 99)) {
            p_227458_1_.func_74768_a("DataVersion", 500);
        }
        Template template = new Template();
        template.func_186256_b(NBTUtil.func_210822_a(this.field_191154_c, DefaultTypeReferences.STRUCTURE, p_227458_1_, p_227458_1_.func_74762_e("DataVersion")));
        return template;
    }

    public boolean func_195429_b(ResourceLocation p_195429_1_) {
        boolean bl;
        Template template = this.field_186240_a.get(p_195429_1_);
        if (template == null) {
            return false;
        }
        Path path = this.func_209510_b(p_195429_1_, ".nbt");
        Path path1 = path.getParent();
        if (path1 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path1, new LinkOption[0]) ? path1.toRealPath(new LinkOption[0]) : path1, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            field_195431_a.error(i18n.get((String)"templatemanager.3", (Object[])new Object[]{path1}));
            return false;
        }
        CompoundNBT compoundnbt = template.func_189552_a(new CompoundNBT());
        FileOutputStream outputstream = new FileOutputStream(path.toFile());
        try {
            CompressedStreamTools.func_74799_a(compoundnbt, outputstream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputstream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return false;
            }
        }
        ((OutputStream)outputstream).close();
        return bl;
    }

    public Path func_209509_a(ResourceLocation p_209509_1_, String p_209509_2_) {
        try {
            Path path = this.field_195433_e.resolve(p_209509_1_.func_110624_b());
            Path path1 = path.resolve("structures");
            return FileUtil.func_214993_b((Path)path1, (String)p_209509_1_.func_110623_a(), (String)p_209509_2_);
        }
        catch (InvalidPathException invalidpathexception) {
            throw new ResourceLocationException("Invalid resource path: " + p_209509_1_, (Throwable)invalidpathexception);
        }
    }

    private Path func_209510_b(ResourceLocation p_209510_1_, String p_209510_2_) {
        if (p_209510_1_.func_110623_a().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + p_209510_1_);
        }
        Path path = this.func_209509_a(p_209510_1_, p_209510_2_);
        if (path.startsWith(this.field_195433_e) && FileUtil.func_214995_a((Path)path) && FileUtil.func_214994_b((Path)path)) {
            return path;
        }
        throw new ResourceLocationException("Invalid resource path: " + path);
    }

    public void func_189941_a(ResourceLocation p_189941_1_) {
        this.field_186240_a.remove(p_189941_1_);
    }
}

