/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.MapFrame;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_16_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_16_R3.map.RenderData;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;

public class MapData
extends WorldSavedData {
    private static final Logger field_237240_k_ = LogManager.getLogger();
    public int field_76201_a;
    public int field_76199_b;
    public RegistryKey<World> field_76200_c;
    public boolean field_186210_e;
    public boolean field_191096_f;
    public byte field_76197_d;
    public byte[] field_76198_e = new byte[16384];
    public boolean field_215161_h;
    public final List<MapInfo> field_76196_g = Lists.newArrayList();
    private final Map<PlayerEntity, MapInfo> field_76202_j = Maps.newHashMap();
    private final Map<String, MapBanner> field_204270_k = Maps.newHashMap();
    public final Map<String, MapDecoration> field_76203_h = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> field_212442_l = Maps.newHashMap();
    private RenderData vanillaRender = new RenderData();
    public final CraftMapView mapView = new CraftMapView(this);
    private CraftServer server = (CraftServer)Bukkit.getServer();
    private UUID uniqueId = null;

    public MapData(String p_i2140_1_) {
        super(p_i2140_1_);
        this.vanillaRender.buffer = this.field_76198_e;
    }

    public void func_237241_a_(int p_237241_1_, int p_237241_2_, int p_237241_3_, boolean p_237241_4_, boolean p_237241_5_, RegistryKey<World> p_237241_6_) {
        this.field_76197_d = (byte)p_237241_3_;
        this.func_176054_a(p_237241_1_, p_237241_2_, this.field_76197_d);
        this.field_76200_c = p_237241_6_;
        this.field_186210_e = p_237241_4_;
        this.field_191096_f = p_237241_5_;
        this.func_76185_a();
    }

    public void func_176054_a(double p_176054_1_, double p_176054_3_, int p_176054_5_) {
        int i = 128 * (1 << p_176054_5_);
        int j = MathHelper.func_76128_c((double)((p_176054_1_ + 64.0) / (double)i));
        int k = MathHelper.func_76128_c((double)((p_176054_3_ + 64.0) / (double)i));
        this.field_76201_a = j * i + i / 2 - 64;
        this.field_76199_b = k * i + i / 2 - 64;
    }

    @Override
    public void func_76184_a(CompoundNBT p_76184_1_) {
        INBT dimension = p_76184_1_.func_74781_a("dimension");
        if (dimension instanceof NumberNBT && ((NumberNBT)dimension).func_150287_d() >= 10) {
            long least = p_76184_1_.func_74763_f("UUIDLeast");
            long most = p_76184_1_.func_74763_f("UUIDMost");
            if (least != 0L && most != 0L) {
                this.uniqueId = new UUID(most, least);
                CraftWorld world = (CraftWorld)this.server.getWorld(this.uniqueId);
                dimension = world != null ? StringNBT.func_229705_a_("minecaft:" + world.getName().toLowerCase(Locale.ENGLISH)) : StringNBT.func_229705_a_("bukkit:_invalidworld_");
            } else {
                dimension = StringNBT.func_229705_a_("bukkit:_invalidworld_");
            }
        }
        DataResult dataresult = DimensionType.func_236025_a_((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)p_76184_1_.func_74781_a("dimension")));
        this.field_76200_c = dataresult.resultOrPartial(arg_0 -> ((Logger)field_237240_k_).error(arg_0)).orElseGet(() -> {
            long least = p_76184_1_.func_74763_f("UUIDLeast");
            long most = p_76184_1_.func_74763_f("UUIDMost");
            if (least != 0L && most != 0L) {
                this.uniqueId = new UUID(most, least);
                CraftWorld world = (CraftWorld)this.server.getWorld(this.uniqueId);
                if (world != null) {
                    return world.getHandle().func_234923_W_();
                }
            }
            throw new IllegalArgumentException("Invalid map dimension: " + p_76184_1_.func_74781_a("dimension"));
        });
        this.field_76201_a = p_76184_1_.func_74762_e("xCenter");
        this.field_76199_b = p_76184_1_.func_74762_e("zCenter");
        this.field_76197_d = (byte)MathHelper.func_76125_a((int)p_76184_1_.func_74771_c("scale"), (int)0, (int)4);
        this.field_186210_e = !p_76184_1_.func_150297_b("trackingPosition", 1) || p_76184_1_.func_74767_n("trackingPosition");
        this.field_191096_f = p_76184_1_.func_74767_n("unlimitedTracking");
        this.field_215161_h = p_76184_1_.func_74767_n("locked");
        this.field_76198_e = p_76184_1_.func_74770_j("colors");
        if (this.field_76198_e.length != 16384) {
            this.field_76198_e = new byte[16384];
        }
        ListNBT listnbt = p_76184_1_.func_150295_c("banners", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            MapBanner mapbanner = MapBanner.func_204300_a((CompoundNBT)listnbt.func_150305_b(i));
            this.field_204270_k.put(mapbanner.func_204299_f(), mapbanner);
            this.func_191095_a(mapbanner.func_204305_c(), null, mapbanner.func_204299_f(), mapbanner.func_204304_a().func_177958_n(), mapbanner.func_204304_a().func_177952_p(), 180.0, mapbanner.func_204302_d());
        }
        this.vanillaRender.buffer = this.field_76198_e;
        ListNBT listnbt1 = p_76184_1_.func_150295_c("frames", 10);
        for (int j = 0; j < listnbt1.size(); ++j) {
            MapFrame mapframe = MapFrame.func_212765_a((CompoundNBT)listnbt1.func_150305_b(j));
            this.field_212442_l.put(mapframe.func_212767_e(), mapframe);
            this.func_191095_a(MapDecoration.Type.FRAME, null, "frame-" + mapframe.func_212769_d(), mapframe.func_212764_b().func_177958_n(), mapframe.func_212764_b().func_177952_p(), mapframe.func_212768_c(), null);
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT p_189551_1_) {
        ResourceLocation.field_240908_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_76200_c.func_240901_a_()).resultOrPartial(arg_0 -> ((Logger)field_237240_k_).error(arg_0)).ifPresent(p_237242_1_ -> p_189551_1_.func_218657_a("dimension", (INBT)p_237242_1_));
        if (this.uniqueId == null) {
            for (Object world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().func_234923_W_() != this.field_76200_c) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            p_189551_1_.func_74772_a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            p_189551_1_.func_74772_a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        p_189551_1_.func_74768_a("xCenter", this.field_76201_a);
        p_189551_1_.func_74768_a("zCenter", this.field_76199_b);
        p_189551_1_.func_74774_a("scale", this.field_76197_d);
        p_189551_1_.func_74773_a("colors", this.field_76198_e);
        p_189551_1_.func_74757_a("trackingPosition", this.field_186210_e);
        p_189551_1_.func_74757_a("unlimitedTracking", this.field_191096_f);
        p_189551_1_.func_74757_a("locked", this.field_215161_h);
        ListNBT listnbt = new ListNBT();
        for (MapBanner mapbanner : this.field_204270_k.values()) {
            listnbt.add((Object)mapbanner.func_204303_e());
        }
        p_189551_1_.func_218657_a("banners", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (MapFrame mapframe : this.field_212442_l.values()) {
            listnbt1.add((Object)mapframe.func_212770_a());
        }
        p_189551_1_.func_218657_a("frames", (INBT)listnbt1);
        return p_189551_1_;
    }

    public void func_215160_a(MapData p_215160_1_) {
        this.field_215161_h = true;
        this.field_76201_a = p_215160_1_.field_76201_a;
        this.field_76199_b = p_215160_1_.field_76199_b;
        this.field_204270_k.putAll(p_215160_1_.field_204270_k);
        this.field_76203_h.putAll(p_215160_1_.field_76203_h);
        System.arraycopy(p_215160_1_.field_76198_e, 0, this.field_76198_e, 0, p_215160_1_.field_76198_e.length);
        this.func_76185_a();
    }

    public void updateSeenPlayers(PlayerEntity entityhuman, ItemStack itemstack) {
        this.func_76191_a(entityhuman, itemstack);
    }

    public void func_76191_a(PlayerEntity p_76191_1_, ItemStack p_76191_2_) {
        CompoundNBT compoundnbt;
        if (!this.field_76202_j.containsKey(p_76191_1_)) {
            MapInfo mapdata$mapinfo = new MapInfo(p_76191_1_);
            this.field_76202_j.put(p_76191_1_, mapdata$mapinfo);
            this.field_76196_g.add(mapdata$mapinfo);
        }
        if (!p_76191_1_.field_71071_by.func_70431_c(p_76191_2_)) {
            this.field_76203_h.remove(p_76191_1_.func_200200_C_().getString());
        }
        for (int i = 0; i < this.field_76196_g.size(); ++i) {
            MapInfo mapdata$mapinfo1 = this.field_76196_g.get(i);
            String s = mapdata$mapinfo1.field_76211_a.func_200200_C_().getString();
            if (!mapdata$mapinfo1.field_76211_a.field_70128_L && (mapdata$mapinfo1.field_76211_a.field_71071_by.func_70431_c(p_76191_2_) || p_76191_2_.func_82839_y())) {
                if (p_76191_2_.func_82839_y() || mapdata$mapinfo1.field_76211_a.field_70170_p.func_234923_W_() != this.field_76200_c || !this.field_186210_e) continue;
                this.func_191095_a(MapDecoration.Type.PLAYER, mapdata$mapinfo1.field_76211_a.field_70170_p, s, mapdata$mapinfo1.field_76211_a.func_226277_ct_(), mapdata$mapinfo1.field_76211_a.func_226281_cx_(), mapdata$mapinfo1.field_76211_a.field_70177_z, null);
                continue;
            }
            this.field_76202_j.remove(mapdata$mapinfo1.field_76211_a);
            this.field_76196_g.remove(mapdata$mapinfo1);
            this.field_76203_h.remove(s);
        }
        if (p_76191_2_.func_82839_y() && this.field_186210_e) {
            ItemFrameEntity itemframeentity = p_76191_2_.func_82836_z();
            BlockPos blockpos = itemframeentity.func_174857_n();
            MapFrame mapframe1 = this.field_212442_l.get(MapFrame.func_212766_a((BlockPos)blockpos));
            if (mapframe1 != null && itemframeentity.func_145782_y() != mapframe1.func_212769_d() && this.field_212442_l.containsKey(mapframe1.func_212767_e())) {
                this.field_76203_h.remove("frame-" + mapframe1.func_212769_d());
            }
            MapFrame mapframe = new MapFrame(blockpos, itemframeentity.func_174811_aO().func_176736_b() * 90, itemframeentity.func_145782_y());
            this.func_191095_a(MapDecoration.Type.FRAME, p_76191_1_.field_70170_p, "frame-" + itemframeentity.func_145782_y(), blockpos.func_177958_n(), blockpos.func_177952_p(), itemframeentity.func_174811_aO().func_176736_b() * 90, null);
            this.field_212442_l.put(mapframe.func_212767_e(), mapframe);
        }
        if ((compoundnbt = p_76191_2_.func_77978_p()) != null && compoundnbt.func_150297_b("Decorations", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("Decorations", 10);
            for (int j = 0; j < listnbt.size(); ++j) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(j);
                if (this.field_76203_h.containsKey(compoundnbt1.func_74779_i("id"))) continue;
                this.func_191095_a(MapDecoration.Type.func_191159_a(compoundnbt1.func_74771_c("type")), p_76191_1_.field_70170_p, compoundnbt1.func_74779_i("id"), compoundnbt1.func_74769_h("x"), compoundnbt1.func_74769_h("z"), compoundnbt1.func_74769_h("rot"), null);
            }
        }
    }

    public static void func_191094_a(ItemStack p_191094_0_, BlockPos p_191094_1_, String p_191094_2_, MapDecoration.Type p_191094_3_) {
        ListNBT listnbt;
        if (p_191094_0_.func_77942_o() && p_191094_0_.func_77978_p().func_150297_b("Decorations", 9)) {
            listnbt = p_191094_0_.func_77978_p().func_150295_c("Decorations", 10);
        } else {
            listnbt = new ListNBT();
            p_191094_0_.func_77983_a("Decorations", (INBT)listnbt);
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74774_a("type", p_191094_3_.func_191163_a());
        compoundnbt.func_74778_a("id", p_191094_2_);
        compoundnbt.func_74780_a("x", p_191094_1_.func_177958_n());
        compoundnbt.func_74780_a("z", p_191094_1_.func_177952_p());
        compoundnbt.func_74780_a("rot", 180.0);
        listnbt.add((Object)compoundnbt);
        if (p_191094_3_.func_191162_c()) {
            CompoundNBT compoundnbt1 = p_191094_0_.func_190925_c("display");
            compoundnbt1.func_74768_a("MapColor", p_191094_3_.func_191161_d());
        }
    }

    private void func_191095_a(MapDecoration.Type p_191095_1_, @Nullable IWorld p_191095_2_, String p_191095_3_, double p_191095_4_, double p_191095_6_, double p_191095_8_, @Nullable ITextComponent p_191095_10_) {
        byte b2;
        int i = 1 << this.field_76197_d;
        float f = (float)(p_191095_4_ - (double)this.field_76201_a) / (float)i;
        float f1 = (float)(p_191095_6_ - (double)this.field_76199_b) / (float)i;
        byte b0 = (byte)((double)(f * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        int j = 63;
        if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((p_191095_8_ += p_191095_8_ < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.field_76200_c == World.field_234919_h_ && p_191095_2_ != null) {
                int l = (int)(p_191095_2_.func_72912_H().func_76073_f() / 10L);
                b2 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
        } else {
            if (p_191095_1_ != MapDecoration.Type.PLAYER) {
                this.field_76203_h.remove(p_191095_3_);
                return;
            }
            int k = 320;
            if (Math.abs(f) < 320.0f && Math.abs(f1) < 320.0f) {
                p_191095_1_ = MapDecoration.Type.PLAYER_OFF_MAP;
            } else {
                if (!this.field_191096_f) {
                    this.field_76203_h.remove(p_191095_3_);
                    return;
                }
                p_191095_1_ = MapDecoration.Type.PLAYER_OFF_LIMITS;
            }
            b2 = 0;
            if (f <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        this.field_76203_h.put(p_191095_3_, new MapDecoration(p_191095_1_, b0, b1, b2, p_191095_10_));
    }

    @Nullable
    public IPacket<?> func_176052_a(ItemStack p_176052_1_, IBlockReader p_176052_2_, PlayerEntity p_176052_3_) {
        MapInfo mapdata$mapinfo = this.field_76202_j.get(p_176052_3_);
        return mapdata$mapinfo == null ? null : mapdata$mapinfo.func_176101_a(p_176052_1_);
    }

    public void func_176053_a(int p_176053_1_, int p_176053_2_) {
        this.func_76185_a();
        for (MapInfo mapdata$mapinfo : this.field_76196_g) {
            mapdata$mapinfo.func_176102_a(p_176053_1_, p_176053_2_);
        }
    }

    public MapInfo func_82568_a(PlayerEntity p_82568_1_) {
        MapInfo mapdata$mapinfo = this.field_76202_j.get(p_82568_1_);
        if (mapdata$mapinfo == null) {
            mapdata$mapinfo = new MapInfo(p_82568_1_);
            this.field_76202_j.put(p_82568_1_, mapdata$mapinfo);
            this.field_76196_g.add(mapdata$mapinfo);
        }
        return mapdata$mapinfo;
    }

    public void func_204269_a(IWorld p_204269_1_, BlockPos p_204269_2_) {
        double d0 = (double)p_204269_2_.func_177958_n() + 0.5;
        double d1 = (double)p_204269_2_.func_177952_p() + 0.5;
        int i = 1 << this.field_76197_d;
        double d2 = (d0 - (double)this.field_76201_a) / (double)i;
        double d3 = (d1 - (double)this.field_76199_b) / (double)i;
        int j = 63;
        boolean flag = false;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapBanner mapbanner = MapBanner.func_204301_a((IBlockReader)((Object)p_204269_1_), (BlockPos)p_204269_2_);
            if (mapbanner == null) {
                return;
            }
            boolean flag1 = true;
            if (this.field_204270_k.containsKey(mapbanner.func_204299_f()) && this.field_204270_k.get(mapbanner.func_204299_f()).equals((Object)mapbanner)) {
                this.field_204270_k.remove(mapbanner.func_204299_f());
                this.field_76203_h.remove(mapbanner.func_204299_f());
                flag1 = false;
                flag = true;
            }
            if (flag1) {
                this.field_204270_k.put(mapbanner.func_204299_f(), mapbanner);
                this.func_191095_a(mapbanner.func_204305_c(), p_204269_1_, mapbanner.func_204299_f(), d0, d1, 180.0, mapbanner.func_204302_d());
                flag = true;
            }
            if (flag) {
                this.func_76185_a();
            }
        }
    }

    public void func_204268_a(IBlockReader p_204268_1_, int p_204268_2_, int p_204268_3_) {
        Iterator<MapBanner> iterator = this.field_204270_k.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapbanner1;
            MapBanner mapbanner = iterator.next();
            if (mapbanner.func_204304_a().func_177958_n() != p_204268_2_ || mapbanner.func_204304_a().func_177952_p() != p_204268_3_ || mapbanner.equals((Object)(mapbanner1 = MapBanner.func_204301_a((IBlockReader)p_204268_1_, (BlockPos)mapbanner.func_204304_a())))) continue;
            iterator.remove();
            this.field_76203_h.remove(mapbanner.func_204299_f());
        }
    }

    public void func_212441_a(BlockPos p_212441_1_, int p_212441_2_) {
        this.field_76203_h.remove("frame-" + p_212441_2_);
        this.field_212442_l.remove(MapFrame.func_212766_a((BlockPos)p_212441_1_));
    }

    public class MapInfo {
        public final PlayerEntity field_76211_a;
        private boolean field_176105_d = true;
        private int field_176106_e;
        private int field_176103_f;
        private int field_176104_g = 127;
        private int field_176108_h = 127;
        private int field_176109_i;
        public int field_82569_d;

        private void addSeenPlayers(Collection<MapDecoration> icons) {
            Player player = (Player)this.field_76211_a.getBukkitEntity();
            MapData.this.field_76203_h.forEach((name, mapIcon) -> {
                Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapDecoration)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return MapData.this.mapView.getRenderers().size() == 1 && ((MapRenderer)MapData.this.mapView.getRenderers().get(0)).getClass() == CraftMapRenderer.class;
        }

        public MapInfo(PlayerEntity p_i2138_2_) {
            this.field_76211_a = p_i2138_2_;
        }

        @Nullable
        public IPacket<?> func_176101_a(ItemStack p_176101_1_) {
            RenderData render = MapData.this.mapView.render((CraftPlayer)this.field_76211_a.getBukkitEntity());
            ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
            for (MapCursor cursor : render.cursors) {
                if (!cursor.isVisible()) continue;
                icons.add(new MapDecoration(MapDecoration.Type.func_191159_a(cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull((String)cursor.getCaption())));
            }
            if (this.field_176105_d) {
                this.field_176105_d = false;
                return new SMapDataPacket(FilledMapItem.func_195949_f(p_176101_1_), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_215161_h, icons, render.buffer, this.field_176106_e, this.field_176103_f, this.field_176104_g + 1 - this.field_176106_e, this.field_176108_h + 1 - this.field_176103_f);
            }
            return this.field_176109_i++ % 5 == 0 ? new SMapDataPacket(FilledMapItem.func_195949_f(p_176101_1_), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_215161_h, icons, render.buffer, 0, 0, 0, 0) : null;
        }

        public void func_176102_a(int p_176102_1_, int p_176102_2_) {
            if (this.field_176105_d) {
                this.field_176106_e = Math.min(this.field_176106_e, p_176102_1_);
                this.field_176103_f = Math.min(this.field_176103_f, p_176102_2_);
                this.field_176104_g = Math.max(this.field_176104_g, p_176102_1_);
                this.field_176108_h = Math.max(this.field_176108_h, p_176102_2_);
            } else {
                this.field_176105_d = true;
                this.field_176106_e = p_176102_1_;
                this.field_176103_f = p_176102_2_;
                this.field_176104_g = p_176102_1_;
                this.field_176108_h = p_176102_2_;
            }
        }
    }
}

