/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.network.download.DownloadSource;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.CustomFlagsHandler;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.i18n.i18n;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Scanner;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.server.ServerMain;

public class DownloadJava {
    public static File java = new File("CustomJAVA/");
    public static File javabin = new File("CustomJAVA/bin/");
    public static ArrayList<String> launchArgs = new ArrayList();
    private static File javadl = new File(java.getAbsolutePath() + "/java.zip");

    public static void run() throws Exception {
        if (!ServerMain.mainArgs.contains("launchedWithCustomJava11")) {
            if (!javabin.exists() && !MohistConfigUtil.bMohist("use_custom_java11", "false").booleanValue()) {
                System.out.println(i18n.get("oldjava.action"));
                System.out.println(i18n.get("oldjava.serveronly"));
                Scanner scan = new Scanner(System.in);
                String input = scan.nextLine();
                if (input.equalsIgnoreCase("Yes")) {
                    DownloadJava.searchJava();
                } else {
                    System.out.println(i18n.get("oldjava.no"));
                }
            } else {
                DownloadJava.searchJava();
            }
        }
    }

    public static void searchJava() throws Exception {
        String url = DownloadSource.get().getUrl();
        if (System.getProperty("sun.arch.data.model").equals("64")) {
            if (DownloadJava.os().equals("Windows")) {
                DownloadJava.prepareLaunch(url + "mohist_1_16_5_jre11/javawin64.zip", "java.exe");
            } else if (DownloadJava.os().equals("Unix")) {
                DownloadJava.prepareLaunch(url + "mohist_1_16_5_jre11/javalinux64.zip", "java");
            } else if (DownloadJava.os().equals("Mac")) {
                DownloadJava.prepareLaunch(url + "mohist_1_16_5_jre11/javamac64.zip", "java");
            }
        } else if (DownloadJava.os().equals("Windows")) {
            DownloadJava.prepareLaunch(url + "mohist_1_16_5_jre11/javawin32.zip", "java.exe");
        } else if (DownloadJava.os().equals("Unix")) {
            DownloadJava.prepareLaunch(url + "mohist_1_16_5_jre11/javalinux32.zip", "java");
        }
    }

    private static void prepareLaunch(String URL2, String javaName) throws Exception {
        if (!javabin.exists()) {
            java.mkdirs();
            java.createNewFile();
            System.out.println(i18n.get("oldjava.yes"));
            UpdateUtils.downloadFile(URL2, javadl);
            System.out.println(i18n.get("oldjava.unzip.start"));
            DownloadJava.unzip(new FileInputStream(javadl), java.toPath());
            System.out.println(i18n.get("oldjava.unzip.completed"));
            javadl.delete();
            if (DownloadJava.os().equals("Unix") || DownloadJava.os().equals("Mac")) {
                Runtime.getRuntime().exec("chmod 755 -R ./CustomJAVA");
            }
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(java.getAbsolutePath() + "/bin/" + javaName, "-jar"));
        launchArgs.addAll(CustomFlagsHandler.getCustomFlags());
        launchArgs.add(JarTool.getJarName());
        launchArgs.addAll(ServerMain.mainArgs);
        launchArgs.add("launchedWithCustomJava11");
        if (CustomFlagsHandler.hasCustomFlags) {
            launchArgs.add("launchedWithCustomArgs");
        }
        command.addAll(launchArgs);
        command.removeIf(s -> s.toLowerCase().contains("-xms"));
        System.out.println(i18n.get("oldjava.run", DownloadJava.os(), String.join((CharSequence)" ", command)));
        UpdateUtils.restartServer(command, true);
    }

    public static void unzip(InputStream is, Path targetDir) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(ze.getName());
                if (ze.isDirectory() && !Files.exists(resolvedPath, new LinkOption[0])) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                if (!Files.exists(resolvedPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(zipIn, resolvedPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static String os() {
        String o = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return o.contains("win") ? "Windows" : (o.contains("mac") ? "Mac" : (Stream.of("solaris", "sunos", "linux", "unix").anyMatch(o::contains) ? "Unix" : "Unknown"));
    }
}

