/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.concurrent.ITaskQueue;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOWorker
implements AutoCloseable {
    private static final Logger field_227080_a_ = LogManager.getLogger();
    private final AtomicBoolean field_227082_c_ = new AtomicBoolean();
    private final DelegatedTaskExecutor<ITaskQueue.RunnableWithPriority> field_235969_c_;
    private final RegionFileCache field_227084_e_;
    private final Map<ChunkPos, Entry> field_227085_f_ = Maps.newLinkedHashMap();

    protected IOWorker(File file, boolean bl, String string) {
        this.field_227084_e_ = new RegionFileCache(file, bl);
        this.field_235969_c_ = new DelegatedTaskExecutor<ITaskQueue.RunnableWithPriority>(new ITaskQueue.Priority(Priority.values().length), Util.func_240992_g_(), "IOWorker-" + string);
    }

    public CompletableFuture<Void> func_227093_a_(ChunkPos chunkPos, CompoundNBT compoundNBT) {
        return this.func_235975_a_(() -> {
            Entry entry = this.field_227085_f_.computeIfAbsent(chunkPos, chunkPos -> new Entry(compoundNBT));
            entry.field_227113_a_ = compoundNBT;
            return Either.left((Object)entry.field_227114_b_);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundNBT func_227090_a_(ChunkPos chunkPos) throws IOException {
        CompletableFuture completableFuture = this.func_235975_a_(() -> {
            Entry entry = this.field_227085_f_.get(chunkPos);
            if (entry != null) {
                return Either.left((Object)entry.field_227113_a_);
            }
            try {
                CompoundNBT compoundNBT = this.field_227084_e_.func_219099_e(chunkPos);
                return Either.left((Object)compoundNBT);
            }
            catch (Exception exception) {
                field_227080_a_.warn("Failed to read chunk {}", (Object)chunkPos, (Object)exception);
                return Either.right((Object)exception);
            }
        });
        try {
            return (CompoundNBT)completableFuture.join();
        }
        catch (CompletionException \u26032) {
            if (\u26032.getCause() instanceof IOException) {
                throw (IOException)\u26032.getCause();
            }
            throw \u26032;
        }
    }

    public CompletableFuture<Void> func_227088_a_() {
        CompletionStage completionStage = this.func_235975_a_(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.field_227085_f_.values().stream().map(entry -> ((Entry)entry).field_227114_b_).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        return ((CompletableFuture)completionStage).thenCompose(void_ -> this.func_235975_a_(() -> {
            try {
                this.field_227084_e_.func_235987_a_();
                return Either.left(null);
            }
            catch (Exception exception) {
                field_227080_a_.warn("Failed to synchronized chunks", (Throwable)exception);
                return Either.right((Object)exception);
            }
        }));
    }

    private <T> CompletableFuture<T> func_235975_a_(Supplier<Either<T, Exception>> supplier) {
        return this.field_235969_c_.func_233528_c_(iTaskExecutor -> new ITaskQueue.RunnableWithPriority(Priority.HIGH.ordinal(), () -> this.func_235972_a_(iTaskExecutor, (Supplier)supplier)));
    }

    private void func_235978_b_() {
        Iterator<Map.Entry<ChunkPos, Entry>> iterator = this.field_227085_f_.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Map.Entry<ChunkPos, Entry> \u26032 = iterator.next();
        iterator.remove();
        this.func_227091_a_(\u26032.getKey(), \u26032.getValue());
        this.func_235982_c_();
    }

    private void func_235982_c_() {
        this.field_235969_c_.func_212871_a_(new ITaskQueue.RunnableWithPriority(Priority.LOW.ordinal(), this::func_235978_b_));
    }

    private void func_227091_a_(ChunkPos chunkPos, Entry entry) {
        try {
            this.field_227084_e_.func_219100_a(chunkPos, entry.field_227113_a_);
            entry.field_227114_b_.complete(null);
        }
        catch (Exception exception) {
            field_227080_a_.error("Failed to store chunk {}", (Object)chunkPos, (Object)exception);
            entry.field_227114_b_.completeExceptionally(exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.field_227082_c_.compareAndSet(false, true)) {
            return;
        }
        CompletableFuture completableFuture = this.field_235969_c_.func_213141_a(iTaskExecutor -> new ITaskQueue.RunnableWithPriority(Priority.HIGH.ordinal(), () -> iTaskExecutor.func_212871_a_(Unit.INSTANCE)));
        try {
            completableFuture.join();
        }
        catch (CompletionException \u26032) {
            if (\u26032.getCause() instanceof IOException) {
                throw (IOException)\u26032.getCause();
            }
            throw \u26032;
        }
        this.field_235969_c_.close();
        this.field_227085_f_.forEach(this::func_227091_a_);
        this.field_227085_f_.clear();
        try {
            this.field_227084_e_.close();
        }
        catch (Exception \u26033) {
            field_227080_a_.error("Failed to close storage", (Throwable)\u26033);
        }
    }

    private /* synthetic */ void func_235972_a_(ITaskExecutor iTaskExecutor, Supplier supplier) {
        if (!this.field_227082_c_.get()) {
            iTaskExecutor.func_212871_a_(supplier.get());
        }
        this.func_235982_c_();
    }

    static class Entry {
        private CompoundNBT field_227113_a_;
        private final CompletableFuture<Void> field_227114_b_ = new CompletableFuture();

        public Entry(CompoundNBT compoundNBT) {
            this.field_227113_a_ = compoundNBT;
        }
    }

    static enum Priority {
        HIGH,
        LOW;

    }
}

