/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ColumnConfig;
import net.minecraft.world.gen.feature.Feature;

public class BasaltColumnFeature
extends Feature<ColumnConfig> {
    private static final ImmutableList<Block> field_236245_a_ = ImmutableList.of((Object)Blocks.field_150353_l, (Object)Blocks.field_150357_h, (Object)Blocks.field_196814_hQ, (Object)Blocks.field_150425_aM, (Object)Blocks.field_196653_dH, (Object)Blocks.field_150386_bk, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150388_bm, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150474_ac);

    public BasaltColumnFeature(Codec<ColumnConfig> codec) {
        super(codec);
    }

    @Override
    public boolean func_241855_a(ISeedReader iSeedReader, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, ColumnConfig columnConfig) {
        int n = chunkGenerator.func_230356_f_();
        if (!BasaltColumnFeature.func_242762_a(iSeedReader, n, blockPos.func_239590_i_())) {
            return false;
        }
        \u2603 = columnConfig.func_242795_b().func_242259_a(random);
        boolean \u26032 = random.nextFloat() < 0.9f;
        \u2603 = Math.min(\u2603, \u26032 ? 5 : 8);
        \u2603 = \u26032 ? 50 : 15;
        boolean \u26033 = false;
        for (BlockPos blockPos2 : BlockPos.func_239585_a_(random, \u2603, blockPos.func_177958_n() - \u2603, blockPos.func_177956_o(), blockPos.func_177952_p() - \u2603, blockPos.func_177958_n() + \u2603, blockPos.func_177956_o(), blockPos.func_177952_p() + \u2603)) {
            int n2 = \u2603 - blockPos2.func_218139_n(blockPos);
            if (n2 < 0) continue;
            \u26033 |= this.func_236248_a_(iSeedReader, n, blockPos2, n2, columnConfig.func_242794_am_().func_242259_a(random));
        }
        return \u26033;
    }

    private boolean func_236248_a_(IWorld iWorld2, int n, BlockPos blockPos, int n2, int n3) {
        boolean bl = false;
        block0: for (BlockPos blockPos2 : BlockPos.func_191531_b(blockPos.func_177958_n() - n3, blockPos.func_177956_o(), blockPos.func_177952_p() - n3, blockPos.func_177958_n() + n3, blockPos.func_177956_o(), blockPos.func_177952_p() + n3)) {
            int n4 = blockPos2.func_218139_n(blockPos);
            BlockPos blockPos3 = \u2603 = BasaltColumnFeature.func_236247_a_(iWorld2, n, blockPos2) ? BasaltColumnFeature.func_236246_a_(iWorld2, n, blockPos2.func_239590_i_(), n4) : BasaltColumnFeature.func_236249_a_(iWorld2, blockPos2.func_239590_i_(), n4);
            if (\u2603 == null) continue;
            BlockPos.Mutable \u26032 = \u2603.func_239590_i_();
            for (\u2603 = n2 - n4 / 2; \u2603 >= 0; --\u2603) {
                IWorld iWorld2;
                if (BasaltColumnFeature.func_236247_a_(iWorld2, n, \u26032)) {
                    this.func_230367_a_(iWorld2, \u26032, Blocks.field_235337_cO_.func_176223_P());
                    \u26032.func_189536_c(Direction.UP);
                    bl = true;
                    continue;
                }
                if (!iWorld2.func_180495_p(\u26032).func_203425_a(Blocks.field_235337_cO_)) continue block0;
                \u26032.func_189536_c(Direction.UP);
            }
        }
        return bl;
    }

    @Nullable
    private static BlockPos func_236246_a_(IWorld iWorld, int n, BlockPos.Mutable mutable, int n2) {
        while (mutable.func_177956_o() > 1 && n2 > 0) {
            --n2;
            if (BasaltColumnFeature.func_242762_a(iWorld, n, mutable)) {
                return mutable;
            }
            mutable.func_189536_c(Direction.DOWN);
        }
        return null;
    }

    private static boolean func_242762_a(IWorld iWorld, int n, BlockPos.Mutable mutable) {
        if (BasaltColumnFeature.func_236247_a_(iWorld, n, mutable)) {
            BlockState blockState = iWorld.func_180495_p(mutable.func_189536_c(Direction.DOWN));
            mutable.func_189536_c(Direction.UP);
            return !blockState.func_196958_f() && !field_236245_a_.contains((Object)blockState.func_177230_c());
        }
        return false;
    }

    @Nullable
    private static BlockPos func_236249_a_(IWorld iWorld, BlockPos.Mutable mutable, int n) {
        while (mutable.func_177956_o() < iWorld.func_217301_I() && n > 0) {
            --n;
            BlockState blockState = iWorld.func_180495_p(mutable);
            if (field_236245_a_.contains((Object)blockState.func_177230_c())) {
                return null;
            }
            if (blockState.func_196958_f()) {
                return mutable;
            }
            mutable.func_189536_c(Direction.UP);
        }
        return null;
    }

    private static boolean func_236247_a_(IWorld iWorld, int n, BlockPos blockPos) {
        BlockState blockState = iWorld.func_180495_p(blockPos);
        return blockState.func_196958_f() || blockState.func_203425_a(Blocks.field_150353_l) && blockPos.func_177956_o() <= n;
    }
}

