/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IClearable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public class Template {
    private final List<Palette> field_204769_a = Lists.newArrayList();
    private final List<EntityInfo> field_186271_b = Lists.newArrayList();
    private BlockPos field_186272_c = BlockPos.field_177992_a;
    private String field_186273_d = "?";

    public BlockPos func_186259_a() {
        return this.field_186272_c;
    }

    public void func_186252_a(String string) {
        this.field_186273_d = string;
    }

    public String func_186261_b() {
        return this.field_186273_d;
    }

    public void func_186254_a(World world, BlockPos blockPos, BlockPos blockPos2, boolean bl, @Nullable Block block) {
        if (blockPos2.func_177958_n() < 1 || blockPos2.func_177956_o() < 1 || blockPos2.func_177952_p() < 1) {
            return;
        }
        BlockPos blockPos3 = blockPos.func_177971_a(blockPos2).func_177982_a(-1, -1, -1);
        ArrayList \u26032 = Lists.newArrayList();
        ArrayList \u26033 = Lists.newArrayList();
        ArrayList \u26034 = Lists.newArrayList();
        \u2603 = new BlockPos(Math.min(blockPos.func_177958_n(), blockPos3.func_177958_n()), Math.min(blockPos.func_177956_o(), blockPos3.func_177956_o()), Math.min(blockPos.func_177952_p(), blockPos3.func_177952_p()));
        \u2603 = new BlockPos(Math.max(blockPos.func_177958_n(), blockPos3.func_177958_n()), Math.max(blockPos.func_177956_o(), blockPos3.func_177956_o()), Math.max(blockPos.func_177952_p(), blockPos3.func_177952_p()));
        this.field_186272_c = blockPos2;
        for (BlockPos blockPos4 : BlockPos.func_218278_a(\u2603, \u2603)) {
            BlockInfo \u26036;
            \u2603 = blockPos4.func_177973_b(\u2603);
            BlockState blockState = world.func_180495_p(blockPos4);
            if (block != null && block == blockState.func_177230_c()) continue;
            TileEntity \u26035 = world.func_175625_s(blockPos4);
            if (\u26035 != null) {
                CompoundNBT compoundNBT = \u26035.func_189515_b(new CompoundNBT());
                compoundNBT.func_82580_o("x");
                compoundNBT.func_82580_o("y");
                compoundNBT.func_82580_o("z");
                \u26036 = new BlockInfo(\u2603, blockState, compoundNBT.func_74737_b());
            } else {
                \u26036 = new BlockInfo(\u2603, blockState, null);
            }
            Template.func_237149_a_(\u26036, \u26032, \u26033, \u26034);
        }
        List<BlockInfo> list = Template.func_237151_a_(\u26032, \u26033, \u26034);
        this.field_204769_a.clear();
        this.field_204769_a.add(new Palette(list));
        if (bl) {
            this.func_186255_a(world, \u2603, \u2603.func_177982_a(1, 1, 1));
        } else {
            this.field_186271_b.clear();
        }
    }

    private static void func_237149_a_(BlockInfo blockInfo, List<BlockInfo> list, List<BlockInfo> list2, List<BlockInfo> list3) {
        if (blockInfo.field_186244_c != null) {
            list2.add(blockInfo);
        } else if (!blockInfo.field_186243_b.func_177230_c().func_208619_r() && blockInfo.field_186243_b.func_235785_r_(EmptyBlockReader.INSTANCE, BlockPos.field_177992_a)) {
            list.add(blockInfo);
        } else {
            list3.add(blockInfo);
        }
    }

    private static List<BlockInfo> func_237151_a_(List<BlockInfo> list, List<BlockInfo> list2, List<BlockInfo> list3) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(blockInfo -> blockInfo.field_186242_a.func_177956_o()).thenComparingInt(blockInfo -> blockInfo.field_186242_a.func_177958_n()).thenComparingInt(blockInfo -> blockInfo.field_186242_a.func_177952_p());
        list.sort(comparator);
        list3.sort(comparator);
        list2.sort(comparator);
        ArrayList \u26032 = Lists.newArrayList();
        \u26032.addAll(list);
        \u26032.addAll(list3);
        \u26032.addAll(list2);
        return \u26032;
    }

    private void func_186255_a(World world, BlockPos blockPos, BlockPos blockPos2) {
        List<Entity> list = world.func_175647_a(Entity.class, new AxisAlignedBB(blockPos, blockPos2), entity -> !(entity instanceof PlayerEntity));
        this.field_186271_b.clear();
        for (Entity entity2 : list) {
            Vector3d vector3d = new Vector3d(entity2.func_226277_ct_() - (double)blockPos.func_177958_n(), entity2.func_226278_cu_() - (double)blockPos.func_177956_o(), entity2.func_226281_cx_() - (double)blockPos.func_177952_p());
            CompoundNBT \u26032 = new CompoundNBT();
            entity2.func_70039_c(\u26032);
            BlockPos \u26033 = entity2 instanceof PaintingEntity ? ((PaintingEntity)entity2).func_174857_n().func_177973_b(blockPos) : new BlockPos(vector3d);
            this.field_186271_b.add(new EntityInfo(vector3d, \u26033, \u26032.func_74737_b()));
        }
    }

    public List<BlockInfo> func_215381_a(BlockPos blockPos, PlacementSettings placementSettings, Block block) {
        return this.func_215386_a(blockPos, placementSettings, block, true);
    }

    public List<BlockInfo> func_215386_a(BlockPos blockPos, PlacementSettings placementSettings, Block block, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        MutableBoundingBox \u26032 = placementSettings.func_186213_g();
        if (this.field_204769_a.isEmpty()) {
            return Collections.emptyList();
        }
        for (BlockInfo blockInfo : placementSettings.func_237132_a_(this.field_204769_a, blockPos).func_237158_a_(block)) {
            BlockPos blockPos2 = \u2603 = bl ? Template.func_186266_a(placementSettings, blockInfo.field_186242_a).func_177971_a(blockPos) : blockInfo.field_186242_a;
            if (\u26032 != null && !\u26032.func_175898_b(\u2603)) continue;
            arrayList.add(new BlockInfo(\u2603, blockInfo.field_186243_b.func_185907_a(placementSettings.func_186215_c()), blockInfo.field_186244_c));
        }
        return arrayList;
    }

    public BlockPos func_186262_a(PlacementSettings placementSettings, BlockPos blockPos, PlacementSettings placementSettings2, BlockPos blockPos2) {
        \u2603 = Template.func_186266_a(placementSettings, blockPos);
        \u2603 = Template.func_186266_a(placementSettings2, blockPos2);
        return \u2603.func_177973_b(\u2603);
    }

    public static BlockPos func_186266_a(PlacementSettings placementSettings, BlockPos blockPos) {
        return Template.func_207669_a(blockPos, placementSettings.func_186212_b(), placementSettings.func_186215_c(), placementSettings.func_207664_d());
    }

    public void func_237144_a_(IServerWorld iServerWorld, BlockPos blockPos, PlacementSettings placementSettings, Random random) {
        placementSettings.func_186224_i();
        this.func_237152_b_(iServerWorld, blockPos, placementSettings, random);
    }

    public void func_237152_b_(IServerWorld iServerWorld, BlockPos blockPos, PlacementSettings placementSettings, Random random) {
        this.func_237146_a_(iServerWorld, blockPos, blockPos, placementSettings, random, 2);
    }

    public boolean func_237146_a_(IServerWorld iServerWorld, BlockPos blockPos, BlockPos blockPos2, PlacementSettings placementSettings2, Random random, int n) {
        Object object;
        if (this.field_204769_a.isEmpty()) {
            return false;
        }
        List<BlockInfo> list = placementSettings2.func_237132_a_(this.field_204769_a, blockPos).func_237157_a_();
        if (list.isEmpty() && (placementSettings2.func_186221_e() || this.field_186271_b.isEmpty()) || this.field_186272_c.func_177958_n() < 1 || this.field_186272_c.func_177956_o() < 1 || this.field_186272_c.func_177952_p() < 1) {
            return false;
        }
        MutableBoundingBox \u26032 = placementSettings2.func_186213_g();
        ArrayList \u26033 = Lists.newArrayListWithCapacity((int)(placementSettings2.func_204763_l() ? list.size() : 0));
        ArrayList \u26034 = Lists.newArrayListWithCapacity((int)list.size());
        int \u26035 = Integer.MAX_VALUE;
        int \u26036 = Integer.MAX_VALUE;
        int \u26037 = Integer.MAX_VALUE;
        int \u26038 = Integer.MIN_VALUE;
        int \u26039 = Integer.MIN_VALUE;
        int \u260310 = Integer.MIN_VALUE;
        List<BlockInfo> list2 = Template.func_237145_a_(iServerWorld, blockPos, blockPos2, placementSettings2, list);
        for (BlockInfo blockInfo : list2) {
            BlockPos object2 = blockInfo.field_186242_a;
            if (\u26032 != null && !\u26032.func_175898_b(object2)) continue;
            Object object3 = placementSettings2.func_204763_l() ? iServerWorld.func_204610_c(object2) : null;
            \u2603 = blockInfo.field_186243_b.func_185902_a(placementSettings2.func_186212_b()).func_185907_a(placementSettings2.func_186215_c());
            if (blockInfo.field_186244_c != null) {
                TileEntity object22 = iServerWorld.func_175625_s(object2);
                IClearable.func_213131_a(object22);
                iServerWorld.func_180501_a(object2, Blocks.field_180401_cv.func_176223_P(), 20);
            }
            if (!iServerWorld.func_180501_a(object2, (BlockState)\u2603, n)) continue;
            \u26035 = Math.min(\u26035, object2.func_177958_n());
            \u26036 = Math.min(\u26036, object2.func_177956_o());
            \u26037 = Math.min(\u26037, object2.func_177952_p());
            \u26038 = Math.max(\u26038, object2.func_177958_n());
            \u26039 = Math.max(\u26039, object2.func_177956_o());
            \u260310 = Math.max(\u260310, object2.func_177952_p());
            \u26034.add(Pair.of((Object)object2, (Object)blockInfo.field_186244_c));
            if (blockInfo.field_186244_c != null && (\u2603 = iServerWorld.func_175625_s(object2)) != null) {
                blockInfo.field_186244_c.func_74768_a("x", object2.func_177958_n());
                blockInfo.field_186244_c.func_74768_a("y", object2.func_177956_o());
                blockInfo.field_186244_c.func_74768_a("z", object2.func_177952_p());
                if (\u2603 instanceof LockableLootTileEntity) {
                    blockInfo.field_186244_c.func_74772_a("LootTableSeed", random.nextLong());
                }
                ((TileEntity)\u2603).func_230337_a_(blockInfo.field_186243_b, blockInfo.field_186244_c);
                ((TileEntity)\u2603).func_189668_a(placementSettings2.func_186212_b());
                ((TileEntity)\u2603).func_189667_a(placementSettings2.func_186215_c());
            }
            if (object3 == null || !(((AbstractBlock.AbstractBlockState)\u2603).func_177230_c() instanceof ILiquidContainer)) continue;
            ((ILiquidContainer)((Object)((AbstractBlock.AbstractBlockState)\u2603).func_177230_c())).func_204509_a(iServerWorld, object2, (BlockState)\u2603, (FluidState)object3);
            if (((FluidState)object3).func_206889_d()) continue;
            \u26033.add(object2);
        }
        boolean \u260312 = true;
        Direction[] directionArray = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while (\u260312 && !\u26033.isEmpty()) {
            \u260312 = false;
            object = \u26033.iterator();
            while (object.hasNext()) {
                \u2603 = object3 = (BlockPos)object.next();
                \u2603 = iServerWorld.func_204610_c((BlockPos)\u2603);
                for (int i = 0; i < directionArray.length && !((FluidState)\u2603).func_206889_d(); ++i) {
                    BlockPos object3 = ((BlockPos)\u2603).func_177972_a(directionArray[i]);
                    object4 = iServerWorld.func_204610_c(object3);
                    if (!(((FluidState)object4).func_215679_a(iServerWorld, object3) > ((FluidState)\u2603).func_215679_a(iServerWorld, (BlockPos)\u2603)) && (!((FluidState)object4).func_206889_d() || ((FluidState)\u2603).func_206889_d())) continue;
                    \u2603 = object4;
                    \u2603 = object3;
                }
                if (!((FluidState)\u2603).func_206889_d() || !((block = (\u2603 = iServerWorld.func_180495_p((BlockPos)object3)).func_177230_c()) instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)((Object)block)).func_204509_a(iServerWorld, (BlockPos)object3, \u2603, (FluidState)\u2603);
                \u260312 = true;
                object.remove();
            }
        }
        if (\u26035 <= \u26038) {
            if (!placementSettings2.func_215218_i()) {
                object = new BitSetVoxelShapePart(\u26038 - \u26035 + 1, \u26039 - \u26036 + 1, \u260310 - \u26037 + 1);
                int \u260313 = \u26035;
                int \u260314 = \u26036;
                int \u260315 = \u26037;
                for (Block block : \u26034) {
                    Object object4 = (BlockPos)block.getFirst();
                    ((VoxelShapePart)object).func_199625_a(((Vector3i)object4).func_177958_n() - \u260313, ((Vector3i)object4).func_177956_o() - \u260314, ((Vector3i)object4).func_177952_p() - \u260315, true, true);
                }
                Template.func_222857_a(iServerWorld, n, (VoxelShapePart)object, \u260313, \u260314, \u260315);
            }
            for (Pair \u260316 : \u26034) {
                TileEntity tileEntity;
                BlockPos blockPos3 = (BlockPos)\u260316.getFirst();
                if (!placementSettings2.func_215218_i()) {
                    BlockState blockState;
                    BlockState blockState2 = iServerWorld.func_180495_p(blockPos3);
                    if (blockState2 != (blockState = Block.func_199770_b(blockState2, iServerWorld, blockPos3))) {
                        iServerWorld.func_180501_a(blockPos3, blockState, n & 0xFFFFFFFE | 0x10);
                    }
                    iServerWorld.func_230547_a_(blockPos3, blockState.func_177230_c());
                }
                if (\u260316.getSecond() == null || (tileEntity = iServerWorld.func_175625_s(blockPos3)) == null) continue;
                tileEntity.func_70296_d();
            }
        }
        if (!placementSettings2.func_186221_e()) {
            this.func_237143_a_(iServerWorld, blockPos, placementSettings2.func_186212_b(), placementSettings2.func_186215_c(), placementSettings2.func_207664_d(), \u26032, placementSettings2.func_237134_m_());
        }
        return true;
    }

    public static void func_222857_a(IWorld iWorld, int n, VoxelShapePart voxelShapePart, int n2, int n3, int n4) {
        voxelShapePart.func_211540_a((direction, n5, n6, n7) -> {
            BlockPos blockPos = new BlockPos(n2 + n5, n3 + n6, n4 + n7);
            \u2603 = blockPos.func_177972_a(direction);
            BlockState \u26032 = iWorld.func_180495_p(blockPos);
            if (\u26032 != (\u2603 = \u26032.func_196956_a(direction, \u2603 = iWorld.func_180495_p(\u2603), iWorld, blockPos, \u2603))) {
                iWorld.func_180501_a(blockPos, \u2603, n & 0xFFFFFFFE);
            }
            if (\u2603 != (\u2603 = \u2603.func_196956_a(direction.func_176734_d(), \u2603, iWorld, \u2603, blockPos))) {
                iWorld.func_180501_a(\u2603, \u2603, n & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> func_237145_a_(IWorld iWorld, BlockPos blockPos, BlockPos blockPos2, PlacementSettings placementSettings, List<BlockInfo> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (BlockInfo blockInfo : list) {
            BlockPos blockPos3 = Template.func_186266_a(placementSettings, blockInfo.field_186242_a).func_177971_a(blockPos);
            BlockInfo \u26032 = new BlockInfo(blockPos3, blockInfo.field_186243_b, blockInfo.field_186244_c != null ? blockInfo.field_186244_c.func_74737_b() : null);
            Iterator<StructureProcessor> \u26033 = placementSettings.func_215221_j().iterator();
            while (\u26032 != null && \u26033.hasNext()) {
                \u26032 = \u26033.next().func_230386_a_(iWorld, blockPos, blockPos2, blockInfo, \u26032, placementSettings);
            }
            if (\u26032 == null) continue;
            arrayList.add(\u26032);
        }
        return arrayList;
    }

    private void func_237143_a_(IServerWorld iServerWorld, BlockPos blockPos, Mirror mirror, Rotation rotation, BlockPos blockPos2, @Nullable MutableBoundingBox mutableBoundingBox, boolean bl) {
        for (EntityInfo entityInfo : this.field_186271_b) {
            BlockPos blockPos3 = Template.func_207669_a(entityInfo.field_186248_b, mirror, rotation, blockPos2).func_177971_a(blockPos);
            if (mutableBoundingBox != null && !mutableBoundingBox.func_175898_b(blockPos3)) continue;
            CompoundNBT \u26032 = entityInfo.field_186249_c.func_74737_b();
            Vector3d \u26033 = Template.func_207667_a(entityInfo.field_186247_a, mirror, rotation, blockPos2);
            Vector3d \u26034 = \u26033.func_72441_c(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            ListNBT \u26035 = new ListNBT();
            \u26035.add(DoubleNBT.func_229684_a_(\u26034.field_72450_a));
            \u26035.add(DoubleNBT.func_229684_a_(\u26034.field_72448_b));
            \u26035.add(DoubleNBT.func_229684_a_(\u26034.field_72449_c));
            \u26032.func_218657_a("Pos", \u26035);
            \u26032.func_82580_o("UUID");
            Template.func_215382_a(iServerWorld, \u26032).ifPresent(entity -> {
                float f = entity.func_184217_a(mirror);
                entity.func_70012_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(rotation), entity.field_70125_A);
                if (bl && entity instanceof MobEntity) {
                    ((MobEntity)entity).func_213386_a(iServerWorld, iServerWorld.func_175649_E(new BlockPos(\u26034)), SpawnReason.STRUCTURE, null, \u26032);
                }
                iServerWorld.func_242417_l((Entity)entity);
            });
        }
    }

    private static Optional<Entity> func_215382_a(IServerWorld iServerWorld, CompoundNBT compoundNBT) {
        try {
            return EntityType.func_220330_a(compoundNBT, iServerWorld.func_201672_e());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public BlockPos func_186257_a(Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.field_186272_c.func_177952_p(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177958_n());
            }
        }
        return this.field_186272_c;
    }

    public static BlockPos func_207669_a(BlockPos blockPos, Mirror mirror, Rotation rotation, BlockPos blockPos2) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        boolean \u26032 = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                \u2603 = -\u2603;
                break;
            }
            case FRONT_BACK: {
                n = -n;
                break;
            }
            default: {
                \u26032 = false;
            }
        }
        \u2603 = blockPos2.func_177958_n();
        \u2603 = blockPos2.func_177952_p();
        switch (rotation) {
            case CLOCKWISE_180: {
                return new BlockPos(\u2603 + \u2603 - n, \u2603, \u2603 + \u2603 - \u2603);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(\u2603 - \u2603 + \u2603, \u2603, \u2603 + \u2603 - n);
            }
            case CLOCKWISE_90: {
                return new BlockPos(\u2603 + \u2603 - \u2603, \u2603, \u2603 - \u2603 + n);
            }
        }
        return \u26032 ? new BlockPos(n, \u2603, \u2603) : blockPos;
    }

    public static Vector3d func_207667_a(Vector3d vector3d, Mirror mirror, Rotation rotation, BlockPos blockPos) {
        double d = vector3d.field_72450_a;
        \u2603 = vector3d.field_72448_b;
        \u2603 = vector3d.field_72449_c;
        boolean \u26032 = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                \u2603 = 1.0 - \u2603;
                break;
            }
            case FRONT_BACK: {
                d = 1.0 - d;
                break;
            }
            default: {
                \u26032 = false;
            }
        }
        int \u26033 = blockPos.func_177958_n();
        int \u26034 = blockPos.func_177952_p();
        switch (rotation) {
            case CLOCKWISE_180: {
                return new Vector3d((double)(\u26033 + \u26033 + 1) - d, \u2603, (double)(\u26034 + \u26034 + 1) - \u2603);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vector3d((double)(\u26033 - \u26034) + \u2603, \u2603, (double)(\u26033 + \u26034 + 1) - d);
            }
            case CLOCKWISE_90: {
                return new Vector3d((double)(\u26033 + \u26034 + 1) - \u2603, \u2603, (double)(\u26034 - \u26033) + d);
            }
        }
        return \u26032 ? new Vector3d(d, \u2603, \u2603) : vector3d;
    }

    public BlockPos func_189961_a(BlockPos blockPos, Mirror mirror, Rotation rotation) {
        return Template.func_191157_a(blockPos, mirror, rotation, this.func_186259_a().func_177958_n(), this.func_186259_a().func_177952_p());
    }

    public static BlockPos func_191157_a(BlockPos blockPos, Mirror mirror, Rotation rotation, int n, int n2) {
        \u2603 = mirror == Mirror.FRONT_BACK ? --n : 0;
        \u2603 = mirror == Mirror.LEFT_RIGHT ? --n2 : 0;
        BlockPos blockPos2 = blockPos;
        switch (rotation) {
            case NONE: {
                blockPos2 = blockPos.func_177982_a(\u2603, 0, \u2603);
                break;
            }
            case CLOCKWISE_90: {
                blockPos2 = blockPos.func_177982_a(n2 - \u2603, 0, \u2603);
                break;
            }
            case CLOCKWISE_180: {
                blockPos2 = blockPos.func_177982_a(n - \u2603, 0, n2 - \u2603);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                blockPos2 = blockPos.func_177982_a(\u2603, 0, n - \u2603);
            }
        }
        return blockPos2;
    }

    public MutableBoundingBox func_215388_b(PlacementSettings placementSettings, BlockPos blockPos) {
        return this.func_237150_a_(blockPos, placementSettings.func_186215_c(), placementSettings.func_207664_d(), placementSettings.func_186212_b());
    }

    public MutableBoundingBox func_237150_a_(BlockPos blockPos, Rotation rotation, BlockPos blockPos2, Mirror mirror) {
        BlockPos blockPos3 = this.func_186257_a(rotation);
        int \u26032 = blockPos2.func_177958_n();
        int \u26033 = blockPos2.func_177952_p();
        int \u26034 = blockPos3.func_177958_n() - 1;
        int \u26035 = blockPos3.func_177956_o() - 1;
        int \u26036 = blockPos3.func_177952_p() - 1;
        MutableBoundingBox \u26037 = new MutableBoundingBox(0, 0, 0, 0, 0, 0);
        switch (rotation) {
            case NONE: {
                \u26037 = new MutableBoundingBox(0, 0, 0, \u26034, \u26035, \u26036);
                break;
            }
            case CLOCKWISE_180: {
                \u26037 = new MutableBoundingBox(\u26032 + \u26032 - \u26034, 0, \u26033 + \u26033 - \u26036, \u26032 + \u26032, \u26035, \u26033 + \u26033);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                \u26037 = new MutableBoundingBox(\u26032 - \u26033, 0, \u26032 + \u26033 - \u26036, \u26032 - \u26033 + \u26034, \u26035, \u26032 + \u26033);
                break;
            }
            case CLOCKWISE_90: {
                \u26037 = new MutableBoundingBox(\u26032 + \u26033 - \u26034, 0, \u26033 - \u26032, \u26032 + \u26033, \u26035, \u26033 - \u26032 + \u26036);
            }
        }
        switch (mirror) {
            case NONE: {
                break;
            }
            case FRONT_BACK: {
                this.func_215385_a(rotation, \u26034, \u26036, \u26037, Direction.WEST, Direction.EAST);
                break;
            }
            case LEFT_RIGHT: {
                this.func_215385_a(rotation, \u26036, \u26034, \u26037, Direction.NORTH, Direction.SOUTH);
            }
        }
        \u26037.func_78886_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        return \u26037;
    }

    private void func_215385_a(Rotation rotation, int n, int n2, MutableBoundingBox mutableBoundingBox, Direction direction, Direction direction2) {
        BlockPos blockPos = BlockPos.field_177992_a;
        blockPos = rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90 ? blockPos.func_177967_a(rotation.func_185831_a(direction), n2) : (rotation == Rotation.CLOCKWISE_180 ? blockPos.func_177967_a(direction2, n) : blockPos.func_177967_a(direction, n));
        mutableBoundingBox.func_78886_a(blockPos.func_177958_n(), 0, blockPos.func_177952_p());
    }

    /*
     * WARNING - void declaration
     */
    public CompoundNBT func_189552_a(CompoundNBT compoundNBT2) {
        Object object;
        if (this.field_204769_a.isEmpty()) {
            compoundNBT2.func_218657_a("blocks", new ListNBT());
            compoundNBT2.func_218657_a("palette", new ListNBT());
        } else {
            void var4_5;
            ArrayList abstractList = Lists.newArrayList();
            BasicPalette \u26032 = new BasicPalette();
            abstractList.add(\u26032);
            boolean bl = true;
            while (var4_5 < this.field_204769_a.size()) {
                abstractList.add(new BasicPalette());
                ++var4_5;
            }
            ListNBT listNBT = new ListNBT();
            object = this.field_204769_a.get(0).func_237157_a_();
            for (int i = 0; i < object.size(); ++i) {
                BlockInfo blockInfo = (BlockInfo)object.get(i);
                CompoundNBT \u26033 = new CompoundNBT();
                \u26033.func_218657_a("pos", this.func_186267_a(blockInfo.field_186242_a.func_177958_n(), blockInfo.field_186242_a.func_177956_o(), blockInfo.field_186242_a.func_177952_p()));
                int \u26034 = \u26032.func_189954_a(blockInfo.field_186243_b);
                \u26033.func_74768_a("state", \u26034);
                if (blockInfo.field_186244_c != null) {
                    \u26033.func_218657_a("nbt", blockInfo.field_186244_c);
                }
                listNBT.add(\u26033);
                for (int j = 1; j < this.field_204769_a.size(); ++j) {
                    BasicPalette basicPalette = (BasicPalette)abstractList.get(j);
                    basicPalette.func_189956_a(this.field_204769_a.get((int)j).func_237157_a_().get((int)i).field_186243_b, \u26034);
                }
            }
            compoundNBT2.func_218657_a("blocks", listNBT);
            if (abstractList.size() == 1) {
                ListNBT listNBT2 = new ListNBT();
                for (Object object2 : \u26032) {
                    listNBT2.add(NBTUtil.func_190009_a((BlockState)object2));
                }
                compoundNBT2.func_218657_a("palette", listNBT2);
            } else {
                ListNBT listNBT3 = new ListNBT();
                for (Object object2 : abstractList) {
                    ListNBT listNBT4 = new ListNBT();
                    Iterator<BlockState> iterator = ((BasicPalette)object2).iterator();
                    while (iterator.hasNext()) {
                        BlockState object3 = iterator.next();
                        listNBT4.add(NBTUtil.func_190009_a(object3));
                    }
                    listNBT3.add(listNBT4);
                }
                compoundNBT2.func_218657_a("palettes", listNBT3);
            }
        }
        ListNBT listNBT = new ListNBT();
        for (EntityInfo entityInfo : this.field_186271_b) {
            object = new CompoundNBT();
            ((CompoundNBT)object).func_218657_a("pos", this.func_186264_a(entityInfo.field_186247_a.field_72450_a, entityInfo.field_186247_a.field_72448_b, entityInfo.field_186247_a.field_72449_c));
            ((CompoundNBT)object).func_218657_a("blockPos", this.func_186267_a(entityInfo.field_186248_b.func_177958_n(), entityInfo.field_186248_b.func_177956_o(), entityInfo.field_186248_b.func_177952_p()));
            if (entityInfo.field_186249_c != null) {
                ((CompoundNBT)object).func_218657_a("nbt", entityInfo.field_186249_c);
            }
            listNBT.add(object);
        }
        compoundNBT2.func_218657_a("entities", listNBT);
        compoundNBT2.func_218657_a("size", this.func_186267_a(this.field_186272_c.func_177958_n(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177952_p()));
        compoundNBT2.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        return compoundNBT2;
    }

    public void func_186256_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        int n;
        this.field_204769_a.clear();
        this.field_186271_b.clear();
        ListNBT listNBT = compoundNBT2.func_150295_c("size", 3);
        this.field_186272_c = new BlockPos(listNBT.func_186858_c(0), listNBT.func_186858_c(1), listNBT.func_186858_c(2));
        \u2603 = compoundNBT2.func_150295_c("blocks", 10);
        if (compoundNBT2.func_150297_b("palettes", 9)) {
            \u26032 = compoundNBT2.func_150295_c("palettes", 9);
            for (n = 0; n < \u26032.size(); ++n) {
                this.func_204768_a(\u26032.func_202169_e(n), \u2603);
            }
        } else {
            this.func_204768_a(compoundNBT2.func_150295_c("palette", 10), \u2603);
        }
        ListNBT \u26032 = compoundNBT2.func_150295_c("entities", 10);
        for (n = 0; n < \u26032.size(); ++n) {
            CompoundNBT compoundNBT3 = \u26032.func_150305_b(n);
            ListNBT \u26033 = compoundNBT3.func_150295_c("pos", 6);
            Vector3d \u26034 = new Vector3d(\u26033.func_150309_d(0), \u26033.func_150309_d(1), \u26033.func_150309_d(2));
            ListNBT \u26035 = compoundNBT3.func_150295_c("blockPos", 3);
            BlockPos \u26036 = new BlockPos(\u26035.func_186858_c(0), \u26035.func_186858_c(1), \u26035.func_186858_c(2));
            if (!compoundNBT3.func_74764_b("nbt")) continue;
            \u2603 = compoundNBT3.func_74775_l("nbt");
            this.field_186271_b.add(new EntityInfo(\u26034, \u26036, \u2603));
        }
    }

    private void func_204768_a(ListNBT listNBT, ListNBT listNBT2) {
        BasicPalette basicPalette = new BasicPalette();
        for (int i = 0; i < listNBT.size(); ++i) {
            basicPalette.func_189956_a(NBTUtil.func_190008_d(listNBT.func_150305_b(i)), i);
        }
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        for (int i = 0; i < listNBT2.size(); ++i) {
            CompoundNBT compoundNBT = listNBT2.func_150305_b(i);
            ListNBT \u26032 = compoundNBT.func_150295_c("pos", 3);
            BlockPos \u26033 = new BlockPos(\u26032.func_186858_c(0), \u26032.func_186858_c(1), \u26032.func_186858_c(2));
            BlockState \u26034 = basicPalette.func_189955_a(compoundNBT.func_74762_e("state"));
            \u2603 = compoundNBT.func_74764_b("nbt") ? compoundNBT.func_74775_l("nbt") : null;
            BlockInfo \u26035 = new BlockInfo(\u26033, \u26034, \u2603);
            Template.func_237149_a_(\u26035, arrayList, \u2603, \u2603);
        }
        List<BlockInfo> list = Template.func_237151_a_(arrayList, \u2603, \u2603);
        this.field_204769_a.add(new Palette(list));
    }

    private ListNBT func_186267_a(int ... nArray) {
        ListNBT listNBT = new ListNBT();
        for (int n : nArray) {
            listNBT.add(IntNBT.func_229692_a_(n));
        }
        return listNBT;
    }

    private ListNBT func_186264_a(double ... dArray) {
        ListNBT listNBT = new ListNBT();
        for (double d : dArray) {
            listNBT.add(DoubleNBT.func_229684_a_(d));
        }
        return listNBT;
    }

    public static final class Palette {
        private final List<BlockInfo> field_237155_a_;
        private final Map<Block, List<BlockInfo>> field_237156_b_ = Maps.newHashMap();

        private Palette(List<BlockInfo> list) {
            this.field_237155_a_ = list;
        }

        public List<BlockInfo> func_237157_a_() {
            return this.field_237155_a_;
        }

        public List<BlockInfo> func_237158_a_(Block block2) {
            return this.field_237156_b_.computeIfAbsent(block2, block -> this.field_237155_a_.stream().filter(blockInfo -> blockInfo.field_186243_b.func_203425_a((Block)block)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vector3d field_186247_a;
        public final BlockPos field_186248_b;
        public final CompoundNBT field_186249_c;

        public EntityInfo(Vector3d vector3d, BlockPos blockPos, CompoundNBT compoundNBT) {
            this.field_186247_a = vector3d;
            this.field_186248_b = blockPos;
            this.field_186249_c = compoundNBT;
        }
    }

    public static class BlockInfo {
        public final BlockPos field_186242_a;
        public final BlockState field_186243_b;
        public final CompoundNBT field_186244_c;

        public BlockInfo(BlockPos blockPos, BlockState blockState, @Nullable CompoundNBT compoundNBT) {
            this.field_186242_a = blockPos;
            this.field_186243_b = blockState;
            this.field_186244_c = compoundNBT;
        }

        public String toString() {
            return String.format("<StructureBlockInfo | %s | %s | %s>", this.field_186242_a, this.field_186243_b, this.field_186244_c);
        }
    }

    static class BasicPalette
    implements Iterable<BlockState> {
        public static final BlockState field_189957_a = Blocks.field_150350_a.func_176223_P();
        private final ObjectIntIdentityMap<BlockState> field_189958_b = new ObjectIntIdentityMap(16);
        private int field_189959_c;

        private BasicPalette() {
        }

        public int func_189954_a(BlockState blockState) {
            int n = this.field_189958_b.func_148757_b(blockState);
            if (n == -1) {
                n = this.field_189959_c++;
                this.field_189958_b.func_148746_a(blockState, n);
            }
            return n;
        }

        @Nullable
        public BlockState func_189955_a(int n) {
            BlockState blockState = this.field_189958_b.func_148745_a(n);
            return blockState == null ? field_189957_a : blockState;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.field_189958_b.iterator();
        }

        public void func_189956_a(BlockState blockState, int n) {
            this.field_189958_b.func_148746_a(blockState, n);
        }
    }
}

