/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;

public record WorldDimensions(Registry<LevelStem> f_243948_) {
    public static final MapCodec<WorldDimensions> f_243810_ = RecordCodecBuilder.mapCodec(p_258996_ -> p_258996_.group((App)RegistryCodecs.m_246213_(Registries.f_256862_, Lifecycle.stable(), LevelStem.f_63970_).fieldOf("dimensions").forGetter(WorldDimensions::f_243948_)).apply((Applicative)p_258996_, p_258996_.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<LevelStem>> f_243726_ = ImmutableSet.of(LevelStem.f_63971_, LevelStem.f_63972_, LevelStem.f_63973_);
    private static final int f_243847_ = f_243726_.size();

    public WorldDimensions {
        LevelStem $$1 = f_243948_.m_6246_(LevelStem.f_63971_);
        if ($$1 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public static Stream<ResourceKey<LevelStem>> m_247421_(Stream<ResourceKey<LevelStem>> p_251309_) {
        return Stream.concat(f_243726_.stream(), p_251309_.filter(p_251885_ -> !f_243726_.contains(p_251885_)));
    }

    public WorldDimensions m_246747_(RegistryAccess p_251390_, ChunkGenerator p_248755_) {
        Registry<DimensionType> $$2 = p_251390_.m_175515_(Registries.f_256787_);
        Registry<LevelStem> $$3 = WorldDimensions.m_246477_($$2, this.f_243948_, p_248755_);
        return new WorldDimensions($$3);
    }

    public static Registry<LevelStem> m_246477_(Registry<DimensionType> p_248853_, Registry<LevelStem> p_251908_, ChunkGenerator p_251737_) {
        LevelStem $$3 = p_251908_.m_6246_(LevelStem.f_63971_);
        Holder<DimensionType> $$4 = $$3 == null ? p_248853_.m_246971_(BuiltinDimensionTypes.f_223538_) : $$3.f_63975_();
        return WorldDimensions.m_247534_(p_251908_, $$4, p_251737_);
    }

    public static Registry<LevelStem> m_247534_(Registry<LevelStem> p_248907_, Holder<DimensionType> p_251895_, ChunkGenerator p_250220_) {
        MappedRegistry<LevelStem> $$3 = new MappedRegistry<LevelStem>(Registries.f_256862_, Lifecycle.experimental());
        $$3.m_255290_(LevelStem.f_63971_, new LevelStem(p_251895_, p_250220_), Lifecycle.stable());
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> $$4 : p_248907_.m_6579_()) {
            ResourceKey<LevelStem> $$5 = $$4.getKey();
            if ($$5 == LevelStem.f_63971_) continue;
            $$3.m_255290_($$5, $$4.getValue(), p_248907_.m_6228_($$4.getValue()));
        }
        return $$3.m_203521_();
    }

    public ChunkGenerator m_246737_() {
        LevelStem $$0 = this.f_243948_.m_6246_(LevelStem.f_63971_);
        if ($$0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return $$0.f_63976_();
    }

    public Optional<LevelStem> m_245957_(ResourceKey<LevelStem> p_250824_) {
        return this.f_243948_.m_123009_(p_250824_);
    }

    public ImmutableSet<ResourceKey<Level>> m_247539_() {
        return (ImmutableSet)this.f_243948_().m_6579_().stream().map(Map.Entry::getKey).map(Registries::m_257551_).collect(ImmutableSet.toImmutableSet());
    }

    public boolean m_246739_() {
        return this.m_246737_() instanceof DebugLevelSource;
    }

    private static PrimaryLevelData.SpecialWorldProperty m_246830_(Registry<LevelStem> p_251549_) {
        return p_251549_.m_123009_(LevelStem.f_63971_).map(p_251481_ -> {
            ChunkGenerator $$1 = p_251481_.f_63976_();
            if ($$1 instanceof DebugLevelSource) {
                return PrimaryLevelData.SpecialWorldProperty.DEBUG;
            }
            if ($$1 instanceof FlatLevelSource) {
                return PrimaryLevelData.SpecialWorldProperty.FLAT;
            }
            return PrimaryLevelData.SpecialWorldProperty.NONE;
        }).orElse(PrimaryLevelData.SpecialWorldProperty.NONE);
    }

    static Lifecycle m_245357_(ResourceKey<LevelStem> p_250764_, LevelStem p_248865_) {
        return WorldDimensions.m_245858_(p_250764_, p_248865_) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean m_245858_(ResourceKey<LevelStem> p_250556_, LevelStem p_250034_) {
        if (p_250556_ == LevelStem.f_63971_) {
            return WorldDimensions.m_245847_(p_250034_);
        }
        if (p_250556_ == LevelStem.f_63972_) {
            return WorldDimensions.m_246615_(p_250034_);
        }
        if (p_250556_ == LevelStem.f_63973_) {
            return WorldDimensions.m_247592_(p_250034_);
        }
        return false;
    }

    private static boolean m_245847_(LevelStem p_250762_) {
        MultiNoiseBiomeSource $$2;
        Holder<DimensionType> $$1 = p_250762_.f_63975_();
        if (!$$1.m_203565_(BuiltinDimensionTypes.f_223538_) && !$$1.m_203565_(BuiltinDimensionTypes.f_223541_)) {
            return false;
        }
        BiomeSource biomeSource = p_250762_.f_63976_().m_62218_();
        return !(biomeSource instanceof MultiNoiseBiomeSource) || ($$2 = (MultiNoiseBiomeSource)biomeSource).m_187063_(MultiNoiseBiomeSource.Preset.f_187087_);
    }

    private static boolean m_246615_(LevelStem p_250497_) {
        MultiNoiseBiomeSource $$2;
        NoiseBasedChunkGenerator $$1;
        Object object;
        return p_250497_.f_63975_().m_203565_(BuiltinDimensionTypes.f_223539_) && (object = p_250497_.f_63976_()) instanceof NoiseBasedChunkGenerator && ($$1 = (NoiseBasedChunkGenerator)object).m_224221_(NoiseGeneratorSettings.f_64434_) && (object = $$1.m_62218_()) instanceof MultiNoiseBiomeSource && ($$2 = (MultiNoiseBiomeSource)object).m_187063_(MultiNoiseBiomeSource.Preset.f_48512_);
    }

    private static boolean m_247592_(LevelStem p_250720_) {
        NoiseBasedChunkGenerator $$1;
        ChunkGenerator chunkGenerator;
        return p_250720_.f_63975_().m_203565_(BuiltinDimensionTypes.f_223540_) && (chunkGenerator = p_250720_.f_63976_()) instanceof NoiseBasedChunkGenerator && ($$1 = (NoiseBasedChunkGenerator)chunkGenerator).m_224221_(NoiseGeneratorSettings.f_64435_) && $$1.m_62218_() instanceof TheEndBiomeSource;
    }

    public Complete m_245300_(Registry<LevelStem> p_248787_) {
        record Entry(ResourceKey<LevelStem> f_244236_, LevelStem f_243758_) {
            Lifecycle m_246583_() {
                return WorldDimensions.m_245357_(this.f_244236_, this.f_243758_);
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "key;value", "f_244236_", "f_243758_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "key;value", "f_244236_", "f_243758_"}, this);
            }

            @Override
            public final boolean equals(Object p_250835_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "key;value", "f_244236_", "f_243758_"}, this, p_250835_);
            }
        }
        Stream<ResourceKey<LevelStem>> $$1 = Stream.concat(p_248787_.m_214010_().stream(), this.f_243948_.m_214010_().stream()).distinct();
        ArrayList $$2 = new ArrayList();
        WorldDimensions.m_247421_($$1).forEach(p_248571_ -> p_248787_.m_123009_((ResourceKey<LevelStem>)p_248571_).or(() -> this.f_243948_.m_123009_((ResourceKey<LevelStem>)p_248571_)).ifPresent(p_250263_ -> $$2.add(new Entry((ResourceKey<LevelStem>)p_248571_, (LevelStem)p_250263_))));
        Lifecycle $$3 = $$2.size() == f_243847_ ? Lifecycle.stable() : Lifecycle.experimental();
        MappedRegistry<LevelStem> $$4 = new MappedRegistry<LevelStem>(Registries.f_256862_, $$3);
        $$2.forEach(p_259001_ -> $$4.m_255290_(p_259001_.f_244236_, p_259001_.f_243758_, p_259001_.m_246583_()));
        Registry<LevelStem> $$5 = $$4.m_203521_();
        PrimaryLevelData.SpecialWorldProperty $$6 = WorldDimensions.m_246830_($$5);
        return new Complete($$5.m_203521_(), $$6);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldDimensions.class, "dimensions", "f_243948_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldDimensions.class, "dimensions", "f_243948_"}, this);
    }

    @Override
    public final boolean equals(Object p_251618_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldDimensions.class, "dimensions", "f_243948_"}, this, p_251618_);
    }

    public record Complete(Registry<LevelStem> f_244049_, PrimaryLevelData.SpecialWorldProperty f_244634_) {
        public Lifecycle m_245945_() {
            return this.f_244049_.m_203658_();
        }

        public RegistryAccess.Frozen m_245593_() {
            return new RegistryAccess.ImmutableRegistryAccess(List.of(this.f_244049_)).m_203557_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Complete.class, "dimensions;specialWorldProperty", "f_244049_", "f_244634_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Complete.class, "dimensions;specialWorldProperty", "f_244049_", "f_244634_"}, this);
        }

        @Override
        public final boolean equals(Object p_250925_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Complete.class, "dimensions;specialWorldProperty", "f_244049_", "f_244634_"}, this, p_250925_);
        }
    }
}

