/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.LayerConfiguration;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class FlatLevelGeneratorSettings {
    private static final Logger f_70348_ = LogUtils.getLogger();
    public static final Codec<FlatLevelGeneratorSettings> f_70347_ = RecordCodecBuilder.create(p_209800_ -> p_209800_.group((App)RegistryCodecs.m_206277_(Registries.f_256998_).optionalFieldOf("structure_overrides").forGetter(p_209812_ -> p_209812_.f_209788_), (App)FlatLayerInfo.f_70329_.listOf().fieldOf("layers").forGetter(FlatLevelGeneratorSettings::m_70401_), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(p_161912_ -> p_161912_.f_70357_), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(p_209809_ -> p_209809_.f_70356_), (App)Biome.f_47431_.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(p_209807_ -> Optional.of(p_209807_.f_70353_)), RegistryOps.m_254866_(Biomes.f_48202_), RegistryOps.m_254866_(MiscOverworldPlacements.f_195266_), RegistryOps.m_254866_(MiscOverworldPlacements.f_195267_)).apply((Applicative)p_209800_, FlatLevelGeneratorSettings::new)).comapFlatMap(FlatLevelGeneratorSettings::m_161905_, Function.identity()).stable();
    private final Optional<HolderSet<StructureSet>> f_209788_;
    private final List<FlatLayerInfo> f_70352_ = Lists.newArrayList();
    private final Holder<Biome> f_70353_;
    private final List<BlockState> f_70354_;
    private boolean f_70355_;
    private boolean f_70356_;
    private boolean f_70357_;
    private final List<Holder<PlacedFeature>> f_254642_;

    private static DataResult<FlatLevelGeneratorSettings> m_161905_(FlatLevelGeneratorSettings p_161906_) {
        int $$1 = p_161906_.f_70352_.stream().mapToInt(FlatLayerInfo::m_70337_).sum();
        if ($$1 > DimensionType.f_156651_) {
            return DataResult.error((String)("Sum of layer heights is > " + DimensionType.f_156651_), (Object)p_161906_);
        }
        return DataResult.success((Object)p_161906_);
    }

    private FlatLevelGeneratorSettings(Optional<HolderSet<StructureSet>> p_256456_, List<FlatLayerInfo> p_255826_, boolean p_255740_, boolean p_255726_, Optional<Holder<Biome>> p_256292_, Holder.Reference<Biome> p_255964_, Holder<PlacedFeature> p_256419_, Holder<PlacedFeature> p_255710_) {
        this(p_256456_, FlatLevelGeneratorSettings.m_255287_(p_256292_, p_255964_), List.of(p_256419_, p_255710_));
        if (p_255740_) {
            this.m_70385_();
        }
        if (p_255726_) {
            this.m_70369_();
        }
        this.f_70352_.addAll(p_255826_);
        this.m_70403_();
    }

    private static Holder<Biome> m_255287_(Optional<? extends Holder<Biome>> p_256142_, Holder<Biome> p_256475_) {
        if (p_256142_.isEmpty()) {
            f_70348_.error("Unknown biome, defaulting to plains");
            return p_256475_;
        }
        return p_256142_.get();
    }

    public FlatLevelGeneratorSettings(Optional<HolderSet<StructureSet>> p_256029_, Holder<Biome> p_256190_, List<Holder<PlacedFeature>> p_255960_) {
        this.f_209788_ = p_256029_;
        this.f_70353_ = p_256190_;
        this.f_70354_ = Lists.newArrayList();
        this.f_254642_ = p_255960_;
    }

    public FlatLevelGeneratorSettings m_254853_(List<FlatLayerInfo> p_256587_, Optional<HolderSet<StructureSet>> p_256500_, Holder<Biome> p_256598_) {
        FlatLevelGeneratorSettings $$3 = new FlatLevelGeneratorSettings(p_256500_, p_256598_, this.f_254642_);
        for (FlatLayerInfo $$4 : p_256587_) {
            $$3.f_70352_.add(new FlatLayerInfo($$4.m_70337_(), $$4.m_70344_().m_60734_()));
            $$3.m_70403_();
        }
        if (this.f_70356_) {
            $$3.m_70369_();
        }
        if (this.f_70357_) {
            $$3.m_70385_();
        }
        return $$3;
    }

    public void m_70369_() {
        this.f_70356_ = true;
    }

    public void m_70385_() {
        this.f_70357_ = true;
    }

    public BiomeGenerationSettings m_226294_(Holder<Biome> p_226295_) {
        boolean $$4;
        if (!p_226295_.equals(this.f_70353_)) {
            return p_226295_.m_203334_().m_47536_();
        }
        BiomeGenerationSettings $$1 = this.m_204921_().m_203334_().m_47536_();
        BiomeGenerationSettings.PlainBuilder $$2 = new BiomeGenerationSettings.PlainBuilder();
        if (this.f_70357_) {
            for (Holder<PlacedFeature> $$3 : this.f_254642_) {
                $$2.m_255419_(GenerationStep.Decoration.LAKES, $$3);
            }
        }
        boolean bl = $$4 = (!this.f_70355_ || p_226295_.m_203565_(Biomes.f_48173_)) && this.f_70356_;
        if ($$4) {
            List<HolderSet<PlacedFeature>> $$5 = $$1.m_47818_();
            for (int $$6 = 0; $$6 < $$5.size(); ++$$6) {
                if ($$6 == GenerationStep.Decoration.UNDERGROUND_STRUCTURES.ordinal() || $$6 == GenerationStep.Decoration.SURFACE_STRUCTURES.ordinal() || this.f_70357_ && $$6 == GenerationStep.Decoration.LAKES.ordinal()) continue;
                HolderSet<PlacedFeature> $$7 = $$5.get($$6);
                for (Holder holder : $$7) {
                    $$2.m_254982_($$6, holder);
                }
            }
        }
        List<BlockState> $$9 = this.m_161917_();
        for (int $$10 = 0; $$10 < $$9.size(); ++$$10) {
            BlockState $$11 = $$9.get($$10);
            if (Heightmap.Types.MOTION_BLOCKING.m_64299_().test($$11)) continue;
            $$9.set($$10, null);
            $$2.m_255419_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, PlacementUtils.m_206502_(Feature.f_65750_, new LayerConfiguration($$10, $$11), new PlacementModifier[0]));
        }
        return $$2.m_255380_();
    }

    public Optional<HolderSet<StructureSet>> m_209810_() {
        return this.f_209788_;
    }

    public Holder<Biome> m_204921_() {
        return this.f_70353_;
    }

    public List<FlatLayerInfo> m_70401_() {
        return this.f_70352_;
    }

    public List<BlockState> m_161917_() {
        return this.f_70354_;
    }

    public void m_70403_() {
        this.f_70354_.clear();
        for (FlatLayerInfo $$0 : this.f_70352_) {
            for (int $$1 = 0; $$1 < $$0.m_70337_(); ++$$1) {
                this.f_70354_.add($$0.m_70344_());
            }
        }
        this.f_70355_ = this.f_70354_.stream().allMatch(p_209802_ -> p_209802_.m_60713_(Blocks.f_50016_));
    }

    public static FlatLevelGeneratorSettings m_254980_(HolderGetter<Biome> p_256175_, HolderGetter<StructureSet> p_256081_, HolderGetter<PlacedFeature> p_256484_) {
        HolderSet.Direct $$3 = HolderSet.m_205809_(p_256081_.m_255043_(BuiltinStructureSets.f_209836_), p_256081_.m_255043_(BuiltinStructureSets.f_209820_));
        FlatLevelGeneratorSettings $$4 = new FlatLevelGeneratorSettings(Optional.of($$3), FlatLevelGeneratorSettings.m_255268_(p_256175_), FlatLevelGeneratorSettings.m_255047_(p_256484_));
        $$4.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50752_));
        $$4.m_70401_().add(new FlatLayerInfo(2, Blocks.f_50493_));
        $$4.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50440_));
        $$4.m_70403_();
        return $$4;
    }

    public static Holder<Biome> m_255268_(HolderGetter<Biome> p_256645_) {
        return p_256645_.m_255043_(Biomes.f_48202_);
    }

    public static List<Holder<PlacedFeature>> m_255047_(HolderGetter<PlacedFeature> p_256282_) {
        return List.of(p_256282_.m_255043_(MiscOverworldPlacements.f_195266_), p_256282_.m_255043_(MiscOverworldPlacements.f_195267_));
    }
}

