/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.remappers;

import com.google.common.collect.Maps;
import com.mohistmc.bukkit.nms.model.MethodRedirectRule;
import com.mohistmc.bukkit.nms.proxy.ProxyClass;
import com.mohistmc.bukkit.nms.proxy.ProxyMethodHandlesLookup;
import com.mohistmc.bukkit.nms.proxy.ProxyYamlConfiguration;
import com.mohistmc.bukkit.nms.utils.ASMUtils;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;

public class ReflectMethodRemapper
extends MethodRemapper {
    public static final String className = "java/lang/Class";
    public static final String LookupName = "java/lang/invoke/MethodHandles$Lookup";
    public static final String reflectName = "java/lang/reflect/";
    public static final Set<String> proxyClass = new HashSet<String>(Arrays.asList("java/lang/Class;getField", "java/lang/Class;getDeclaredField", "java/lang/Class;getMethod", "java/lang/Class;getDeclaredMethod", "java/lang/Class;getSimpleName"));
    public static final Set<String> Lookup = new HashSet<String>(Arrays.asList("java/lang/Class;unreflect", "java/lang/Class;findSpecial", "java/lang/Class;findStatic", "java/lang/Class;findVirtual", "java/lang/Class;findGetter", "java/lang/Class;findSetter", "java/lang/Class;findStaticGetter", "java/lang/Class;findStaticSetter", "java/lang/Class;findVarHandle"));
    public static final Set<String> reflect = new HashSet<String>(Arrays.asList("java/lang/reflect/Method;getName", "java/lang/reflect/Field;getName"));
    private static final Map<String, Map<String, Map<String, MethodRedirectRule>>> methodRedirectMapping = new HashMap<String, Map<String, Map<String, MethodRedirectRule>>>();
    private static final Map<String, Class<?>> virtualMethod = Maps.newHashMap();

    public ReflectMethodRemapper(MethodVisitor mv, Remapper remapper) {
        super(mv, remapper);
    }

    public ReflectMethodRemapper(int api, MethodVisitor mv, Remapper remapper) {
        super(api, mv, remapper);
    }

    public static void init() {
        for (String s : proxyClass) {
            virtualMethod.put(s, ProxyClass.class);
        }
        for (String s : Lookup) {
            virtualMethod.put(s, ProxyMethodHandlesLookup.class);
        }
        for (String s : reflect) {
            virtualMethod.put(s, ProxyClass.class);
        }
        virtualMethod.put("java/lang/ClassLoader;loadClass", ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "forName", Class.class, new Class[]{String.class}, ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "forName", Class.class, new Class[]{String.class, Boolean.TYPE, ClassLoader.class}, ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getField", Field.class, new Class[]{String.class}, ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getDeclaredField", Field.class, new Class[]{String.class}, ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getMethod", Method.class, new Class[]{String.class, Class[].class}, ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getDeclaredMethod", Method.class, new Class[]{String.class, Class[].class}, ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getName", String.class, new Class[0], ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getSimpleName", String.class, new Class[0], ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper(className, "getDeclaredMethods", Method.class, new Class[0], ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper("java/lang/reflect/Method", "getName", String.class, new Class[0], ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper("java/lang/reflect/Field", "getName", String.class, new Class[0], ProxyClass.class);
        ReflectMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodType", "fromMethodDescriptorString", MethodType.class, new Class[]{String.class, ClassLoader.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "unreflect", MethodHandle.class, new Class[]{String.class, ClassLoader.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findSpecial", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class, Class.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findStatic", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findVirtual", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findGetter", MethodHandle.class, new Class[]{Class.class, String.class, Class.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findSetter", MethodHandle.class, new Class[]{Class.class, String.class, Class.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findStaticGetter", MethodHandle.class, new Class[]{Class.class, String.class, Class.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findStaticSetter", MethodHandle.class, new Class[]{Class.class, String.class, Class.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper(LookupName, "findVarHandle", VarHandle.class, new Class[]{Class.class, String.class, MethodType.class, Class.class}, ProxyMethodHandlesLookup.class);
        ReflectMethodRemapper.registerMethodRemapper("org/bukkit/configuration/file/YamlConfiguration", "loadConfiguration", YamlConfiguration.class, new Class[]{InputStream.class}, ProxyYamlConfiguration.class);
    }

    private static void registerMethodRemapper(String owner, String name, Class<?> returnType, Class<?>[] args, Class<?> remapOwner) {
        Map byName = methodRedirectMapping.computeIfAbsent(owner, k -> new HashMap());
        Map byDesc = byName.computeIfAbsent(name, k -> new HashMap());
        String methodDescriptor = ASMUtils.toMethodDescriptor(returnType, args);
        byDesc.put(methodDescriptor, new MethodRedirectRule(owner, name, methodDescriptor, remapOwner.getName().replace('.', '/')));
    }

    public static Map<String, Class<?>> getVirtualMethod() {
        return virtualMethod;
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (182 == opcode) {
            this.redirectVirtual(opcode, owner, name, desc, itf);
        } else if (184 == opcode) {
            this.redirectStatic(opcode, owner, name, desc, itf);
        } else if (183 == opcode) {
            this.redirectSpecial(opcode, owner, name, desc, itf);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private MethodRedirectRule findRule(int opcode, String owner, String name, String desc, boolean itf) {
        Map<String, Map<String, MethodRedirectRule>> byOwner = methodRedirectMapping.get(owner);
        if (byOwner == null) {
            return null;
        }
        Map<String, MethodRedirectRule> byName = byOwner.get(name);
        if (byName == null) {
            return null;
        }
        return byName.get(desc);
    }

    private void redirectSpecial(int opcode, String owner, String name, String desc, boolean itf) {
        MethodRedirectRule rule = this.findRule(opcode, owner, name, desc, itf);
        if (rule != null) {
            owner = rule.remapOwner();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void redirectVirtual(int opcode, String owner, String name, String desc, boolean itf) {
        MethodRedirectRule rule = this.findRule(opcode, owner, name, desc, itf);
        if (rule != null) {
            opcode = 184;
            Type r = Type.getReturnType((String)desc);
            Type[] args = Type.getArgumentTypes((String)desc);
            Type[] newArgs = new Type[args.length + 1];
            newArgs[0] = Type.getObjectType((String)owner);
            owner = rule.remapOwner();
            System.arraycopy(args, 0, newArgs, 1, args.length);
            desc = Type.getMethodDescriptor((Type)r, (Type[])newArgs);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void redirectStatic(int opcode, String owner, String name, String desc, boolean itf) {
        MethodRedirectRule rule = this.findRule(opcode, owner, name, desc, itf);
        if (rule != null) {
            owner = rule.remapOwner();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }
}

