/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.dynamicenumutil;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import sun.misc.Unsafe;

public class MohistJDK17EnumHelper {
    private static MethodHandles.Lookup implLookup = null;
    private static boolean isSetup = false;
    private static Unsafe unsafe;

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            implLookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
        }
        catch (Exception exception) {
            // empty catch block
        }
        isSetup = true;
    }

    private static MethodHandle getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return implLookup.findConstructor(enumClass, MethodType.methodType(Void.TYPE, parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Throwable {
        int additionalParamsCount = additionalValues == null ? 0 : additionalValues.length;
        Object[] params = new Object[additionalParamsCount + 2];
        params[0] = value;
        params[1] = ordinal;
        if (additionalValues != null) {
            System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        }
        return (T)((Enum)enumClass.cast(MohistJDK17EnumHelper.getConstructorAccessor(enumClass, additionalTypes).invokeWithArguments(params)));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Throwable {
        if (target != null) {
            implLookup.findSetter(field.getDeclaringClass(), field.getName(), field.getType()).invoke(target, value);
        } else {
            implLookup.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType()).invoke(value);
        }
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Throwable {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            MohistJDK17EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Throwable {
        MohistJDK17EnumHelper.blankField(enumClass, "enumConstantDirectory");
        MohistJDK17EnumHelper.blankField(enumClass, "enumConstants");
        MohistJDK17EnumHelper.blankField(enumClass, "enumVars");
    }

    public static <T extends Enum<?>> T addEnum0(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return MohistJDK17EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            MohistJDK17EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = 4121;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            T newValue = MohistJDK17EnumHelper.makeEnum(enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)newValue);
            MohistJDK17EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            MohistJDK17EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }

    public static void setField(Object obj, Object value, Field field) throws ReflectiveOperationException {
        if (obj == null) {
            MohistJDK17EnumHelper.setStaticField(field, value);
        } else {
            try {
                unsafe.putObject(obj, unsafe.objectFieldOffset(field), value);
            }
            catch (Exception e) {
                throw new ReflectiveOperationException(e);
            }
        }
    }

    public static void setStaticField(Field field, Object value) throws ReflectiveOperationException {
        try {
            implLookup.ensureInitialized(field.getDeclaringClass());
            unsafe.putObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field), value);
        }
        catch (Exception e) {
            throw new ReflectiveOperationException(e);
        }
    }

    public static <T> T getField(Object obj, Field field) throws ReflectiveOperationException {
        if (obj == null) {
            return MohistJDK17EnumHelper.getStaticField(field);
        }
        try {
            return (T)unsafe.getObject(obj, unsafe.objectFieldOffset(field));
        }
        catch (Exception e) {
            throw new ReflectiveOperationException(e);
        }
    }

    public static <T> T getStaticField(Field field) throws ReflectiveOperationException {
        try {
            implLookup.ensureInitialized(field.getDeclaringClass());
            return (T)unsafe.getObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field));
        }
        catch (Exception e) {
            throw new ReflectiveOperationException(e);
        }
    }

    static {
        if (!isSetup) {
            MohistJDK17EnumHelper.setup();
        }
    }
}

