/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.MohistMC;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.dynamicenumutil.MohistEnumHelper;
import com.mohistmc.entity.MohistModsEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_19_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_19_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;

public class ForgeInjectBukkit {
    public static BiMap<ResourceKey<LevelStem>, World.Environment> environment = HashBiMap.create((Map)ImmutableMap.builder().put((Object)LevelStem.f_63971_, (Object)World.Environment.NORMAL).put((Object)LevelStem.f_63972_, (Object)World.Environment.NETHER).put((Object)LevelStem.f_63973_, (Object)World.Environment.THE_END).build());
    public static Map<Villager.Profession, ResourceLocation> profession = new HashMap<Villager.Profession, ResourceLocation>();
    public static Map<Attribute, ResourceLocation> attributemap = new HashMap<Attribute, ResourceLocation>();

    public static void init() {
        ForgeInjectBukkit.addEnumMaterialInItems();
        ForgeInjectBukkit.addEnumMaterialsInBlocks();
        ForgeInjectBukkit.addEnumBiome();
        ForgeInjectBukkit.addEnumEnchantment();
        ForgeInjectBukkit.addEnumPotion();
        ForgeInjectBukkit.addEnumEntity();
        ForgeInjectBukkit.addEnumVillagerProfession();
    }

    public static void addEnumMaterialInItems() {
        IForgeRegistry<Item> registry = ForgeRegistries.ITEMS;
        for (Item item : registry) {
            ResourceLocation resourceLocation = registry.getKey(item);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String materialName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int id = Item.m_41393_((Item)item);
            Material material = Material.addMaterial(materialName, id, false, resourceLocation.m_135827_());
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            if (material == null) continue;
            MohistMC.LOGGER.debug("Save-ITEM: " + material.name() + " - " + materialName);
        }
    }

    public static void addEnumMaterialsInBlocks() {
        IForgeRegistry<Block> registry = ForgeRegistries.BLOCKS;
        for (Block block : registry) {
            ResourceLocation resourceLocation = registry.getKey(block);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String materialName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int id = Item.m_41393_((Item)block.m_5456_());
            Material material = Material.addMaterial(materialName, id, true, resourceLocation.m_135827_());
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            if (material == null) continue;
            MohistMC.LOGGER.debug("Save-BLOCK:" + material.name() + " - " + materialName);
        }
    }

    public static void addEnumEnchantment() {
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            org.bukkit.enchantments.Enchantment.registerEnchantment(new CraftEnchantment(enchantment));
        }
        org.bukkit.enchantments.Enchantment.stopAcceptingRegistrations();
    }

    public static void addEnumPotion() {
        for (MobEffect mobEffect : ForgeRegistries.MOB_EFFECTS) {
            CraftPotionEffectType pet = new CraftPotionEffectType(mobEffect);
            PotionEffectType.registerPotionEffectType(pet);
        }
        PotionEffectType.stopAcceptingRegistrations();
    }

    public static void addEnumBiome() {
        ArrayList<String> map = new ArrayList<String>();
        IForgeRegistry<net.minecraft.world.level.biome.Biome> registry = ForgeRegistries.BIOMES;
        for (net.minecraft.world.level.biome.Biome biome : registry) {
            ResourceLocation resourceLocation = registry.getKey(biome);
            String biomeName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation) || map.contains(biomeName)) continue;
            map.add(biomeName);
            Biome biomeCB = MohistEnumHelper.addEnum0(Biome.class, biomeName, new Class[0], new Object[0]);
            MohistMC.LOGGER.debug("Save-BIOME:" + biomeCB.name() + " - " + biomeName);
        }
        map.clear();
    }

    public static void addEnumEnvironment() {
        int i = World.Environment.values().length;
        Registry registry = ServerAPI.getNMSServer().m_206579_().m_175515_(Registries.f_256862_);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)environment.get((Object)key));
            if (environment1 != null) continue;
            String name = ForgeInjectBukkit.normalizeName(key.m_135782_().toString());
            int id = i - 1;
            environment1 = MohistEnumHelper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
            environment.put((Object)key, (Object)environment1);
            MohistMC.LOGGER.debug("Registered forge DimensionType as environment {}", (Object)environment1);
            ++i;
        }
    }

    public static WorldType addEnumWorldType(String name) {
        WorldType worldType = MohistEnumHelper.addEnum0(WorldType.class, name, new Class[]{String.class}, name);
        Map BY_NAME = (Map)ObfuscationReflectionHelper.getPrivateValue(WorldType.class, null, (String)"BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static void addEnumEntity() {
        IForgeRegistry<net.minecraft.world.entity.EntityType<?>> registry = ForgeRegistries.ENTITY_TYPES;
        for (net.minecraft.world.entity.EntityType entityType : registry) {
            ResourceLocation resourceLocation = registry.getKey(entityType);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String entityType2 = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int typeId = entityType2.hashCode();
            EntityType bukkitType = MohistEnumHelper.addEnum0(EntityType.class, entityType2, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, entityType2.toLowerCase(), MohistModsEntity.class, typeId, false);
            EntityType.NAME_MAP.put(entityType2.toLowerCase(), bukkitType);
            EntityType.ID_MAP.put((short)typeId, bukkitType);
            ServerAPI.entityTypeMap.put(entityType, entityType2);
        }
    }

    public static void addEnumVillagerProfession() {
        IForgeRegistry<VillagerProfession> registry = ForgeRegistries.VILLAGER_PROFESSIONS;
        for (VillagerProfession villagerProfession : registry) {
            ResourceLocation resourceLocation = registry.getKey(villagerProfession);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            Villager.Profession vp = MohistEnumHelper.addEnum0(Villager.Profession.class, name, new Class[0], new Object[0]);
            profession.put(vp, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge VillagerProfession as Profession {}", (Object)vp.name());
        }
    }

    public static void addEnumAttribute() {
        IForgeRegistry<net.minecraft.world.entity.ai.attributes.Attribute> registry = ForgeRegistries.ATTRIBUTES;
        for (net.minecraft.world.entity.ai.attributes.Attribute attribute : registry) {
            ResourceLocation resourceLocation = registry.getKey(attribute);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_());
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            Attribute ab = MohistEnumHelper.addEnum0(Attribute.class, name, new Class[]{String.class}, resourceLocation.m_135815_());
            attributemap.put(ab, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge Attribute as Attribute(Bukkit) {}", (Object)ab.name());
        }
    }

    public static String normalizeName(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
    }

    public static boolean isMINECRAFT(ResourceLocation resourceLocation) {
        return resourceLocation.m_135827_().equals("minecraft");
    }
}

