/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util.pluginmanager;

import com.mohistmc.util.pluginmanager.Control;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginManagers {
    public static String permission = "mohist.command.plugin";

    public static boolean loadPluginCommand(CommandSender sender, String label, String[] split) {
        PluginDescriptionFile desc;
        if (split.length < 2) {
            Object[] f = new Object[]{label};
            return true;
        }
        Object[] objects = new Object[]{split[1]};
        String jarName = split[1] + (split[1].endsWith(".jar") ? "" : ".jar");
        File toLoad = new File("plugins" + File.separator + jarName);
        if (!toLoad.exists()) {
            jarName = split[1] + (split[1].endsWith(".jar") ? ".unloaded" : ".jar.unloaded");
            toLoad = new File("plugins" + File.separator + jarName);
            if (!toLoad.exists()) {
                return true;
            }
            String fileName = jarName.substring(0, jarName.length() - ".unloaded".length());
            toLoad = new File("plugins" + File.separator + fileName);
            File unloaded = new File("plugins" + File.separator + jarName);
            unloaded.renameTo(toLoad);
        }
        if ((desc = Control.getDescription(toLoad)) == null) {
            return true;
        }
        Plugin[] pl = Bukkit.getPluginManager().getPlugins();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(Arrays.asList(pl));
        for (Plugin p : plugins) {
            if (!desc.getName().equals(p.getName())) continue;
            return true;
        }
        Plugin p = Control.loadPlugin(toLoad);
        if (p != null) {
            Bukkit.getServer().getPluginManager().enablePlugin(p);
        }
        return true;
    }

    public static boolean unloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (split.length < 2) {
            return true;
        }
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        Object[] objects = new Object[]{split[1]};
        if (p == null || Control.unloadPlugin(p)) {
            // empty if block
        }
        return true;
    }

    public static boolean reloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (split.length < 2) {
            return true;
        }
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        Object[] objects = new Object[]{split[1]};
        if (p != null) {
            File file = Control.getFile((JavaPlugin)p);
            if (file == null) {
                return true;
            }
            File name = new File("plugins" + File.separator + file.getName());
            JavaPlugin loaded = null;
            if (!Control.unloadPlugin(p) || (loaded = (JavaPlugin)Control.loadPlugin(name)) == null) {
                // empty if block
            }
            Bukkit.getPluginManager().enablePlugin(loaded);
        }
        return true;
    }
}

