/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R2.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_19_R2.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.structure.CraftPalette;
import org.bukkit.craftbukkit.v1_19_R2.util.RandomSourceWrapper;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.structure.Palette;
import org.bukkit.structure.Structure;
import org.bukkit.util.BlockVector;

public class CraftStructure
implements Structure {
    private final StructureTemplate structure;

    public CraftStructure(StructureTemplate structure) {
        this.structure = structure;
    }

    @Override
    public void place(Location location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        location.checkFinite();
        World world = location.getWorld();
        Validate.notNull((Object)world, (String)"location#getWorld() cannot be null", (Object[])new Object[0]);
        BlockVector blockVector = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.place(world, blockVector, includeEntities, structureRotation, mirror, palette, integrity, random);
    }

    @Override
    public void place(RegionAccessor regionAccessor, BlockVector location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        Validate.notNull((Object)regionAccessor, (String)"regionAccessor can not be null", (Object[])new Object[0]);
        location.checkFinite();
        if (integrity < 0.0f || integrity > 1.0f) {
            throw new IllegalArgumentException("Integrity must be between 0 and 1 inclusive. Was \"" + integrity + "\"");
        }
        RandomSourceWrapper randomSource = new RandomSourceWrapper(random);
        StructurePlaceSettings definedstructureinfo = new StructurePlaceSettings().m_74377_(net.minecraft.world.level.block.Mirror.valueOf((String)mirror.name())).m_74379_(Rotation.valueOf((String)structureRotation.name())).m_74392_(!includeEntities).m_74383_((StructureProcessor)new BlockRotProcessor(integrity)).m_230324_((RandomSource)randomSource);
        definedstructureinfo.f_74369_ = palette;
        BlockPos blockPosition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.structure.m_230328_((ServerLevelAccessor)((CraftRegionAccessor)regionAccessor).getHandle(), blockPosition, blockPosition, definedstructureinfo, (RandomSource)randomSource, 2);
    }

    @Override
    public void fill(Location corner1, Location corner2, boolean includeEntities) {
        Validate.notNull((Object)corner1, (String)"corner1 cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)corner2, (String)"corner2 cannot be null", (Object[])new Object[0]);
        World world = corner1.getWorld();
        Validate.notNull((Object)world, (String)"corner1#getWorld() cannot be null", (Object[])new Object[0]);
        Location origin = new Location(world, Math.min(corner1.getBlockX(), corner2.getBlockX()), Math.min(corner1.getBlockY(), corner2.getBlockY()), Math.min(corner1.getBlockZ(), corner2.getBlockZ()));
        BlockVector size = new BlockVector(Math.abs(corner1.getBlockX() - corner2.getBlockX()), Math.abs(corner1.getBlockY() - corner2.getBlockY()), Math.abs(corner1.getBlockZ() - corner2.getBlockZ()));
        this.fill(origin, size, includeEntities);
    }

    @Override
    public void fill(Location origin, BlockVector size, boolean includeEntities) {
        Validate.notNull((Object)origin, (String)"origin cannot be null", (Object[])new Object[0]);
        World world = origin.getWorld();
        Validate.notNull((Object)world, (String)"origin#getWorld() cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)size, (String)"size cannot be null", (Object[])new Object[0]);
        if (size.getBlockX() < 1 || size.getBlockY() < 1 || size.getBlockZ() < 1) {
            throw new IllegalArgumentException("Size must be at least 1x1x1 but was " + size.getBlockX() + "x" + size.getBlockY() + "x" + size.getBlockZ());
        }
        this.structure.m_163802_((Level)((CraftWorld)world).getHandle(), new BlockPos(origin.getBlockX(), origin.getBlockY(), origin.getBlockZ()), (Vec3i)new BlockPos(size.getBlockX(), size.getBlockY(), size.getBlockZ()), includeEntities, Blocks.f_50454_);
    }

    @Override
    public BlockVector getSize() {
        return new BlockVector(this.structure.m_163801_().m_123341_(), this.structure.m_163801_().m_123342_(), this.structure.m_163801_().m_123343_());
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList entities = new ArrayList();
        for (StructureTemplate.StructureEntityInfo entity : this.structure.f_74483_) {
            EntityType.m_20642_((CompoundTag)entity.f_74685_, (Level)((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle()).ifPresent(dummyEntity -> {
                dummyEntity.m_6034_(entity.f_74683_.f_82479_, entity.f_74683_.f_82480_, entity.f_74683_.f_82481_);
                entities.add(dummyEntity.getBukkitEntity());
            });
        }
        return Collections.unmodifiableList(entities);
    }

    @Override
    public int getEntityCount() {
        return this.structure.f_74483_.size();
    }

    @Override
    public List<Palette> getPalettes() {
        return this.structure.f_74482_.stream().map(CraftPalette::new).collect(Collectors.toList());
    }

    @Override
    public int getPaletteCount() {
        return this.structure.f_74482_.size();
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().persistentDataContainer;
    }

    public StructureTemplate getHandle() {
        return this.structure;
    }
}

