/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class PluginsModsDelete {
    public static final String NOT_COMPATIBLE = "not_compatible";
    public static final String FIX = "fix";
    public static final File PLUGIN = new File("plugins");
    public static final File MOD = new File("mods");

    public static void checkPlugins(ArrayList<Fix> fixes, File plugins) throws Exception {
        if (!plugins.exists() || fixes.size() == 0) {
            return;
        }
        for (File pom : plugins.listFiles((dir, name) -> name.endsWith(".jar"))) {
            ArrayList<String> entries = PluginsModsDelete.jarEntries(pom);
            if (entries == null) continue;
            StringBuilder allLines = new StringBuilder();
            if (plugins.equals(PLUGIN)) {
                if (!entries.contains("plugin.yml")) {
                    System.out.println("[WARN] Plugin with jar name " + pom.getName() + " doesn't contains any plugin.yml, the server may crash or the plugin will not load properly.");
                    continue;
                }
                try (JarFile pluginJar = new JarFile(pom);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(pluginJar.getInputStream(pluginJar.getJarEntry("plugin.yml"))));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        allLines.append(line).append("\n");
                    }
                }
            }
            for (Fix fix : fixes) {
                if (!entries.contains(fix.main.replaceAll("\\.", "/") + ".class")) continue;
                if (plugins.equals(PLUGIN)) {
                    if (fix.type.equals(FIX)) {
                        if (allLines.toString().contains("version: " + fix.version) || !allLines.toString().contains("main: " + fix.main)) continue;
                        System.out.println(i18n.get("update.pluginversion", pom.getName(), fix.version, fix.repo, fix.aim));
                        System.out.println(i18n.get("update.downloadpluginversion", pom.getName()));
                        if (!new Scanner(System.in).next().equals("yes")) continue;
                        UpdateUtils.downloadFile(fix.url, pom, fix.md5);
                        continue;
                    }
                    if (!fix.type.equals(NOT_COMPATIBLE) || !allLines.toString().contains("main: " + fix.main)) continue;
                    PluginsModsDelete.delete("plugins", pom);
                    continue;
                }
                PluginsModsDelete.delete("mods", pom);
            }
        }
    }

    private static void delete(String name, File f) throws Exception {
        System.out.println(i18n.get("update.deleting", f.getName(), name));
        File newPath = new File("delete/" + name + "/" + f.getName());
        newPath.getParentFile().mkdirs();
        Files.copy(f.toPath(), newPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
        f.delete();
    }

    private static ArrayList<String> jarEntries(File f) {
        ArrayList arrayList;
        JarFile jf = new JarFile(f);
        try {
            arrayList = ((Stream)jf.stream().sequential()).map(ZipEntry::getName).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("[WARN] - The jar file " + f.getName() + " (at " + f.getAbsolutePath() + ") is maybe corrupted or empty.");
                return null;
            }
        }
        jf.close();
        return arrayList;
    }

    public static class Fix {
        public String main;
        public String url;
        public String version;
        public String repo;
        public String type;
        public String aim;
        public String md5;

        public Fix(String mainClass, String url, String version, String repo, String aim, String md5) {
            this.main = mainClass;
            this.url = url;
            this.version = version;
            this.repo = repo;
            this.type = PluginsModsDelete.FIX;
            this.aim = aim;
            this.md5 = md5;
        }

        public Fix(String mainClass) {
            this.main = mainClass;
            this.type = PluginsModsDelete.NOT_COMPATIBLE;
        }
    }
}

