/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ItemPredicate {
    private static final Map<ResourceLocation, Function<JsonObject, ItemPredicate>> custom_predicates = new HashMap<ResourceLocation, Function<JsonObject, ItemPredicate>>();
    private static final Map<ResourceLocation, Function<JsonObject, ItemPredicate>> unmod_predicates = Collections.unmodifiableMap(custom_predicates);
    public static final ItemPredicate f_45028_ = new ItemPredicate();
    @Nullable
    private final TagKey<Item> f_45029_;
    @Nullable
    private final Set<Item> f_151427_;
    private final MinMaxBounds.Ints f_45031_;
    private final MinMaxBounds.Ints f_45032_;
    private final EnchantmentPredicate[] f_45033_;
    private final EnchantmentPredicate[] f_45034_;
    @Nullable
    private final Potion f_45035_;
    private final NbtPredicate f_45036_;

    public ItemPredicate() {
        this.f_45029_ = null;
        this.f_151427_ = null;
        this.f_45035_ = null;
        this.f_45031_ = MinMaxBounds.Ints.f_55364_;
        this.f_45032_ = MinMaxBounds.Ints.f_55364_;
        this.f_45033_ = EnchantmentPredicate.f_30465_;
        this.f_45034_ = EnchantmentPredicate.f_30465_;
        this.f_45036_ = NbtPredicate.f_57471_;
    }

    public ItemPredicate(@Nullable TagKey<Item> p_204137_, @Nullable Set<Item> p_204138_, MinMaxBounds.Ints p_204139_, MinMaxBounds.Ints p_204140_, EnchantmentPredicate[] p_204141_, EnchantmentPredicate[] p_204142_, @Nullable Potion p_204143_, NbtPredicate p_204144_) {
        this.f_45029_ = p_204137_;
        this.f_151427_ = p_204138_;
        this.f_45031_ = p_204139_;
        this.f_45032_ = p_204140_;
        this.f_45033_ = p_204141_;
        this.f_45034_ = p_204142_;
        this.f_45035_ = p_204143_;
        this.f_45036_ = p_204144_;
    }

    public boolean m_45049_(ItemStack p_45050_) {
        if (this == f_45028_) {
            return true;
        }
        if (this.f_45029_ != null && !p_45050_.m_204117_(this.f_45029_)) {
            return false;
        }
        if (this.f_151427_ != null && !this.f_151427_.contains(p_45050_.m_41720_())) {
            return false;
        }
        if (!this.f_45031_.m_55390_(p_45050_.m_41613_())) {
            return false;
        }
        if (!this.f_45032_.m_55327_() && !p_45050_.m_41763_()) {
            return false;
        }
        if (!this.f_45032_.m_55390_(p_45050_.m_41776_() - p_45050_.m_41773_())) {
            return false;
        }
        if (!this.f_45036_.m_57479_(p_45050_)) {
            return false;
        }
        if (this.f_45033_.length > 0) {
            Map map = p_45050_.getAllEnchantments();
            for (EnchantmentPredicate enchantmentpredicate : this.f_45033_) {
                if (enchantmentpredicate.m_30476_(map)) continue;
                return false;
            }
        }
        if (this.f_45034_.length > 0) {
            Map<Enchantment, Integer> map1 = EnchantmentHelper.m_44882_(EnchantedBookItem.m_41163_(p_45050_));
            for (EnchantmentPredicate enchantmentpredicate1 : this.f_45034_) {
                if (enchantmentpredicate1.m_30476_(map1)) continue;
                return false;
            }
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)p_45050_);
        return this.f_45035_ == null || this.f_45035_ == potion;
    }

    public static ItemPredicate m_45051_(@Nullable JsonElement p_45052_) {
        if (p_45052_ != null && !p_45052_.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_45052_, (String)"item");
            if (jsonobject.has("type")) {
                ResourceLocation rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
                if (custom_predicates.containsKey(rl)) {
                    return custom_predicates.get(rl).apply(jsonobject);
                }
                throw new JsonSyntaxException("There is no ItemPredicate of type " + rl);
            }
            MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("count"));
            MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("durability"));
            if (jsonobject.has("data")) {
                throw new JsonParseException("Disallowed data tag found");
            }
            NbtPredicate nbtpredicate = NbtPredicate.m_57481_((JsonElement)jsonobject.get("nbt"));
            ImmutableSet set = null;
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"items", (JsonArray)null);
            if (jsonarray != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (JsonElement jsonelement : jsonarray) {
                    ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13805_((JsonElement)jsonelement, (String)"item"));
                    builder.add((Object)((Item)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown item id '" + resourcelocation + "'"))));
                }
                set = builder.build();
            }
            TagKey tagkey = null;
            if (jsonobject.has("tag")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"tag"));
                tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourcelocation1);
            }
            Potion potion = null;
            if (jsonobject.has("potion")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"potion"));
                potion = (Potion)BuiltInRegistries.f_256980_.m_6612_(resourcelocation2).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + resourcelocation2 + "'"));
            }
            EnchantmentPredicate[] aenchantmentpredicate = EnchantmentPredicate.m_30480_((JsonElement)jsonobject.get("enchantments"));
            EnchantmentPredicate[] aenchantmentpredicate1 = EnchantmentPredicate.m_30480_((JsonElement)jsonobject.get("stored_enchantments"));
            return new ItemPredicate((TagKey<Item>)tagkey, (Set<Item>)set, minmaxbounds$ints, minmaxbounds$ints1, aenchantmentpredicate, aenchantmentpredicate1, potion, nbtpredicate);
        }
        return f_45028_;
    }

    public JsonElement m_45048_() {
        if (this == f_45028_) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (this.f_151427_ != null) {
            JsonArray jsonarray = new JsonArray();
            for (Item item : this.f_151427_) {
                jsonarray.add(BuiltInRegistries.f_257033_.m_7981_((Object)item).toString());
            }
            jsonobject.add("items", (JsonElement)jsonarray);
        }
        if (this.f_45029_ != null) {
            jsonobject.addProperty("tag", this.f_45029_.f_203868_().toString());
        }
        jsonobject.add("count", this.f_45031_.m_55328_());
        jsonobject.add("durability", this.f_45032_.m_55328_());
        jsonobject.add("nbt", this.f_45036_.m_57476_());
        if (this.f_45033_.length > 0) {
            JsonArray jsonarray1 = new JsonArray();
            for (EnchantmentPredicate enchantmentpredicate : this.f_45033_) {
                jsonarray1.add(enchantmentpredicate.m_30473_());
            }
            jsonobject.add("enchantments", (JsonElement)jsonarray1);
        }
        if (this.f_45034_.length > 0) {
            JsonArray jsonarray2 = new JsonArray();
            for (EnchantmentPredicate enchantmentpredicate1 : this.f_45034_) {
                jsonarray2.add(enchantmentpredicate1.m_30473_());
            }
            jsonobject.add("stored_enchantments", (JsonElement)jsonarray2);
        }
        if (this.f_45035_ != null) {
            jsonobject.addProperty("potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.f_45035_).toString());
        }
        return jsonobject;
    }

    public static ItemPredicate[] m_45055_(@Nullable JsonElement p_45056_) {
        if (p_45056_ != null && !p_45056_.isJsonNull()) {
            JsonArray jsonarray = GsonHelper.m_13924_((JsonElement)p_45056_, (String)"items");
            ItemPredicate[] aitempredicate = new ItemPredicate[jsonarray.size()];
            for (int i = 0; i < aitempredicate.length; ++i) {
                aitempredicate[i] = ItemPredicate.m_45051_(jsonarray.get(i));
            }
            return aitempredicate;
        }
        return new ItemPredicate[0];
    }

    public static void register(ResourceLocation name, Function<JsonObject, ItemPredicate> deserializer) {
        custom_predicates.put(name, deserializer);
    }

    public static Map<ResourceLocation, Function<JsonObject, ItemPredicate>> getPredicates() {
        return unmod_predicates;
    }

    public static class Builder {
        private final List<EnchantmentPredicate> f_45059_ = Lists.newArrayList();
        private final List<EnchantmentPredicate> f_45060_ = Lists.newArrayList();
        @Nullable
        private Set<Item> f_151440_;
        @Nullable
        private TagKey<Item> f_45062_;
        private MinMaxBounds.Ints f_45063_ = MinMaxBounds.Ints.f_55364_;
        private MinMaxBounds.Ints f_45064_ = MinMaxBounds.Ints.f_55364_;
        @Nullable
        private Potion f_45065_;
        private NbtPredicate f_45066_ = NbtPredicate.f_57471_;

        private Builder() {
        }

        public static Builder m_45068_() {
            return new Builder();
        }

        public Builder m_151445_(ItemLike ... p_151446_) {
            this.f_151440_ = (Set)Stream.of(p_151446_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public Builder m_204145_(TagKey<Item> p_204146_) {
            this.f_45062_ = p_204146_;
            return this;
        }

        public Builder m_151443_(MinMaxBounds.Ints p_151444_) {
            this.f_45063_ = p_151444_;
            return this;
        }

        public Builder m_151449_(MinMaxBounds.Ints p_151450_) {
            this.f_45064_ = p_151450_;
            return this;
        }

        public Builder m_151441_(Potion p_151442_) {
            this.f_45065_ = p_151442_;
            return this;
        }

        public Builder m_45075_(CompoundTag p_45076_) {
            this.f_45066_ = new NbtPredicate(p_45076_);
            return this;
        }

        public Builder m_45071_(EnchantmentPredicate p_45072_) {
            this.f_45059_.add(p_45072_);
            return this;
        }

        public Builder m_151447_(EnchantmentPredicate p_151448_) {
            this.f_45060_.add(p_151448_);
            return this;
        }

        public ItemPredicate m_45077_() {
            return new ItemPredicate(this.f_45062_, this.f_151440_, this.f_45063_, this.f_45064_, this.f_45059_.toArray(EnchantmentPredicate.f_30465_), this.f_45060_.toArray(EnchantmentPredicate.f_30465_), this.f_45065_, this.f_45066_);
        }
    }
}

