/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.packs;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PackSelectionScreen
extends Screen {
    static final Logger f_99969_ = LogUtils.getLogger();
    private static final int f_169993_ = 200;
    private static final Component f_99970_ = Component.m_237115_("pack.dropInfo").m_130940_(ChatFormatting.GRAY);
    private static final Component f_99971_ = Component.m_237115_("pack.folderInfo");
    private static final int f_169994_ = 20;
    private static final ResourceLocation f_99972_ = new ResourceLocation("textures/misc/unknown_pack.png");
    private final PackSelectionModel f_99973_;
    private final Screen f_99974_;
    @Nullable
    private Watcher f_99975_;
    private long f_99976_;
    private TransferableSelectionList f_99977_;
    private TransferableSelectionList f_99978_;
    private final Path f_99979_;
    private Button f_99980_;
    private final Map<String, ResourceLocation> f_99981_ = Maps.newHashMap();

    public PackSelectionScreen(Screen p_250119_, PackRepository p_249296_, Consumer<PackRepository> p_250932_, Path p_251292_, Component p_251319_) {
        super(p_251319_);
        this.f_99974_ = p_250119_;
        this.f_99973_ = new PackSelectionModel(this::m_100040_, this::m_99989_, p_249296_, p_250932_);
        this.f_99979_ = p_251292_;
        this.f_99975_ = Watcher.m_245748_(p_251292_);
    }

    @Override
    public void m_7379_() {
        this.f_99973_.m_99923_();
        this.f_96541_.m_91152_(this.f_99974_);
        this.m_100039_();
    }

    private void m_100039_() {
        if (this.f_99975_ != null) {
            try {
                this.f_99975_.close();
                this.f_99975_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void m_7856_() {
        this.f_99977_ = new TransferableSelectionList(this.f_96541_, (Screen)this, 200, this.f_96544_, (Component)Component.m_237115_("pack.available.title"));
        this.f_99977_.m_93507_(this.f_96543_ / 2 - 4 - 200);
        this.m_7787_(this.f_99977_);
        this.f_99978_ = new TransferableSelectionList(this.f_96541_, (Screen)this, 200, this.f_96544_, (Component)Component.m_237115_("pack.selected.title"));
        this.f_99978_.m_93507_(this.f_96543_ / 2 + 4);
        this.m_7787_(this.f_99978_);
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_("pack.openFolder"), p_100004_ -> Util.m_137581_().m_137648_(this.f_99979_.toUri())).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 48, 150, 20).m_257505_(Tooltip.m_257550_((Component)f_99971_)).m_253136_());
        this.f_99980_ = this.m_142416_(Button.m_253074_(CommonComponents.f_130655_, p_100036_ -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 48, 150, 20).m_253136_());
        this.m_100041_();
    }

    @Override
    public void m_86600_() {
        if (this.f_99975_ != null) {
            try {
                if (this.f_99975_.m_100046_()) {
                    this.f_99976_ = 20L;
                }
            }
            catch (IOException ioexception) {
                f_99969_.warn("Failed to poll for directory {} changes, stopping", (Object)this.f_99979_);
                this.m_100039_();
            }
        }
        if (this.f_99976_ > 0L && --this.f_99976_ == 0L) {
            this.m_100041_();
        }
    }

    private void m_100040_() {
        this.m_100013_(this.f_99978_, this.f_99973_.m_99918_());
        this.m_100013_(this.f_99977_, this.f_99973_.m_99913_());
        this.f_99980_.f_93623_ = !this.f_99978_.m_6702_().isEmpty();
    }

    private void m_100013_(TransferableSelectionList p_100014_, Stream<PackSelectionModel.Entry> p_100015_) {
        p_100014_.m_6702_().clear();
        p_100014_.m_6987_((AbstractSelectionList.Entry)((TransferableSelectionList.PackEntry)null));
        p_100015_.filter(PackSelectionModel.Entry::notHidden).forEach(p_170000_ -> p_100014_.m_6702_().add(new TransferableSelectionList.PackEntry(this.f_96541_, p_100014_, (Screen)this, p_170000_)));
    }

    private void m_100041_() {
        this.f_99973_.m_99926_();
        this.m_100040_();
        this.f_99976_ = 0L;
        this.f_99981_.clear();
    }

    @Override
    public void m_86412_(PoseStack p_99995_, int p_99996_, int p_99997_, float p_99998_) {
        this.m_96626_(0);
        this.f_99977_.m_86412_(p_99995_, p_99996_, p_99997_, p_99998_);
        this.f_99978_.m_86412_(p_99995_, p_99996_, p_99997_, p_99998_);
        PackSelectionScreen.m_93215_((PoseStack)p_99995_, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        PackSelectionScreen.m_93215_((PoseStack)p_99995_, (Font)this.f_96547_, (Component)f_99970_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_86412_(p_99995_, p_99996_, p_99997_, p_99998_);
    }

    protected static void m_99999_(Minecraft p_100000_, List<Path> p_100001_, Path p_100002_) {
        MutableBoolean mutableboolean = new MutableBoolean();
        p_100001_.forEach(p_170009_ -> {
            try (Stream<Path> stream = Files.walk(p_170009_, new FileVisitOption[0]);){
                stream.forEach(p_170005_ -> {
                    try {
                        Util.m_137563_(p_170009_.getParent(), p_100002_, p_170005_);
                    }
                    catch (IOException ioexception1) {
                        f_99969_.warn("Failed to copy datapack file  from {} to {}", new Object[]{p_170005_, p_100002_, ioexception1});
                        mutableboolean.setTrue();
                    }
                });
            }
            catch (IOException ioexception) {
                f_99969_.warn("Failed to copy datapack file from {} to {}", p_170009_, (Object)p_100002_);
                mutableboolean.setTrue();
            }
        });
        if (mutableboolean.isTrue()) {
            SystemToast.m_94875_((Minecraft)p_100000_, (String)p_100002_.toString());
        }
    }

    @Override
    public void m_7400_(List<Path> p_100029_) {
        String s = p_100029_.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(p_170012_ -> {
            if (p_170012_) {
                PackSelectionScreen.m_99999_(this.f_96541_, p_100029_, this.f_99979_);
                this.m_100041_();
            }
            this.f_96541_.m_91152_(this);
        }, (Component)Component.m_237115_("pack.dropConfirm"), (Component)Component.m_237113_(s)));
    }

    private ResourceLocation m_100016_(TextureManager p_100017_, Pack p_100018_) {
        try {
            ResourceLocation resourcelocation2;
            block16: {
                ResourceLocation resourcelocation1;
                try (PackResources packresources = p_100018_.m_10445_();){
                    IoSupplier<InputStream> iosupplier = packresources.m_8017_("pack.png");
                    if (iosupplier == null) {
                        resourcelocation2 = f_99972_;
                        break block16;
                    }
                    String s = p_100018_.m_10446_();
                    ResourceLocation resourcelocation = new ResourceLocation("minecraft", "pack/" + Util.m_137483_(s, ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
                    try (InputStream inputstream = (InputStream)iosupplier.m_247737_();){
                        NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);
                        p_100017_.m_118495_(resourcelocation, (AbstractTexture)new DynamicTexture(nativeimage));
                        resourcelocation1 = resourcelocation;
                    }
                }
                return resourcelocation1;
            }
            return resourcelocation2;
        }
        catch (Exception exception) {
            f_99969_.warn("Failed to load icon from pack {}", (Object)p_100018_.m_10446_(), (Object)exception);
            return f_99972_;
        }
    }

    private ResourceLocation m_99989_(Pack p_99990_) {
        return this.f_99981_.computeIfAbsent(p_99990_.m_10446_(), p_169997_ -> this.m_100016_(this.f_96541_.m_91097_(), p_99990_));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Watcher
    implements AutoCloseable {
        private final WatchService f_100042_;
        private final Path f_100043_;

        public Watcher(Path p_250327_) throws IOException {
            this.f_100043_ = p_250327_;
            this.f_100042_ = p_250327_.getFileSystem().newWatchService();
            try {
                this.m_100049_(p_250327_);
                try (DirectoryStream<Path> directorystream = Files.newDirectoryStream(p_250327_);){
                    for (Path path : directorystream) {
                        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.m_100049_(path);
                    }
                }
            }
            catch (Exception exception) {
                this.f_100042_.close();
                throw exception;
            }
        }

        @Nullable
        public static Watcher m_245748_(Path p_252119_) {
            try {
                return new Watcher(p_252119_);
            }
            catch (IOException ioexception) {
                f_99969_.warn("Failed to initialize pack directory {} monitoring", (Object)p_252119_, (Object)ioexception);
                return null;
            }
        }

        private void m_100049_(Path p_100050_) throws IOException {
            p_100050_.register(this.f_100042_, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        public boolean m_100046_() throws IOException {
            WatchKey watchkey;
            boolean flag = false;
            while ((watchkey = this.f_100042_.poll()) != null) {
                for (WatchEvent<?> watchevent : watchkey.pollEvents()) {
                    Path path;
                    flag = true;
                    if (watchkey.watchable() != this.f_100043_ || watchevent.kind() != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory(path = this.f_100043_.resolve((Path)watchevent.context()), LinkOption.NOFOLLOW_LINKS)) continue;
                    this.m_100049_(path);
                }
                watchkey.reset();
            }
            return flag;
        }

        @Override
        public void close() throws IOException {
            this.f_100042_.close();
        }
    }
}

