/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderer {
    private static final int f_172575_ = 96;
    private static final List<MobEffectFogFunction> f_234164_ = Lists.newArrayList((Object[])new MobEffectFogFunction[]{new BlindnessFogFunction(), new DarknessFogFunction()});
    public static final float f_172574_ = 5000.0f;
    private static float f_109010_;
    private static float f_109011_;
    private static float f_109012_;
    private static int f_109013_;
    private static int f_109014_;
    private static long f_109015_;

    public static void m_109018_(Camera p_109019_, float p_109020_, ClientLevel p_109021_, int p_109022_, float p_109023_) {
        LivingEntity livingentity1;
        FogType fogtype = p_109019_.m_167685_();
        Entity entity = p_109019_.m_90592_();
        if (fogtype == FogType.WATER) {
            long i = Util.m_137550_();
            int j = ((Biome)p_109021_.m_204166_(new BlockPos(p_109019_.m_90583_())).m_203334_()).m_47561_();
            if (f_109015_ < 0L) {
                f_109013_ = j;
                f_109014_ = j;
                f_109015_ = i;
            }
            int k = f_109013_ >> 16 & 0xFF;
            int l = f_109013_ >> 8 & 0xFF;
            int i1 = f_109013_ & 0xFF;
            int j1 = f_109014_ >> 16 & 0xFF;
            int k1 = f_109014_ >> 8 & 0xFF;
            int l1 = f_109014_ & 0xFF;
            float f = Mth.m_14036_((float)((float)(i - f_109015_) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = Mth.m_14179_((float)f, (float)j1, (float)k);
            float f2 = Mth.m_14179_((float)f, (float)k1, (float)l);
            float f3 = Mth.m_14179_((float)f, (float)l1, (float)i1);
            f_109010_ = f1 / 255.0f;
            f_109011_ = f2 / 255.0f;
            f_109012_ = f3 / 255.0f;
            if (f_109013_ != j) {
                f_109013_ = j;
                f_109014_ = Mth.m_14143_((float)f1) << 16 | Mth.m_14143_((float)f2) << 8 | Mth.m_14143_((float)f3);
                f_109015_ = i;
            }
        } else if (fogtype == FogType.LAVA) {
            f_109010_ = 0.6f;
            f_109011_ = 0.1f;
            f_109012_ = 0.0f;
            f_109015_ = -1L;
        } else if (fogtype == FogType.POWDER_SNOW) {
            f_109010_ = 0.623f;
            f_109011_ = 0.734f;
            f_109012_ = 0.785f;
            f_109015_ = -1L;
            RenderSystem.m_69424_((float)f_109010_, (float)f_109011_, (float)f_109012_, (float)0.0f);
        } else {
            float f15;
            float f4 = 0.25f + 0.75f * (float)p_109022_ / 32.0f;
            f4 = 1.0f - (float)Math.pow(f4, 0.25);
            Vec3 vec3 = p_109021_.m_171660_(p_109019_.m_90583_(), p_109020_);
            float f6 = (float)vec3.f_82479_;
            float f8 = (float)vec3.f_82480_;
            float f10 = (float)vec3.f_82481_;
            float f11 = Mth.m_14036_((float)(Mth.m_14089_((float)(p_109021_.m_46942_(p_109020_) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            BiomeManager biomemanager = p_109021_.m_7062_();
            Vec3 vec31 = p_109019_.m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
            Vec3 vec32 = CubicSampler.m_130038_((Vec3)vec31, (p_109033_, p_109034_, p_109035_) -> p_109021_.m_104583_().m_5927_(Vec3.m_82501_((int)((Biome)biomemanager.m_204210_(p_109033_, p_109034_, p_109035_).m_203334_()).m_47539_()), f11));
            f_109010_ = (float)vec32.m_7096_();
            f_109011_ = (float)vec32.m_7098_();
            f_109012_ = (float)vec32.m_7094_();
            if (p_109022_ >= 4) {
                float[] afloat;
                float f12 = Mth.m_14031_((float)p_109021_.m_46490_(p_109020_)) > 0.0f ? -1.0f : 1.0f;
                Vector3f vector3f = new Vector3f(f12, 0.0f, 0.0f);
                float f16 = p_109019_.m_253058_().dot((Vector3fc)vector3f);
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                if (f16 > 0.0f && (afloat = p_109021_.m_104583_().m_7518_(p_109021_.m_46942_(p_109020_), p_109020_)) != null) {
                    f_109010_ = f_109010_ * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                    f_109011_ = f_109011_ * (1.0f - f16) + afloat[1] * f16;
                    f_109012_ = f_109012_ * (1.0f - f16) + afloat[2] * f16;
                }
            }
            f_109010_ += (f6 - f_109010_) * f4;
            f_109011_ += (f8 - f_109011_) * f4;
            f_109012_ += (f10 - f_109012_) * f4;
            float f13 = p_109021_.m_46722_(p_109020_);
            if (f13 > 0.0f) {
                float f14 = 1.0f - f13 * 0.5f;
                float f17 = 1.0f - f13 * 0.4f;
                f_109010_ *= f14;
                f_109011_ *= f14;
                f_109012_ *= f17;
            }
            if ((f15 = p_109021_.m_46661_(p_109020_)) > 0.0f) {
                float f18 = 1.0f - f15 * 0.5f;
                f_109010_ *= f18;
                f_109011_ *= f18;
                f_109012_ *= f18;
            }
            f_109015_ = -1L;
        }
        float f5 = ((float)p_109019_.m_90583_().f_82480_ - (float)p_109021_.m_141937_()) * p_109021_.m_6106_().m_205519_();
        MobEffectFogFunction fogrenderer$mobeffectfogfunction = FogRenderer.m_234165_(entity, p_109020_);
        if (fogrenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            f5 = fogrenderer$mobeffectfogfunction.m_213936_(livingentity, livingentity.m_21124_(fogrenderer$mobeffectfogfunction.m_213948_()), f5, p_109020_);
        }
        if (f5 < 1.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            f5 *= f5;
            f_109010_ *= f5;
            f_109011_ *= f5;
            f_109012_ *= f5;
        }
        if (p_109023_ > 0.0f) {
            f_109010_ = f_109010_ * (1.0f - p_109023_) + f_109010_ * 0.7f * p_109023_;
            f_109011_ = f_109011_ * (1.0f - p_109023_) + f_109011_ * 0.6f * p_109023_;
            f_109012_ = f_109012_ * (1.0f - p_109023_) + f_109012_ * 0.6f * p_109023_;
        }
        float f7 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).m_108639_() : 1.0f) : (entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).m_21023_(MobEffects.f_19611_) && !livingentity1.m_21023_(MobEffects.f_216964_) ? GameRenderer.m_109108_(livingentity1, p_109020_) : 0.0f);
        if (f_109010_ != 0.0f && f_109011_ != 0.0f && f_109012_ != 0.0f) {
            float f9 = Math.min(1.0f / f_109010_, Math.min(1.0f / f_109011_, 1.0f / f_109012_));
            f_109010_ = f_109010_ * (1.0f - f7) + f_109010_ * f9 * f7;
            f_109011_ = f_109011_ * (1.0f - f7) + f_109011_ * f9 * f7;
            f_109012_ = f_109012_ * (1.0f - f7) + f_109012_ * f9 * f7;
        }
        Vector3f fogColor = ForgeHooksClient.getFogColor((Camera)p_109019_, (float)p_109020_, (ClientLevel)p_109021_, (int)p_109022_, (float)p_109023_, (float)f_109010_, (float)f_109011_, (float)f_109012_);
        f_109010_ = fogColor.x();
        f_109011_ = fogColor.y();
        f_109012_ = fogColor.z();
        RenderSystem.m_69424_((float)f_109010_, (float)f_109011_, (float)f_109012_, (float)0.0f);
    }

    public static void m_109017_() {
        RenderSystem.m_157445_((float)Float.MAX_VALUE);
    }

    @Nullable
    private static MobEffectFogFunction m_234165_(Entity p_234166_, float p_234167_) {
        if (p_234166_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_234166_;
            return f_234164_.stream().filter(p_234171_ -> p_234171_.m_234205_(livingentity, p_234167_)).findFirst().orElse(null);
        }
        return null;
    }

    public static void m_234172_(Camera p_234173_, FogMode p_234174_, float p_234175_, boolean p_234176_, float p_234177_) {
        FogType fogtype = p_234173_.m_167685_();
        Entity entity = p_234173_.m_90592_();
        FogData fogrenderer$fogdata = new FogData(p_234174_);
        MobEffectFogFunction fogrenderer$mobeffectfogfunction = FogRenderer.m_234165_(entity, p_234177_);
        if (fogtype == FogType.LAVA) {
            if (entity.m_5833_()) {
                fogrenderer$fogdata.f_234200_ = -8.0f;
                fogrenderer$fogdata.f_234201_ = p_234175_ * 0.5f;
            } else if (entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19607_)) {
                fogrenderer$fogdata.f_234200_ = 0.0f;
                fogrenderer$fogdata.f_234201_ = 3.0f;
            } else {
                fogrenderer$fogdata.f_234200_ = 0.25f;
                fogrenderer$fogdata.f_234201_ = 1.0f;
            }
        } else if (fogtype == FogType.POWDER_SNOW) {
            if (entity.m_5833_()) {
                fogrenderer$fogdata.f_234200_ = -8.0f;
                fogrenderer$fogdata.f_234201_ = p_234175_ * 0.5f;
            } else {
                fogrenderer$fogdata.f_234200_ = 0.0f;
                fogrenderer$fogdata.f_234201_ = 2.0f;
            }
        } else if (fogrenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            MobEffectInstance mobeffectinstance = livingentity.m_21124_(fogrenderer$mobeffectfogfunction.m_213948_());
            if (mobeffectinstance != null) {
                fogrenderer$mobeffectfogfunction.m_213725_(fogrenderer$fogdata, livingentity, mobeffectinstance, p_234175_, p_234177_);
            }
        } else if (fogtype == FogType.WATER) {
            fogrenderer$fogdata.f_234200_ = -8.0f;
            fogrenderer$fogdata.f_234201_ = 96.0f;
            if (entity instanceof LocalPlayer) {
                LocalPlayer localplayer = (LocalPlayer)entity;
                fogrenderer$fogdata.f_234201_ *= Math.max(0.25f, localplayer.m_108639_());
                Holder holder = localplayer.f_19853_.m_204166_(localplayer.m_20183_());
                if (holder.m_203656_(BiomeTags.f_215802_)) {
                    fogrenderer$fogdata.f_234201_ *= 0.85f;
                }
            }
            if (fogrenderer$fogdata.f_234201_ > p_234175_) {
                fogrenderer$fogdata.f_234201_ = p_234175_;
                fogrenderer$fogdata.f_234202_ = FogShape.CYLINDER;
            }
        } else if (p_234176_) {
            fogrenderer$fogdata.f_234200_ = p_234175_ * 0.05f;
            fogrenderer$fogdata.f_234201_ = Math.min(p_234175_, 192.0f) * 0.5f;
        } else if (p_234174_ == FogMode.FOG_SKY) {
            fogrenderer$fogdata.f_234200_ = 0.0f;
            fogrenderer$fogdata.f_234201_ = p_234175_;
            fogrenderer$fogdata.f_234202_ = FogShape.CYLINDER;
        } else {
            float f = Mth.m_14036_((float)(p_234175_ / 10.0f), (float)4.0f, (float)64.0f);
            fogrenderer$fogdata.f_234200_ = p_234175_ - f;
            fogrenderer$fogdata.f_234201_ = p_234175_;
            fogrenderer$fogdata.f_234202_ = FogShape.CYLINDER;
        }
        RenderSystem.m_157445_((float)fogrenderer$fogdata.f_234200_);
        RenderSystem.m_157443_((float)fogrenderer$fogdata.f_234201_);
        RenderSystem.m_202160_((FogShape)fogrenderer$fogdata.f_234202_);
        ForgeHooksClient.onFogRender((FogMode)p_234174_, (FogType)fogtype, (Camera)p_234173_, (float)p_234177_, (float)p_234175_, (float)fogrenderer$fogdata.f_234200_, (float)fogrenderer$fogdata.f_234201_, (FogShape)fogrenderer$fogdata.f_234202_);
    }

    public static void m_109036_() {
        RenderSystem.m_157434_((float)f_109010_, (float)f_109011_, (float)f_109012_);
    }

    static {
        f_109013_ = -1;
        f_109014_ = -1;
        f_109015_ = -1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface MobEffectFogFunction {
        public MobEffect m_213948_();

        public void m_213725_(FogData var1, LivingEntity var2, MobEffectInstance var3, float var4, float var5);

        default public boolean m_234205_(LivingEntity p_234206_, float p_234207_) {
            return p_234206_.m_21023_(this.m_213948_());
        }

        default public float m_213936_(LivingEntity p_234208_, MobEffectInstance p_234209_, float p_234210_, float p_234211_) {
            MobEffectInstance mobeffectinstance = p_234208_.m_21124_(this.m_213948_());
            if (mobeffectinstance != null) {
                p_234210_ = mobeffectinstance.m_19557_() < 20 ? 1.0f - (float)mobeffectinstance.m_19557_() / 20.0f : 0.0f;
            }
            return p_234210_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FogData {
        public final FogMode f_234199_;
        public float f_234200_;
        public float f_234201_;
        public FogShape f_234202_ = FogShape.SPHERE;

        public FogData(FogMode p_234204_) {
            this.f_234199_ = p_234204_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class FogMode
    extends Enum<FogMode> {
        public static final /* enum */ FogMode FOG_SKY = new FogMode();
        public static final /* enum */ FogMode FOG_TERRAIN = new FogMode();
        private static final /* synthetic */ FogMode[] $VALUES;

        public static FogMode[] values() {
            return (FogMode[])$VALUES.clone();
        }

        public static FogMode valueOf(String p_109045_) {
            return Enum.valueOf(FogMode.class, p_109045_);
        }

        private static /* synthetic */ FogMode[] m_172577_() {
            return new FogMode[]{FOG_SKY, FOG_TERRAIN};
        }

        static {
            $VALUES = FogMode.m_172577_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlindnessFogFunction
    implements MobEffectFogFunction {
        BlindnessFogFunction() {
        }

        @Override
        public MobEffect m_213948_() {
            return MobEffects.f_19610_;
        }

        @Override
        public void m_213725_(FogData p_234181_, LivingEntity p_234182_, MobEffectInstance p_234183_, float p_234184_, float p_234185_) {
            float f = Mth.m_14179_((float)Math.min(1.0f, (float)p_234183_.m_19557_() / 20.0f), (float)p_234184_, (float)5.0f);
            if (p_234181_.f_234199_ == FogMode.FOG_SKY) {
                p_234181_.f_234200_ = 0.0f;
                p_234181_.f_234201_ = f * 0.8f;
            } else {
                p_234181_.f_234200_ = f * 0.25f;
                p_234181_.f_234201_ = f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DarknessFogFunction
    implements MobEffectFogFunction {
        DarknessFogFunction() {
        }

        @Override
        public MobEffect m_213948_() {
            return MobEffects.f_216964_;
        }

        @Override
        public void m_213725_(FogData p_234194_, LivingEntity p_234195_, MobEffectInstance p_234196_, float p_234197_, float p_234198_) {
            if (!p_234196_.m_216895_().isEmpty()) {
                float f = Mth.m_14179_((float)p_234196_.m_216895_().get().m_238413_(p_234195_, p_234198_), (float)p_234197_, (float)15.0f);
                p_234194_.f_234200_ = p_234194_.f_234199_ == FogMode.FOG_SKY ? 0.0f : f * 0.75f;
                p_234194_.f_234201_ = f;
            }
        }

        @Override
        public float m_213936_(LivingEntity p_234189_, MobEffectInstance p_234190_, float p_234191_, float p_234192_) {
            return p_234190_.m_216895_().isEmpty() ? 0.0f : 1.0f - p_234190_.m_216895_().get().m_238413_(p_234189_, p_234192_);
        }
    }
}

