/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DelegatingOps<T> {
    private final RegistryInfoLookup f_254668_;

    private static RegistryInfoLookup m_255214_(final RegistryInfoLookup p_255769_) {
        return new RegistryInfoLookup(){
            private final Map<ResourceKey<? extends Registry<?>>, Optional<? extends RegistryInfo<?>>> f_254621_ = new HashMap();

            @Override
            public <T> Optional<RegistryInfo<T>> m_254838_(ResourceKey<? extends Registry<? extends T>> p_256043_) {
                return this.f_254621_.computeIfAbsent(p_256043_, p_255769_::m_254838_);
            }
        };
    }

    public static <T> RegistryOps<T> m_255058_(DynamicOps<T> p_256342_, final HolderLookup.Provider p_255950_) {
        return RegistryOps.m_255060_(p_256342_, RegistryOps.m_255214_(new RegistryInfoLookup(){

            public <E> Optional<RegistryInfo<E>> m_254838_(ResourceKey<? extends Registry<? extends E>> p_256323_) {
                return p_255950_.m_254861_(p_256323_).map(p_258224_ -> new RegistryInfo(p_258224_, p_258224_, p_258224_.m_254883_()));
            }
        }));
    }

    public static <T> RegistryOps<T> m_255060_(DynamicOps<T> p_256278_, RegistryInfoLookup p_256479_) {
        return new RegistryOps<T>(p_256278_, p_256479_);
    }

    private RegistryOps(DynamicOps<T> p_256313_, RegistryInfoLookup p_255799_) {
        super(p_256313_);
        this.f_254668_ = p_255799_;
    }

    public <E> Optional<HolderOwner<E>> m_255056_(ResourceKey<? extends Registry<? extends E>> p_255757_) {
        return this.f_254668_.m_254838_(p_255757_).map(RegistryInfo::f_254675_);
    }

    public <E> Optional<HolderGetter<E>> m_255006_(ResourceKey<? extends Registry<? extends E>> p_256031_) {
        return this.f_254668_.m_254838_(p_256031_).map(RegistryInfo::f_254724_);
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> m_255175_(ResourceKey<? extends Registry<? extends E>> p_206833_) {
        return ExtraCodecs.m_203976_(p_255523_ -> {
            if (p_255523_ instanceof RegistryOps) {
                RegistryOps registryops = (RegistryOps)((Object)p_255523_);
                return registryops.f_254668_.m_254838_(p_206833_).map(p_255527_ -> DataResult.success(p_255527_.f_254724_(), (Lifecycle)p_255527_.f_254751_())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + p_206833_)));
            }
            return DataResult.error((String)"Not a registry ops");
        }).forGetter(p_255526_ -> null);
    }

    public static <E> MapCodec<HolderLookup.RegistryLookup<E>> retrieveRegistryLookup(ResourceKey<? extends Registry<? extends E>> resourceKey) {
        return ExtraCodecs.m_203976_(ops -> {
            if (!(ops instanceof RegistryOps)) {
                return DataResult.error((String)"Not a registry ops");
            }
            RegistryOps registryOps = (RegistryOps)((Object)ops);
            return registryOps.f_254668_.m_254838_(resourceKey).map(registryInfo -> {
                HolderOwner patt3672$temp = registryInfo.f_254675_();
                if (!(patt3672$temp instanceof HolderLookup.RegistryLookup)) {
                    return DataResult.error((String)("Found holder getter but was not a registry lookup for " + resourceKey));
                }
                HolderLookup.RegistryLookup registryLookup = (HolderLookup.RegistryLookup)patt3672$temp;
                return DataResult.success((Object)registryLookup, (Lifecycle)registryInfo.f_254751_());
            }).orElseGet(() -> DataResult.error((String)("Unknown registry: " + resourceKey)));
        });
    }

    public static <E, O> RecordCodecBuilder<O, Holder.Reference<E>> m_254866_(ResourceKey<E> p_256347_) {
        ResourceKey resourcekey = ResourceKey.m_135788_(p_256347_.m_211136_());
        return ExtraCodecs.m_203976_(p_255521_ -> {
            if (p_255521_ instanceof RegistryOps) {
                RegistryOps registryops = (RegistryOps)((Object)p_255521_);
                return registryops.f_254668_.m_254838_(resourcekey).flatMap(p_255518_ -> p_255518_.f_254724_().m_254902_(p_256347_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Can't find value: " + p_256347_)));
            }
            return DataResult.error((String)"Not a registry ops");
        }).forGetter(p_255524_ -> null);
    }

    public static interface RegistryInfoLookup {
        public <T> Optional<RegistryInfo<T>> m_254838_(ResourceKey<? extends Registry<? extends T>> var1);
    }

    public record RegistryInfo<T>(HolderOwner<T> f_254675_, HolderGetter<T> f_254724_, Lifecycle f_254751_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryInfo.class, "owner;getter;elementsLifecycle", "f_254675_", "f_254724_", "f_254751_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryInfo.class, "owner;getter;elementsLifecycle", "f_254675_", "f_254724_", "f_254751_"}, this);
        }

        @Override
        public final boolean equals(Object p_256498_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryInfo.class, "owner;getter;elementsLifecycle", "f_254675_", "f_254724_", "f_254751_"}, this, p_256498_);
        }
    }
}

