/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;

public abstract class DistanceManager {
    static final Logger f_140758_ = LogUtils.getLogger();
    private static final int f_143205_ = 2;
    static final int f_140759_ = 33 + ChunkStatus.m_62370_((ChunkStatus)ChunkStatus.f_62326_) - 2;
    private static final int f_143206_ = 4;
    private static final int f_183899_ = 32;
    private static final int f_183900_ = 33;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> f_140760_ = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> f_140761_ = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker f_140762_ = new ChunkTicketTracker();
    private final FixedPlayerDistanceChunkTracker f_140763_ = new FixedPlayerDistanceChunkTracker(8);
    private final TickingTracker f_183901_ = new TickingTracker();
    private final PlayerTicketTracker f_140764_ = new PlayerTicketTracker(33);
    final Set<ChunkHolder> f_140765_ = Sets.newHashSet();
    final ChunkTaskPriorityQueueSorter f_140766_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140767_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> f_140768_;
    final LongSet f_140769_ = new LongOpenHashSet();
    final Executor f_140770_;
    private long f_140771_;
    private int f_183902_ = 10;
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> forcedTickets = new Long2ObjectOpenHashMap();

    protected DistanceManager(Executor p_140774_, Executor p_140775_) {
        ChunkTaskPriorityQueueSorter chunktaskpriorityqueuesorter;
        ProcessorHandle processorhandle = ProcessorHandle.m_18714_((String)"player ticket throttler", p_140775_::execute);
        this.f_140766_ = chunktaskpriorityqueuesorter = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)processorhandle), p_140774_, 4);
        this.f_140767_ = chunktaskpriorityqueuesorter.m_140604_(processorhandle, true);
        this.f_140768_ = chunktaskpriorityqueuesorter.m_140567_(processorhandle);
        this.f_140770_ = p_140775_;
    }

    protected void m_140776_() {
        ++this.f_140771_;
        ObjectIterator objectiterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((SortedArraySet)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticket.m_9434_(this.f_140771_)) continue;
                iterator.remove();
                flag = true;
                this.f_183901_.m_184165_(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_((SortedArraySet)entry.getValue()), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int m_140797_(SortedArraySet<Ticket<?>> p_140798_) {
        return !p_140798_.isEmpty() ? ((Ticket)p_140798_.m_14262_()).m_9433_() : ChunkMap.f_140127_ + 1;
    }

    protected abstract boolean m_7009_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7316_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7288_(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean m_140805_(ChunkMap p_140806_) {
        boolean flag;
        this.f_140763_.m_6410_();
        this.f_183901_.m_184145_();
        this.f_140764_.m_6410_();
        int i = Integer.MAX_VALUE - this.f_140762_.m_140877_(Integer.MAX_VALUE);
        boolean bl = flag = i != 0;
        if (flag) {
            // empty if block
        }
        if (!this.f_140765_.isEmpty()) {
            this.f_140765_.forEach(p_183908_ -> p_183908_.m_143003_(p_140806_, this.f_140770_));
            this.f_140765_.clear();
            return true;
        }
        if (!this.f_140769_.isEmpty()) {
            LongIterator longiterator = this.f_140769_.iterator();
            while (longiterator.hasNext()) {
                long j = longiterator.nextLong();
                if (!this.m_140857_(j).stream().anyMatch(p_183910_ -> p_183910_.m_9428_() == TicketType.f_9444_)) continue;
                ChunkHolder chunkholder = p_140806_.m_140174_(j);
                if (chunkholder == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> completablefuture = chunkholder.m_140073_();
                completablefuture.thenAccept(p_183905_ -> this.f_140770_.execute(() -> this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, (long)j, (boolean)false))));
            }
            this.f_140769_.clear();
        }
        return flag;
    }

    void m_140784_(long p_140785_, Ticket<?> p_140786_) {
        SortedArraySet<Ticket<?>> sortedarrayset = this.m_140857_(p_140785_);
        int i = DistanceManager.m_140797_(sortedarrayset);
        Ticket ticket = (Ticket)sortedarrayset.m_14253_(p_140786_);
        ticket.m_9429_(this.f_140771_);
        if (p_140786_.m_9433_() < i) {
            this.f_140762_.m_140715_(p_140785_, p_140786_.m_9433_(), true);
        }
        if (p_140786_.isForceTicks()) {
            SortedArraySet tickets = (SortedArraySet)this.forcedTickets.computeIfAbsent(p_140785_, e -> SortedArraySet.m_14246_((int)4));
            tickets.m_14253_((Object)ticket);
        }
    }

    boolean addTicketCB(long p_140785_, Ticket<?> p_140786_) {
        SortedArraySet<Ticket<?>> sortedarrayset = this.m_140857_(p_140785_);
        int i = DistanceManager.m_140797_(sortedarrayset);
        Ticket ticket = (Ticket)sortedarrayset.m_14253_(p_140786_);
        ticket.m_9429_(this.f_140771_);
        if (p_140786_.m_9433_() < i) {
            this.f_140762_.m_140715_(p_140785_, p_140786_.m_9433_(), true);
        }
        if (p_140786_.isForceTicks()) {
            SortedArraySet tickets = (SortedArraySet)this.forcedTickets.computeIfAbsent(p_140785_, e -> SortedArraySet.m_14246_((int)4));
            tickets.m_14253_((Object)ticket);
        }
        return p_140786_ == ticket;
    }

    void m_140818_(long p_140819_, Ticket<?> p_140820_) {
        SortedArraySet tickets;
        SortedArraySet<Ticket<?>> sortedarrayset = this.m_140857_(p_140819_);
        if (sortedarrayset.remove(p_140820_)) {
            // empty if block
        }
        if (sortedarrayset.isEmpty()) {
            this.f_140761_.remove(p_140819_);
        }
        this.f_140762_.m_140715_(p_140819_, DistanceManager.m_140797_(sortedarrayset), false);
        if (p_140820_.isForceTicks() && (tickets = (SortedArraySet)this.forcedTickets.get(p_140819_)) != null) {
            tickets.remove(p_140820_);
        }
    }

    boolean removeTicketCB(long p_140819_, Ticket<?> p_140820_) {
        SortedArraySet tickets;
        SortedArraySet<Ticket<?>> sortedarrayset = this.m_140857_(p_140819_);
        if (sortedarrayset.remove(p_140820_)) {
            // empty if block
        }
        boolean removed = false;
        if (sortedarrayset.isEmpty()) {
            this.f_140761_.remove(p_140819_);
            removed = true;
        }
        this.f_140762_.m_140715_(p_140819_, DistanceManager.m_140797_(sortedarrayset), false);
        if (p_140820_.isForceTicks() && (tickets = (SortedArraySet)this.forcedTickets.get(p_140819_)) != null) {
            tickets.remove(p_140820_);
        }
        return removed;
    }

    public <T> void m_140792_(TicketType<T> p_140793_, ChunkPos p_140794_, int p_140795_, T p_140796_) {
        this.m_140784_(p_140794_.m_45588_(), new Ticket<T>(p_140793_, p_140795_, p_140796_));
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> ticketType, ChunkPos chunkcoordintpair, int level, T identifier) {
        return this.addTicketCB(chunkcoordintpair.m_45588_(), new Ticket<T>(ticketType, level, identifier));
    }

    public <T> void m_140823_(TicketType<T> p_140824_, ChunkPos p_140825_, int p_140826_, T p_140827_) {
        Ticket<T> ticket = new Ticket<T>(p_140824_, p_140826_, p_140827_);
        this.m_140818_(p_140825_.m_45588_(), ticket);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> ticketType, ChunkPos chunkcoordintpair, int level, T identifier) {
        Ticket<T> ticket = new Ticket<T>(ticketType, level, identifier);
        return this.removeTicketCB(chunkcoordintpair.m_45588_(), ticket);
    }

    public <T> void m_140840_(TicketType<T> p_140841_, ChunkPos p_140842_, int p_140843_, T p_140844_) {
        this.addRegionTicket(p_140841_, p_140842_, p_140843_, p_140844_, false);
    }

    public <T> void addRegionTicket(TicketType<T> p_140841_, ChunkPos p_140842_, int p_140843_, T p_140844_, boolean forceTicks) {
        Ticket<T> ticket = new Ticket<T>(p_140841_, 33 - p_140843_, p_140844_, forceTicks);
        long i = p_140842_.m_45588_();
        this.m_140784_(i, ticket);
        this.f_183901_.m_184151_(i, ticket);
    }

    public <T> void m_140849_(TicketType<T> p_140850_, ChunkPos p_140851_, int p_140852_, T p_140853_) {
        this.removeRegionTicket(p_140850_, p_140851_, p_140852_, p_140853_, false);
    }

    public <T> void removeRegionTicket(TicketType<T> p_140850_, ChunkPos p_140851_, int p_140852_, T p_140853_, boolean forceTicks) {
        Ticket<T> ticket = new Ticket<T>(p_140850_, 33 - p_140852_, p_140853_, forceTicks);
        long i = p_140851_.m_45588_();
        this.m_140818_(i, ticket);
        this.f_183901_.m_184165_(i, ticket);
    }

    private SortedArraySet<Ticket<?>> m_140857_(long p_140858_) {
        return (SortedArraySet)this.f_140761_.computeIfAbsent(p_140858_, p_183923_ -> SortedArraySet.m_14246_((int)4));
    }

    protected void m_140799_(ChunkPos p_140800_, boolean p_140801_) {
        Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.f_9445_, 31, p_140800_);
        long i = p_140800_.m_45588_();
        if (p_140801_) {
            this.m_140784_(i, ticket);
            this.f_183901_.m_184151_(i, ticket);
        } else {
            this.m_140818_(i, ticket);
            this.f_183901_.m_184165_(i, ticket);
        }
    }

    public void m_140802_(SectionPos p_140803_, ServerPlayer p_140804_) {
        ChunkPos chunkpos = p_140803_.m_123251_();
        long i = chunkpos.m_45588_();
        ((ObjectSet)this.f_140760_.computeIfAbsent(i, p_183921_ -> new ObjectOpenHashSet())).add((Object)p_140804_);
        this.f_140763_.m_140715_(i, 0, true);
        this.f_140764_.m_140715_(i, 0, true);
        this.f_183901_.m_184154_(TicketType.f_9444_, chunkpos, this.m_183918_(), (Object)chunkpos);
    }

    public void m_140828_(SectionPos p_140829_, ServerPlayer p_140830_) {
        ChunkPos chunkpos = p_140829_.m_123251_();
        long i = chunkpos.m_45588_();
        ObjectSet objectset = (ObjectSet)this.f_140760_.get(i);
        objectset.remove((Object)p_140830_);
        if (objectset.isEmpty()) {
            this.f_140760_.remove(i);
            this.f_140763_.m_140715_(i, Integer.MAX_VALUE, false);
            this.f_140764_.m_140715_(i, Integer.MAX_VALUE, false);
            this.f_183901_.m_184168_(TicketType.f_9444_, chunkpos, this.m_183918_(), (Object)chunkpos);
        }
    }

    private int m_183918_() {
        return Math.max(0, 31 - this.f_183902_);
    }

    public boolean m_183913_(long p_183914_) {
        return this.f_183901_.m_6172_(p_183914_) < 32;
    }

    public boolean m_183916_(long p_183917_) {
        return this.f_183901_.m_6172_(p_183917_) < 33;
    }

    protected String m_140838_(long p_140839_) {
        SortedArraySet sortedarrayset = (SortedArraySet)this.f_140761_.get(p_140839_);
        return sortedarrayset != null && !sortedarrayset.isEmpty() ? ((Ticket)sortedarrayset.m_14262_()).toString() : "no_ticket";
    }

    protected void m_140777_(int p_140778_) {
        this.f_140764_.m_140912_(p_140778_);
    }

    public void m_183911_(int p_183912_) {
        if (p_183912_ != this.f_183902_) {
            this.f_183902_ = p_183912_;
            this.f_183901_.m_184146_(this.m_183918_());
        }
    }

    public int m_140816_() {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.size();
    }

    public boolean m_140847_(long p_140848_) {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.containsKey(p_140848_);
    }

    public String m_140837_() {
        return this.f_140766_.m_140558_();
    }

    public boolean shouldForceTicks(long chunkPos) {
        SortedArraySet tickets = (SortedArraySet)this.forcedTickets.get(chunkPos);
        return tickets != null && !tickets.isEmpty();
    }

    private void m_143207_(String p_143208_) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(p_143208_));){
            for (Long2ObjectMap.Entry entry : this.f_140761_.long2ObjectEntrySet()) {
                ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    fileoutputstream.write((chunkpos.f_45578_ + "\t" + chunkpos.f_45579_ + "\t" + ticket.m_9428_() + "\t" + ticket.m_9433_() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            f_140758_.error("Failed to dump tickets to {}", (Object)p_143208_, (Object)ioexception);
        }
    }

    @VisibleForTesting
    TickingTracker m_183915_() {
        return this.f_183901_;
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        Ticket<T> target = new Ticket<T>(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            SortedArraySet tickets = (SortedArraySet)entry.getValue();
            if (!tickets.remove(target)) continue;
            this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_(tickets), false);
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void m_201910_() {
        ImmutableSet immutableset = ImmutableSet.of(TicketType.f_9449_, TicketType.f_9448_, TicketType.f_9446_);
        ObjectIterator objectiterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((SortedArraySet)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (immutableset.contains(ticket.m_9428_())) continue;
                iterator.remove();
                flag = true;
                this.f_183901_.m_184165_(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_((SortedArraySet)entry.getValue()), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    public boolean m_201911_() {
        return !this.f_140761_.isEmpty();
    }

    class ChunkTicketTracker
    extends ChunkTracker {
        public ChunkTicketTracker() {
            super(ChunkMap.f_140127_ + 2, 16, 256);
        }

        protected int m_7031_(long p_140883_) {
            SortedArraySet sortedarrayset = (SortedArraySet)DistanceManager.this.f_140761_.get(p_140883_);
            if (sortedarrayset == null) {
                return Integer.MAX_VALUE;
            }
            return sortedarrayset.isEmpty() ? Integer.MAX_VALUE : ((Ticket)sortedarrayset.m_14262_()).m_9433_();
        }

        protected int m_6172_(long p_140885_) {
            ChunkHolder chunkholder;
            if (!DistanceManager.this.m_7009_(p_140885_) && (chunkholder = DistanceManager.this.m_7316_(p_140885_)) != null) {
                return chunkholder.m_140093_();
            }
            return ChunkMap.f_140127_ + 1;
        }

        protected void m_7351_(long p_140880_, int p_140881_) {
            int i;
            ChunkHolder chunkholder = DistanceManager.this.m_7316_(p_140880_);
            int n = i = chunkholder == null ? ChunkMap.f_140127_ + 1 : chunkholder.m_140093_();
            if (i != p_140881_ && (chunkholder = DistanceManager.this.m_7288_(p_140880_, p_140881_, chunkholder, i)) != null) {
                DistanceManager.this.f_140765_.add(chunkholder);
            }
        }

        public int m_140877_(int p_140878_) {
            return this.m_75588_(p_140878_);
        }
    }

    class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap f_140886_;
        protected final int f_140887_;

        protected FixedPlayerDistanceChunkTracker(int p_140891_) {
            super(p_140891_ + 2, 16, 256);
            this.f_140886_ = new Long2ByteOpenHashMap();
            this.f_140887_ = p_140891_;
            this.f_140886_.defaultReturnValue((byte)(p_140891_ + 2));
        }

        protected int m_6172_(long p_140901_) {
            return this.f_140886_.get(p_140901_);
        }

        protected void m_7351_(long p_140893_, int p_140894_) {
            byte b0 = p_140894_ > this.f_140887_ ? this.f_140886_.remove(p_140893_) : this.f_140886_.put(p_140893_, (byte)p_140894_);
            this.m_8002_(p_140893_, b0, p_140894_);
        }

        protected void m_8002_(long p_140895_, int p_140896_, int p_140897_) {
        }

        protected int m_7031_(long p_140899_) {
            return this.m_140902_(p_140899_) ? 0 : Integer.MAX_VALUE;
        }

        private boolean m_140902_(long p_140903_) {
            ObjectSet objectset = (ObjectSet)DistanceManager.this.f_140760_.get(p_140903_);
            return objectset != null && !objectset.isEmpty();
        }

        public void m_6410_() {
            this.m_75588_(Integer.MAX_VALUE);
        }

        private void m_143212_(String p_143213_) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(p_143213_));){
                for (Long2ByteMap.Entry entry : this.f_140886_.long2ByteEntrySet()) {
                    ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
                    String s = Byte.toString(entry.getByteValue());
                    fileoutputstream.write((chunkpos.f_45578_ + "\t" + chunkpos.f_45579_ + "\t" + s + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                f_140758_.error("Failed to dump chunks to {}", (Object)p_143213_, (Object)ioexception);
            }
        }
    }

    class PlayerTicketTracker
    extends FixedPlayerDistanceChunkTracker {
        private int f_140905_;
        private final Long2IntMap f_140906_;
        private final LongSet f_140907_;

        protected PlayerTicketTracker(int p_140910_) {
            super(p_140910_);
            this.f_140906_ = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.f_140907_ = new LongOpenHashSet();
            this.f_140905_ = 0;
            this.f_140906_.defaultReturnValue(p_140910_ + 2);
        }

        @Override
        protected void m_8002_(long p_140915_, int p_140916_, int p_140917_) {
            this.f_140907_.add(p_140915_);
        }

        public void m_140912_(int p_140913_) {
            for (Long2ByteMap.Entry entry : this.f_140886_.long2ByteEntrySet()) {
                byte b0 = entry.getByteValue();
                long i = entry.getLongKey();
                this.m_140918_(i, b0, this.m_140932_(b0), b0 <= p_140913_ - 2);
            }
            this.f_140905_ = p_140913_;
        }

        private void m_140918_(long p_140919_, int p_140920_, boolean p_140921_, boolean p_140922_) {
            if (p_140921_ != p_140922_) {
                Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.f_9444_, f_140759_, new ChunkPos(p_140919_));
                if (p_140922_) {
                    DistanceManager.this.f_140767_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140624_(() -> DistanceManager.this.f_140770_.execute(() -> {
                        if (this.m_140932_(this.m_6172_(p_140919_))) {
                            DistanceManager.this.m_140784_(p_140919_, ticket);
                            DistanceManager.this.f_140769_.add(p_140919_);
                        } else {
                            DistanceManager.this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, (long)p_140919_, (boolean)false));
                        }
                    }), (long)p_140919_, () -> p_140920_));
                } else {
                    DistanceManager.this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> DistanceManager.this.f_140770_.execute(() -> DistanceManager.this.m_140818_(p_140919_, ticket)), (long)p_140919_, (boolean)true));
                }
            }
        }

        @Override
        public void m_6410_() {
            super.m_6410_();
            if (!this.f_140907_.isEmpty()) {
                LongIterator longiterator = this.f_140907_.iterator();
                while (longiterator.hasNext()) {
                    int k;
                    long i = longiterator.nextLong();
                    int j = this.f_140906_.get(i);
                    if (j == (k = this.m_6172_(i))) continue;
                    DistanceManager.this.f_140766_.m_6250_(new ChunkPos(i), () -> this.f_140906_.get(i), k, p_140928_ -> {
                        if (p_140928_ >= this.f_140906_.defaultReturnValue()) {
                            this.f_140906_.remove(i);
                        } else {
                            this.f_140906_.put(i, p_140928_);
                        }
                    });
                    this.m_140918_(i, k, this.m_140932_(j), this.m_140932_(k));
                }
                this.f_140907_.clear();
            }
        }

        private boolean m_140932_(int p_140933_) {
            return p_140933_ <= this.f_140905_ - 2;
        }
    }
}

