/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class DiodeBlock
extends HorizontalDirectionalBlock {
    protected static final VoxelShape f_52495_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final BooleanProperty f_52496_ = BlockStateProperties.f_61448_;

    protected DiodeBlock(BlockBehaviour.Properties p_52499_) {
        super(p_52499_);
    }

    public VoxelShape m_5940_(BlockState p_52556_, BlockGetter p_52557_, BlockPos p_52558_, CollisionContext p_52559_) {
        return f_52495_;
    }

    public boolean m_7898_(BlockState p_52538_, LevelReader p_52539_, BlockPos p_52540_) {
        return DiodeBlock.m_49936_((BlockGetter)p_52539_, (BlockPos)p_52540_.m_7495_());
    }

    public void m_213897_(BlockState p_221065_, ServerLevel p_221066_, BlockPos p_221067_, RandomSource p_221068_) {
        if (!this.m_7346_(p_221066_, p_221067_, p_221065_)) {
            boolean flag = (Boolean)p_221065_.m_61143_((Property)f_52496_);
            boolean flag1 = this.m_7320_(p_221066_, p_221067_, p_221065_);
            if (flag && !flag1) {
                p_221066_.m_7731_(p_221067_, (BlockState)((Object)p_221065_.m_61124_((Property)f_52496_, Boolean.valueOf(false))), 2);
            } else if (!flag) {
                p_221066_.m_7731_(p_221067_, (BlockState)((Object)p_221065_.m_61124_((Property)f_52496_, Boolean.valueOf(true))), 2);
                if (!flag1) {
                    p_221066_.m_186464_(p_221067_, (Block)((Object)this), this.m_6112_(p_221065_), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    public int m_6376_(BlockState p_52561_, BlockGetter p_52562_, BlockPos p_52563_, Direction p_52564_) {
        return p_52561_.m_60746_(p_52562_, p_52563_, p_52564_);
    }

    public int m_6378_(BlockState p_52520_, BlockGetter p_52521_, BlockPos p_52522_, Direction p_52523_) {
        if (!((Boolean)p_52520_.m_61143_((Property)f_52496_)).booleanValue()) {
            return 0;
        }
        return p_52520_.m_61143_((Property)f_54117_) == p_52523_ ? this.m_5968_(p_52521_, p_52522_, p_52520_) : 0;
    }

    public void m_6861_(BlockState p_52525_, Level p_52526_, BlockPos p_52527_, Block p_52528_, BlockPos p_52529_, boolean p_52530_) {
        if (p_52525_.m_60710_(p_52526_, p_52527_)) {
            this.m_7321_(p_52526_, p_52527_, p_52525_);
        } else {
            BlockEntity blockentity = p_52525_.m_155947_() ? p_52526_.m_7702_(p_52527_) : null;
            DiodeBlock.m_49892_((BlockState)p_52525_, (LevelAccessor)p_52526_, (BlockPos)p_52527_, (BlockEntity)blockentity);
            p_52526_.m_7471_(p_52527_, false);
            for (Direction direction : Direction.values()) {
                p_52526_.m_46672_(p_52527_.m_121945_(direction), (Block)((Object)this));
            }
        }
    }

    protected void m_7321_(Level p_52577_, BlockPos p_52578_, BlockState p_52579_) {
        boolean flag1;
        boolean flag;
        if (!this.m_7346_(p_52577_, p_52578_, p_52579_) && (flag = ((Boolean)p_52579_.m_61143_((Property)f_52496_)).booleanValue()) != (flag1 = this.m_7320_(p_52577_, p_52578_, p_52579_)) && !p_52577_.m_183326_().m_183588_(p_52578_, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.m_52573_(p_52577_, p_52578_, p_52579_)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            p_52577_.m_186464_(p_52578_, (Block)((Object)this), this.m_6112_(p_52579_), tickpriority);
        }
    }

    public boolean m_7346_(LevelReader p_52511_, BlockPos p_52512_, BlockState p_52513_) {
        return false;
    }

    protected boolean m_7320_(Level p_52502_, BlockPos p_52503_, BlockState p_52504_) {
        return this.m_7312_(p_52502_, p_52503_, p_52504_) > 0;
    }

    protected int m_7312_(Level p_52544_, BlockPos p_52545_, BlockState p_52546_) {
        Direction direction = (Direction)p_52546_.m_61143_((Property)f_54117_);
        BlockPos blockpos = p_52545_.m_121945_(direction);
        int i = p_52544_.m_46681_(blockpos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockstate = p_52544_.m_8055_(blockpos);
        return Math.max(i, blockstate.m_60713_(Blocks.f_50088_) ? (Integer)blockstate.m_61143_(RedStoneWireBlock.f_55500_) : 0);
    }

    protected int m_52547_(LevelReader p_52548_, BlockPos p_52549_, BlockState p_52550_) {
        Direction direction = (Direction)p_52550_.m_61143_((Property)f_54117_);
        Direction direction1 = direction.m_122427_();
        Direction direction2 = direction.m_122428_();
        return Math.max(this.m_52551_(p_52548_, p_52549_.m_121945_(direction1), direction1), this.m_52551_(p_52548_, p_52549_.m_121945_(direction2), direction2));
    }

    protected int m_52551_(LevelReader p_52552_, BlockPos p_52553_, Direction p_52554_) {
        BlockState blockstate = p_52552_.m_8055_(p_52553_);
        if (this.m_6137_(blockstate)) {
            if (blockstate.m_60713_(Blocks.f_50330_)) {
                return 15;
            }
            return blockstate.m_60713_(Blocks.f_50088_) ? ((Integer)blockstate.m_61143_(RedStoneWireBlock.f_55500_)).intValue() : p_52552_.m_46852_(p_52553_, p_52554_);
        }
        return 0;
    }

    public boolean m_7899_(BlockState p_52572_) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext p_52501_) {
        return (BlockState)((Object)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)p_52501_.m_8125_().m_122424_()));
    }

    public void m_6402_(Level p_52506_, BlockPos p_52507_, BlockState p_52508_, LivingEntity p_52509_, ItemStack p_52510_) {
        if (this.m_7320_(p_52506_, p_52507_, p_52508_)) {
            p_52506_.m_186460_(p_52507_, (Block)((Object)this), 1);
        }
    }

    public void m_6807_(BlockState p_52566_, Level p_52567_, BlockPos p_52568_, BlockState p_52569_, boolean p_52570_) {
        this.m_52580_(p_52567_, p_52568_, p_52566_);
    }

    public void m_6810_(BlockState p_52532_, Level p_52533_, BlockPos p_52534_, BlockState p_52535_, boolean p_52536_) {
        if (!p_52536_ && !p_52532_.m_60713_(p_52535_.m_60734_())) {
            super.m_6810_(p_52532_, p_52533_, p_52534_, p_52535_, p_52536_);
            this.m_52580_(p_52533_, p_52534_, p_52532_);
        }
    }

    protected void m_52580_(Level p_52581_, BlockPos p_52582_, BlockState p_52583_) {
        Direction direction = (Direction)p_52583_.m_61143_((Property)f_54117_);
        BlockPos blockpos = p_52582_.m_121945_(direction.m_122424_());
        if (ForgeEventFactory.onNeighborNotify((Level)p_52581_, (BlockPos)p_52582_, (BlockState)p_52581_.m_8055_(p_52582_), EnumSet.of(direction.m_122424_()), (boolean)false).isCanceled()) {
            return;
        }
        p_52581_.m_46586_(blockpos, (Block)((Object)this), p_52582_);
        p_52581_.m_46590_(blockpos, (Block)((Object)this), direction);
    }

    protected boolean m_6137_(BlockState p_52585_) {
        return p_52585_.m_60803_();
    }

    protected int m_5968_(BlockGetter p_52541_, BlockPos p_52542_, BlockState p_52543_) {
        return 15;
    }

    public static boolean m_52586_(BlockState p_52587_) {
        return p_52587_.m_60734_() instanceof DiodeBlock;
    }

    public boolean m_52573_(BlockGetter p_52574_, BlockPos p_52575_, BlockState p_52576_) {
        Direction direction = ((Direction)p_52576_.m_61143_((Property)f_54117_)).m_122424_();
        BlockState blockstate = p_52574_.m_8055_(p_52575_.m_121945_(direction));
        return DiodeBlock.m_52586_(blockstate) && blockstate.m_61143_((Property)f_54117_) != direction;
    }

    protected abstract int m_6112_(BlockState var1);
}

