/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final BooleanProperty f_60153_ = BlockStateProperties.f_61432_;
    public static final int f_155888_ = 0;
    public static final int f_155889_ = 1;
    public static final int f_155890_ = 2;
    public static final float f_155891_ = 4.0f;
    protected static final VoxelShape f_60154_ = Block.m_49796_(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape f_60155_ = Block.m_49796_(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape f_60156_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape f_60157_ = Block.m_49796_(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape f_60158_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape f_60159_ = Block.m_49796_(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean f_60160_;

    public PistonBaseBlock(boolean p_60163_, BlockBehaviour.Properties p_60164_) {
        super(p_60164_);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH))).m_61124_((Property)f_60153_, Boolean.valueOf(false))));
        this.f_60160_ = p_60163_;
    }

    public VoxelShape m_5940_(BlockState p_60220_, BlockGetter p_60221_, BlockPos p_60222_, CollisionContext p_60223_) {
        if (((Boolean)p_60220_.m_61143_((Property)f_60153_)).booleanValue()) {
            switch ((Direction)p_60220_.m_61143_((Property)f_52588_)) {
                case DOWN: {
                    return f_60159_;
                }
                default: {
                    return f_60158_;
                }
                case NORTH: {
                    return f_60157_;
                }
                case SOUTH: {
                    return f_60156_;
                }
                case WEST: {
                    return f_60155_;
                }
                case EAST: 
            }
            return f_60154_;
        }
        return Shapes.m_83144_();
    }

    public void m_6402_(Level p_60172_, BlockPos p_60173_, BlockState p_60174_, LivingEntity p_60175_, ItemStack p_60176_) {
        if (!p_60172_.f_46443_) {
            this.m_60167_(p_60172_, p_60173_, p_60174_);
        }
    }

    public void m_6861_(BlockState p_60198_, Level p_60199_, BlockPos p_60200_, Block p_60201_, BlockPos p_60202_, boolean p_60203_) {
        if (!p_60199_.f_46443_) {
            this.m_60167_(p_60199_, p_60200_, p_60198_);
        }
    }

    public void m_6807_(BlockState p_60225_, Level p_60226_, BlockPos p_60227_, BlockState p_60228_, boolean p_60229_) {
        if (!p_60228_.m_60713_(p_60225_.m_60734_()) && !p_60226_.f_46443_ && p_60226_.m_7702_(p_60227_) == null) {
            this.m_60167_(p_60226_, p_60227_, p_60225_);
        }
    }

    public BlockState m_5573_(BlockPlaceContext p_60166_) {
        return (BlockState)((Object)((BlockState)((Object)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)p_60166_.m_7820_().m_122424_()))).m_61124_((Property)f_60153_, Boolean.valueOf(false)));
    }

    private void m_60167_(Level p_60168_, BlockPos p_60169_, BlockState p_60170_) {
        Direction direction = (Direction)p_60170_.m_61143_((Property)f_52588_);
        boolean flag = this.m_60177_(p_60168_, p_60169_, direction);
        if (flag && !((Boolean)p_60170_.m_61143_((Property)f_60153_)).booleanValue()) {
            if (new PistonStructureResolver(p_60168_, p_60169_, direction, true).m_60422_()) {
                p_60168_.m_7696_(p_60169_, (Block)((Object)this), 0, direction.m_122411_());
            }
        } else if (!flag && ((Boolean)p_60170_.m_61143_((Property)f_60153_)).booleanValue()) {
            PistonMovingBlockEntity pistonmovingblockentity;
            BlockEntity blockentity;
            BlockPos blockpos = p_60169_.m_5484_(direction, 2);
            BlockState blockstate = p_60168_.m_8055_(blockpos);
            int i = 1;
            if (blockstate.m_60713_(Blocks.f_50110_) && blockstate.m_61143_((Property)f_52588_) == direction && (blockentity = p_60168_.m_7702_(blockpos)) instanceof PistonMovingBlockEntity && (pistonmovingblockentity = (PistonMovingBlockEntity)blockentity).m_60387_() && (pistonmovingblockentity.m_60350_(0.0f) < 0.5f || p_60168_.m_46467_() == pistonmovingblockentity.m_60402_() || ((ServerLevel)p_60168_).m_8874_())) {
                i = 2;
            }
            p_60168_.m_7696_(p_60169_, (Block)((Object)this), i, direction.m_122411_());
        }
    }

    private boolean m_60177_(Level p_60178_, BlockPos p_60179_, Direction p_60180_) {
        for (Direction direction : Direction.values()) {
            if (direction == p_60180_ || !p_60178_.m_46616_(p_60179_.m_121945_(direction), direction)) continue;
            return true;
        }
        if (p_60178_.m_46616_(p_60179_, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = p_60179_.m_7494_();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !p_60178_.m_46616_(blockpos.m_121945_(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public boolean m_8133_(BlockState p_60192_, Level p_60193_, BlockPos p_60194_, int p_60195_, int p_60196_) {
        Direction direction = (Direction)p_60192_.m_61143_((Property)f_52588_);
        if (!p_60193_.f_46443_) {
            boolean flag = this.m_60177_(p_60193_, p_60194_, direction);
            if (flag && (p_60195_ == 1 || p_60195_ == 2)) {
                p_60193_.m_7731_(p_60194_, (BlockState)((Object)p_60192_.m_61124_((Property)f_60153_, Boolean.valueOf(true))), 2);
                return false;
            }
            if (!flag && p_60195_ == 0) {
                return false;
            }
        }
        if (p_60195_ == 0) {
            if (ForgeEventFactory.onPistonMovePre((Level)p_60193_, (BlockPos)p_60194_, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.m_60181_(p_60193_, p_60194_, direction, true)) {
                return false;
            }
            p_60193_.m_7731_(p_60194_, (BlockState)((Object)p_60192_.m_61124_((Property)f_60153_, Boolean.valueOf(true))), 67);
            p_60193_.m_5594_(null, p_60194_, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.5f, p_60193_.f_46441_.m_188501_() * 0.25f + 0.6f);
            p_60193_.m_142346_(null, GameEvent.f_157775_, p_60194_);
        } else if (p_60195_ == 1 || p_60195_ == 2) {
            if (ForgeEventFactory.onPistonMovePre((Level)p_60193_, (BlockPos)p_60194_, (Direction)direction, (boolean)false)) {
                return false;
            }
            BlockEntity blockentity1 = p_60193_.m_7702_(p_60194_.m_121945_(direction));
            if (blockentity1 instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)blockentity1).m_60401_();
            }
            BlockState blockstate = (BlockState)((Object)((BlockState)((Object)Blocks.f_50110_.m_49966_().m_61124_((Property)MovingPistonBlock.f_60046_, (Comparable)direction))).m_61124_((Property)MovingPistonBlock.f_60047_, (Comparable)(this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT)));
            p_60193_.m_7731_(p_60194_, blockstate, 20);
            p_60193_.m_151523_(MovingPistonBlock.m_155881_((BlockPos)p_60194_, (BlockState)blockstate, (BlockState)((BlockState)((Object)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.m_122376_((int)(p_60196_ & 7))))), (Direction)direction, (boolean)false, (boolean)true));
            p_60193_.m_6289_(p_60194_, blockstate.m_60734_());
            blockstate.m_60701_(p_60193_, p_60194_, 2);
            if (this.f_60160_) {
                PistonMovingBlockEntity pistonmovingblockentity;
                BlockEntity blockentity;
                BlockPos blockpos = p_60194_.m_7918_(direction.m_122429_() * 2, direction.m_122430_() * 2, direction.m_122431_() * 2);
                BlockState blockstate1 = p_60193_.m_8055_(blockpos);
                boolean flag1 = false;
                if (blockstate1.m_60713_(Blocks.f_50110_) && (blockentity = p_60193_.m_7702_(blockpos)) instanceof PistonMovingBlockEntity && (pistonmovingblockentity = (PistonMovingBlockEntity)blockentity).m_60392_() == direction && pistonmovingblockentity.m_60387_()) {
                    pistonmovingblockentity.m_60401_();
                    flag1 = true;
                }
                if (!flag1) {
                    if (p_60195_ != 1 || blockstate1.m_60795_() || !PistonBaseBlock.m_60204_(blockstate1, p_60193_, blockpos, direction.m_122424_(), false, direction) || blockstate1.m_60811_() != PushReaction.NORMAL && !blockstate1.m_60713_(Blocks.f_50039_) && !blockstate1.m_60713_(Blocks.f_50032_)) {
                        p_60193_.m_7471_(p_60194_.m_121945_(direction), false);
                    } else {
                        this.m_60181_(p_60193_, p_60194_, direction, false);
                    }
                }
            } else {
                p_60193_.m_7471_(p_60194_.m_121945_(direction), false);
            }
            p_60193_.m_5594_(null, p_60194_, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.5f, p_60193_.f_46441_.m_188501_() * 0.15f + 0.6f);
            p_60193_.m_142346_(null, GameEvent.f_157774_, p_60194_);
        }
        ForgeEventFactory.onPistonMovePost((Level)p_60193_, (BlockPos)p_60194_, (Direction)direction, (p_60195_ == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean m_60204_(BlockState p_60205_, Level p_60206_, BlockPos p_60207_, Direction p_60208_, boolean p_60209_, Direction p_60210_) {
        if (p_60207_.m_123342_() >= p_60206_.m_141937_() && p_60207_.m_123342_() <= p_60206_.m_151558_() - 1 && p_60206_.m_6857_().m_61937_(p_60207_)) {
            if (p_60205_.m_60795_()) {
                return true;
            }
            if (!(p_60205_.m_60713_(Blocks.f_50080_) || p_60205_.m_60713_(Blocks.f_50723_) || p_60205_.m_60713_(Blocks.f_50724_) || p_60205_.m_60713_(Blocks.f_220863_))) {
                if (p_60208_ == Direction.DOWN && p_60207_.m_123342_() == p_60206_.m_141937_()) {
                    return false;
                }
                if (p_60208_ == Direction.UP && p_60207_.m_123342_() == p_60206_.m_151558_() - 1) {
                    return false;
                }
                if (!p_60205_.m_60713_(Blocks.f_50039_) && !p_60205_.m_60713_(Blocks.f_50032_)) {
                    if (p_60205_.m_60800_(p_60206_, p_60207_) == -1.0f) {
                        return false;
                    }
                    switch (p_60205_.m_60811_()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return p_60209_;
                        }
                        case PUSH_ONLY: {
                            return p_60208_ == p_60210_;
                        }
                    }
                } else if (((Boolean)p_60205_.m_61143_((Property)f_60153_)).booleanValue()) {
                    return false;
                }
                return !p_60205_.m_155947_();
            }
            return false;
        }
        return false;
    }

    private boolean m_60181_(Level p_60182_, BlockPos p_60183_, Direction p_60184_, boolean p_60185_) {
        PistonStructureResolver pistonstructureresolver;
        BlockPos blockpos = p_60183_.m_121945_(p_60184_);
        if (!p_60185_ && p_60182_.m_8055_(blockpos).m_60713_(Blocks.f_50040_)) {
            p_60182_.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 20);
        }
        if (!(pistonstructureresolver = new PistonStructureResolver(p_60182_, p_60183_, p_60184_, p_60185_)).m_60422_()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonstructureresolver.m_60436_();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = list.get(i);
            BlockState blockstate = p_60182_.m_8055_(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List<BlockPos> list2 = pistonstructureresolver.m_60437_();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = p_60185_ ? p_60184_ : p_60184_.m_122424_();
        int j = 0;
        for (int k = list2.size() - 1; k >= 0; --k) {
            BlockPos blockpos2 = list2.get(k);
            BlockState blockState = p_60182_.m_8055_(blockpos2);
            BlockEntity blockentity = blockState.m_155947_() ? p_60182_.m_7702_(blockpos2) : null;
            PistonBaseBlock.m_49892_((BlockState)blockState, (LevelAccessor)p_60182_, (BlockPos)blockpos2, (BlockEntity)blockentity);
            p_60182_.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 18);
            p_60182_.m_220407_(GameEvent.f_157794_, blockpos2, GameEvent.Context.m_223722_((BlockState)blockState));
            if (!blockState.m_204336_(BlockTags.f_13076_)) {
                p_60182_.m_142052_(blockpos2, blockState);
            }
            ablockstate[j++] = blockState;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            BlockState blockState = p_60182_.m_8055_(blockpos3);
            blockpos3 = blockpos3.m_121945_(direction);
            map.remove(blockpos3);
            BlockState blockstate8 = (BlockState)((Object)Blocks.f_50110_.m_49966_().m_61124_((Property)f_52588_, (Comparable)p_60184_));
            p_60182_.m_7731_(blockpos3, blockstate8, 68);
            p_60182_.m_151523_(MovingPistonBlock.m_155881_((BlockPos)blockpos3, (BlockState)blockstate8, (BlockState)((BlockState)((Object)list1.get(l))), (Direction)p_60184_, (boolean)p_60185_, (boolean)false));
            ablockstate[j++] = blockState;
        }
        if (p_60185_) {
            PistonType pistontype = this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockstate4 = (BlockState)((Object)((BlockState)((Object)Blocks.f_50040_.m_49966_().m_61124_((Property)PistonHeadBlock.f_52588_, (Comparable)p_60184_))).m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)pistontype));
            BlockState blockState = (BlockState)((Object)((BlockState)((Object)Blocks.f_50110_.m_49966_().m_61124_((Property)MovingPistonBlock.f_60046_, (Comparable)p_60184_))).m_61124_((Property)MovingPistonBlock.f_60047_, (Comparable)(this.f_60160_ ? PistonType.STICKY : PistonType.DEFAULT)));
            map.remove(blockpos);
            p_60182_.m_7731_(blockpos, blockState, 68);
            p_60182_.m_151523_(MovingPistonBlock.m_155881_((BlockPos)blockpos, (BlockState)blockState, (BlockState)blockstate4, (Direction)p_60184_, (boolean)true, (boolean)true));
        }
        BlockState blockstate3 = Blocks.f_50016_.m_49966_();
        for (BlockPos blockPos : map.keySet()) {
            p_60182_.m_7731_(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)((Object)entry.getValue());
            blockstate2.m_60758_(p_60182_, blockpos5, 2);
            blockstate3.m_60701_(p_60182_, blockpos5, 2);
            blockstate3.m_60758_(p_60182_, blockpos5, 2);
        }
        j = 0;
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = ablockstate[j++];
            BlockPos blockpos6 = list2.get(i1);
            blockState.m_60758_(p_60182_, blockpos6, 2);
            p_60182_.m_46672_(blockpos6, blockState.m_60734_());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            p_60182_.m_46672_(list.get(j1), ablockstate[j++].m_60734_());
        }
        if (p_60185_) {
            p_60182_.m_46672_(blockpos, Blocks.f_50040_);
        }
        return true;
    }

    public BlockState m_6843_(BlockState p_60215_, Rotation p_60216_) {
        return (BlockState)((Object)p_60215_.m_61124_((Property)f_52588_, (Comparable)p_60216_.m_55954_((Direction)p_60215_.m_61143_((Property)f_52588_))));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (Boolean)state.m_61143_((Property)f_60153_) != false ? state : super.rotate(state, world, pos, direction);
    }

    public BlockState m_6943_(BlockState p_60212_, Mirror p_60213_) {
        return p_60212_.m_60717_(p_60213_.m_54846_((Direction)p_60212_.m_61143_((Property)f_52588_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_60218_) {
        p_60218_.m_61104_(new Property[]{f_52588_, f_60153_});
    }

    public boolean m_7923_(BlockState p_60231_) {
        return (Boolean)p_60231_.m_61143_((Property)f_60153_);
    }

    public boolean m_7357_(BlockState p_60187_, BlockGetter p_60188_, BlockPos p_60189_, PathComputationType p_60190_) {
        return false;
    }
}

