/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_19_R2.util.RandomSourceWrapper;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> f_62136_ = BuiltInRegistries.f_256914_.m_194605_().dispatchStable(ChunkGenerator::m_6909_, Function.identity());
    protected final BiomeSource f_62137_;
    private final Supplier<List<FeatureSorter.StepFeatureData>> f_223020_;
    public final Function<Holder<Biome>, BiomeGenerationSettings> f_223021_;

    public ChunkGenerator(BiomeSource p_256133_) {
        this(p_256133_, p_223234_ -> ((Biome)p_223234_.m_203334_()).m_47536_());
    }

    public ChunkGenerator(BiomeSource p_255838_, Function<Holder<Biome>, BiomeGenerationSettings> p_256216_) {
        this.f_62137_ = p_255838_;
        this.f_223021_ = p_256216_;
        this.f_223020_ = Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(p_255838_.m_207840_()), p_223216_ -> ((BiomeGenerationSettings)p_256216_.apply((Holder<Biome>)p_223216_)).m_47818_(), (boolean)true));
    }

    protected abstract Codec<? extends ChunkGenerator> m_6909_();

    public ChunkGeneratorStructureState m_255169_(HolderLookup<StructureSet> p_256405_, RandomState p_256101_, long p_256018_) {
        return ChunkGeneratorStructureState.m_255081_((RandomState)p_256101_, (long)p_256018_, (BiomeSource)this.f_62137_, p_256405_);
    }

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> m_187743_() {
        return BuiltInRegistries.f_256914_.m_7854_(this.m_6909_());
    }

    public CompletableFuture<ChunkAccess> m_213908_(Executor p_223159_, RandomState p_223160_, Blender p_223161_, StructureManager p_223162_, ChunkAccess p_223163_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            p_223163_.m_183442_(this.f_62137_, p_223160_.m_224579_());
            return p_223163_;
        }), Util.m_183991_());
    }

    public abstract void m_213679_(WorldGenRegion var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, ChunkAccess var7, GenerationStep.Carving var8);

    @Nullable
    public Pair<BlockPos, Holder<Structure>> m_223037_(ServerLevel p_223038_, HolderSet<Structure> p_223039_, BlockPos p_223040_, int p_223041_, boolean p_223042_) {
        ChunkGeneratorStructureState chunkgeneratorstructurestate = p_223038_.m_7726_().m_255415_();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : p_223039_) {
            for (StructurePlacement structureplacement : chunkgeneratorstructurestate.m_255260_(holder)) {
                map.computeIfAbsent(structureplacement, p_223127_ -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<Structure>> pair2 = null;
        double d = Double.MAX_VALUE;
        StructureManager structuremanager = p_223038_.m_215010_();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement1 = (StructurePlacement)entry.getKey();
            if (structureplacement1 instanceof ConcentricRingsStructurePlacement) {
                BlockPos blockPos;
                double d0;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement1;
                Pair<BlockPos, Holder<Structure>> pair = this.m_223181_((Set)entry.getValue(), p_223038_, structuremanager, p_223040_, p_223042_, concentricringsstructureplacement);
                if (pair == null || !((d0 = p_223040_.m_123331_((Vec3i)(blockPos = (BlockPos)pair.getFirst()))) < d)) continue;
                d = d0;
                pair2 = pair;
                continue;
            }
            if (!(structureplacement1 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int i = SectionPos.m_123171_((int)p_223040_.m_123341_());
            int j = SectionPos.m_123171_((int)p_223040_.m_123343_());
            for (int k = 0; k <= p_223041_; ++k) {
                boolean flag = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPos, Holder<Structure>> pair1 = ChunkGenerator.m_223188_((Set)entry.getValue(), p_223038_, structuremanager, i, j, k, p_223042_, chunkgeneratorstructurestate.m_254887_(), randomspreadstructureplacement);
                    if (pair1 == null) continue;
                    flag = true;
                    double d1 = p_223040_.m_123331_((Vec3i)pair1.getFirst());
                    if (!(d1 < d)) continue;
                    d = d1;
                    pair2 = pair1;
                }
                if (!flag) continue;
                return pair2;
            }
        }
        return pair2;
    }

    @Nullable
    private Pair<BlockPos, Holder<Structure>> m_223181_(Set<Holder<Structure>> p_223182_, ServerLevel p_223183_, StructureManager p_223184_, BlockPos p_223185_, boolean p_223186_, ConcentricRingsStructurePlacement p_223187_) {
        List list = p_223183_.m_7726_().m_255415_().m_255182_(p_223187_);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPos, Holder<Structure>> pair = null;
        double d0 = Double.MAX_VALUE;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (ChunkPos chunkpos : list) {
            Pair<BlockPos, Holder<Structure>> pair1;
            blockpos$mutableblockpos.m_122178_(SectionPos.m_175554_((int)chunkpos.f_45578_, (int)8), 32, SectionPos.m_175554_((int)chunkpos.f_45579_, (int)8));
            double d1 = blockpos$mutableblockpos.m_123331_((Vec3i)p_223185_);
            boolean flag = pair == null || d1 < d0;
            if (!flag || (pair1 = ChunkGenerator.m_223198_(p_223182_, p_223183_, p_223184_, p_223186_, (StructurePlacement)p_223187_, chunkpos)) == null) continue;
            pair = pair1;
            d0 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPos, Holder<Structure>> m_223188_(Set<Holder<Structure>> p_223189_, LevelReader p_223190_, StructureManager p_223191_, int p_223192_, int p_223193_, int p_223194_, boolean p_223195_, long p_223196_, RandomSpreadStructurePlacement p_223197_) {
        int i = p_223197_.m_205003_();
        for (int j = -p_223194_; j <= p_223194_; ++j) {
            boolean flag = j == -p_223194_ || j == p_223194_;
            for (int k = -p_223194_; k <= p_223194_; ++k) {
                int i1;
                int l;
                ChunkPos chunkpos;
                Pair<BlockPos, Holder<Structure>> pair;
                boolean flag1;
                boolean bl = flag1 = k == -p_223194_ || k == p_223194_;
                if (!flag && !flag1 || (pair = ChunkGenerator.m_223198_(p_223189_, p_223190_, p_223191_, p_223195_, (StructurePlacement)p_223197_, chunkpos = p_223197_.m_227008_(p_223196_, l = p_223192_ + i * j, i1 = p_223193_ + i * k))) == null) continue;
                return pair;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPos, Holder<Structure>> m_223198_(Set<Holder<Structure>> p_223199_, LevelReader p_223200_, StructureManager p_223201_, boolean p_223202_, StructurePlacement p_223203_, ChunkPos p_223204_) {
        for (Holder<Structure> holder : p_223199_) {
            StructureCheckResult structurecheckresult = p_223201_.m_220473_(p_223204_, holder.m_203334_(), p_223202_);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!p_223202_ && structurecheckresult == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)p_223203_.m_227039_(p_223204_), holder);
            }
            ChunkAccess chunkaccess = p_223200_.m_46819_(p_223204_.f_45578_, p_223204_.f_45579_, ChunkStatus.f_62315_);
            StructureStart structurestart = p_223201_.m_220512_(SectionPos.m_175562_((ChunkAccess)chunkaccess), holder.m_203334_(), (StructureAccess)chunkaccess);
            if (structurestart == null || !structurestart.m_73603_() || p_223202_ && !ChunkGenerator.m_223059_(p_223201_, structurestart)) continue;
            return Pair.of((Object)p_223203_.m_227039_(structurestart.m_163625_()), holder);
        }
        return null;
    }

    private static boolean m_223059_(StructureManager p_223060_, StructureStart p_223061_) {
        if (p_223061_.m_73606_()) {
            p_223060_.m_220484_(p_223061_);
            return true;
        }
        return false;
    }

    public void m_213609_(WorldGenLevel p_223087_, ChunkAccess p_223088_, StructureManager p_223089_) {
        CraftWorld world;
        ChunkPos chunkpos = p_223088_.m_7697_();
        if (!SharedConstants.m_183707_(chunkpos)) {
            SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)p_223087_.m_151560_());
            BlockPos blockpos = sectionpos.m_123249_();
            Registry registry = p_223087_.m_8891_().m_175515_(Registries.f_256944_);
            Map<Integer, List<Structure>> map = registry.m_123024_().collect(Collectors.groupingBy(p_223103_ -> p_223103_.m_226619_().ordinal()));
            List<FeatureSorter.StepFeatureData> list = this.f_223020_.get();
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
            long i = worldgenrandom.m_64690_(p_223087_.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
            ObjectArraySet set = new ObjectArraySet();
            ChunkPos.m_45596_((ChunkPos)sectionpos.m_123251_(), (int)1).forEach(arg_0 -> ChunkGenerator.m_223090_(p_223087_, (Set)set, arg_0));
            set.retainAll(this.f_62137_.m_207840_());
            int j = list.size();
            try {
                Registry registry1 = p_223087_.m_8891_().m_175515_(Registries.f_256988_);
                int i1 = Math.max(GenerationStep.Decoration.values().length, j);
                for (int k = 0; k < i1; ++k) {
                    int l = 0;
                    if (p_223089_.m_220467_()) {
                        for (Structure structure : map.getOrDefault(k, Collections.emptyList())) {
                            worldgenrandom.m_190064_(i, l, k);
                            Supplier<String> supplier = () -> registry.m_7854_((Object)structure).map(Object::toString).orElseGet(structure::toString);
                            try {
                                p_223087_.m_143497_(supplier);
                                p_223089_.m_220504_(sectionpos, structure).forEach(p_223086_ -> p_223086_.m_226850_(p_223087_, p_223089_, this, (RandomSource)worldgenrandom, ChunkGenerator.m_187717_(p_223088_), chunkpos));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport1 = CrashReport.m_127521_(exception, "Feature placement");
                                crashreport1.m_127514_("Feature").m_128165_("Description", (CrashReportDetail<String>)((CrashReportDetail)supplier::get));
                                throw new ReportedException(crashreport1);
                            }
                            ++l;
                        }
                    }
                    if (k >= j) continue;
                    IntArraySet intset = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list1 = this.f_223021_.apply(holder).m_47818_();
                        if (k >= list1.size()) continue;
                        HolderSet<PlacedFeature> holderset = list1.get(k);
                        FeatureSorter.StepFeatureData featuresorter$stepfeaturedata1 = list.get(k);
                        holderset.m_203614_().map(Holder::m_203334_).forEach(arg_0 -> ChunkGenerator.m_223171_((IntSet)intset, featuresorter$stepfeaturedata1, arg_0));
                    }
                    int j1 = intset.size();
                    int[] aint = intset.toIntArray();
                    Arrays.sort(aint);
                    FeatureSorter.StepFeatureData featuresorter$stepfeaturedata = list.get(k);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature = (PlacedFeature)featuresorter$stepfeaturedata.f_220624_().get(l1);
                        Supplier<String> supplier1 = () -> registry1.m_7854_((Object)placedfeature).map(Object::toString).orElseGet(placedfeature::toString);
                        worldgenrandom.m_190064_(i, l1, k);
                        try {
                            p_223087_.m_143497_(supplier1);
                            placedfeature.m_226377_(p_223087_, this, (RandomSource)worldgenrandom, blockpos);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport2 = CrashReport.m_127521_(exception1, "Feature placement");
                            crashreport2.m_127514_("Feature").m_128165_("Description", (CrashReportDetail<String>)((CrashReportDetail)supplier1::get));
                            throw new ReportedException(crashreport2);
                        }
                    }
                }
                p_223087_.m_143497_((Supplier)null);
            }
            catch (Exception exception2) {
                CrashReport crashreport = CrashReport.m_127521_(exception2, "Biome decoration");
                crashreport.m_127514_("Generation").m_128159_("CenterX", chunkpos.f_45578_).m_128159_("CenterZ", chunkpos.f_45579_).m_128159_("Seed", i);
                throw new ReportedException(crashreport);
            }
        }
        if (!(world = p_223087_.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(p_223087_, p_223088_.m_7697_());
            int x = p_223088_.m_7697_().f_45578_;
            int z = p_223088_.m_7697_().f_45579_;
            for (BlockPopulator populator : world.getPopulators()) {
                WorldgenRandom seededrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(p_223087_.m_7328_()));
                seededrandom.m_64690_(p_223087_.m_7328_(), x, z);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper((RandomSource)seededrandom), x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    public void applyBiomeDecoration(WorldGenLevel p_223087_, ChunkAccess p_223088_, StructureManager p_223089_, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.m_213609_(p_223087_, p_223088_, p_223089_);
        }
        if (!(world = p_223087_.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(p_223087_, p_223088_.m_7697_());
            int x = p_223088_.m_7697_().f_45578_;
            int z = p_223088_.m_7697_().f_45579_;
            for (BlockPopulator populator : world.getPopulators()) {
                WorldgenRandom seededrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(p_223087_.m_7328_()));
                seededrandom.m_64690_(p_223087_.m_7328_(), x, z);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper((RandomSource)seededrandom), x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static BoundingBox m_187717_(ChunkAccess p_187718_) {
        ChunkPos chunkpos = p_187718_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        LevelHeightAccessor levelheightaccessor = p_187718_.m_183618_();
        int k = levelheightaccessor.m_141937_() + 1;
        int l = levelheightaccessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public abstract void m_214194_(WorldGenRegion var1, StructureManager var2, RandomState var3, ChunkAccess var4);

    public abstract void m_6929_(WorldGenRegion var1);

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return 64;
    }

    public BiomeSource m_62218_() {
        return this.f_62137_;
    }

    public abstract int m_6331_();

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_223133_(Holder<Biome> p_223134_, StructureManager p_223135_, MobCategory p_223136_, BlockPos p_223137_) {
        Map map = p_223135_.m_220522_(p_223137_);
        for (Map.Entry entry : map.entrySet()) {
            Structure structure = (Structure)entry.getKey();
            StructureSpawnOverride structurespawnoverride = structure.m_226612_().get((Object)p_223136_);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.f_210043_() == StructureSpawnOverride.BoundingBoxType.PIECE ? p_223065_ -> p_223135_.m_220497_(p_223137_, p_223065_) : p_223130_ -> p_223130_.m_73601_().m_71051_((Vec3i)p_223137_);
            p_223135_.m_220480_(structure, (LongSet)entry.getValue(), p_223220_ -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)p_223220_)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.f_210044_();
        }
        return p_223134_.m_203334_().m_47518_().m_151798_(p_223136_);
    }

    public void m_255037_(RegistryAccess p_255835_, ChunkGeneratorStructureState p_256505_, StructureManager p_255934_, ChunkAccess p_255767_, StructureTemplateManager p_255832_) {
        ChunkPos chunkpos = p_255767_.m_7697_();
        SectionPos sectionpos = SectionPos.m_175562_((ChunkAccess)p_255767_);
        RandomState randomstate = p_256505_.m_255046_();
        p_256505_.m_255252_().forEach(p_255564_ -> {
            StructurePlacement structureplacement = ((StructureSet)p_255564_.m_203334_()).f_210004_();
            List list = ((StructureSet)p_255564_.m_203334_()).f_210003_();
            for (StructureSet.StructureSelectionEntry structureset$structureselectionentry : list) {
                StructureStart structurestart = p_255934_.m_220512_(sectionpos, (Structure)structureset$structureselectionentry.f_210026_().m_203334_(), (StructureAccess)p_255767_);
                if (structurestart == null || !structurestart.m_73603_()) continue;
                return;
            }
            if (structureplacement.m_255071_(p_256505_, p_255560_.f_45578_, p_255560_.f_45579_)) {
                if (list.size() == 1) {
                    this.m_223104_((StructureSet.StructureSelectionEntry)list.get(0), p_255934_, p_255835_, randomstate, p_255832_, p_256505_.m_254887_(), p_255767_, chunkpos, sectionpos);
                } else {
                    ArrayList arraylist = new ArrayList(list.size());
                    arraylist.addAll(list);
                    WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                    worldgenrandom.m_190068_(p_256505_.m_254887_(), p_255560_.f_45578_, p_255560_.f_45579_);
                    int i = 0;
                    for (StructureSet.StructureSelectionEntry structureset$structureselectionentry1 : arraylist) {
                        i += structureset$structureselectionentry1.f_210027_();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.StructureSelectionEntry structureset$structureselectionentry2;
                        int j = worldgenrandom.m_188503_(i);
                        int k = 0;
                        Iterator iterator = arraylist.iterator();
                        while (iterator.hasNext() && (j -= (structureset$structureselectionentry2 = (StructureSet.StructureSelectionEntry)iterator.next()).f_210027_()) >= 0) {
                            ++k;
                        }
                        StructureSet.StructureSelectionEntry structureset$structureselectionentry3 = (StructureSet.StructureSelectionEntry)arraylist.get(k);
                        if (this.m_223104_(structureset$structureselectionentry3, p_255934_, p_255835_, randomstate, p_255832_, p_256505_.m_254887_(), p_255767_, chunkpos, sectionpos)) {
                            return;
                        }
                        arraylist.remove(k);
                        i -= structureset$structureselectionentry3.f_210027_();
                    }
                }
            }
        });
    }

    private boolean m_223104_(StructureSet.StructureSelectionEntry p_223105_, StructureManager p_223106_, RegistryAccess p_223107_, RandomState p_223108_, StructureTemplateManager p_223109_, long p_223110_, ChunkAccess p_223111_, ChunkPos p_223112_, SectionPos p_223113_) {
        Structure structure = (Structure)p_223105_.f_210026_().m_203334_();
        int i = ChunkGenerator.m_223054_(p_223106_, p_223111_, p_223113_, structure);
        HolderSet<Biome> holderset = structure.m_226559_();
        Predicate<Holder<Biome>> predicate = holderset::m_203333_;
        StructureStart structurestart = structure.m_226596_(p_223107_, this, this.f_62137_, p_223108_, p_223109_, p_223110_, p_223112_, i, p_223111_, predicate);
        if (structurestart.m_73603_()) {
            p_223106_.m_220516_(p_223113_, structure, structurestart, (StructureAccess)p_223111_);
            return true;
        }
        return false;
    }

    private static int m_223054_(StructureManager p_223055_, ChunkAccess p_223056_, SectionPos p_223057_, Structure p_223058_) {
        StructureStart structurestart = p_223055_.m_220512_(p_223057_, p_223058_, (StructureAccess)p_223056_);
        return structurestart != null ? structurestart.m_73608_() : 0;
    }

    public void m_223076_(WorldGenLevel p_223077_, StructureManager p_223078_, ChunkAccess p_223079_) {
        int i = 8;
        ChunkPos chunkpos = p_223079_.m_7697_();
        int j = chunkpos.f_45578_;
        int k = chunkpos.f_45579_;
        int l = chunkpos.m_45604_();
        int i1 = chunkpos.m_45605_();
        SectionPos sectionpos = SectionPos.m_175562_((ChunkAccess)p_223079_);
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.m_45589_((int)j1, (int)k1);
                for (StructureStart structurestart : p_223077_.m_6325_(j1, k1).m_6633_().values()) {
                    try {
                        if (!structurestart.m_73603_() || !structurestart.m_73601_().m_71019_(l, i1, l + 15, i1 + 15)) continue;
                        p_223078_.m_220507_(sectionpos, structurestart.m_226861_(), l1, (StructureAccess)p_223079_);
                        DebugPackets.m_133711_((WorldGenLevel)p_223077_, (StructureStart)structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.m_127521_(exception, "Generating structure reference");
                        CrashReportCategory crashreportcategory = crashreport.m_127514_("Structure");
                        Optional optional = p_223077_.m_8891_().m_6632_(Registries.f_256944_);
                        crashreportcategory.m_128165_("Id", (CrashReportDetail<String>)((CrashReportDetail)() -> optional.map(p_258977_ -> p_258977_.m_7981_((Object)structurestart.m_226861_()).toString()).orElse("UNKNOWN")));
                        crashreportcategory.m_128165_("Name", (CrashReportDetail<String>)((CrashReportDetail)() -> BuiltInRegistries.f_256763_.m_7981_(structurestart.m_226861_().m_213658_()).toString()));
                        crashreportcategory.m_128165_("Class", (CrashReportDetail<String>)((CrashReportDetail)() -> structurestart.m_226861_().getClass().getCanonicalName()));
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> m_213974_(Executor var1, Blender var2, RandomState var3, StructureManager var4, ChunkAccess var5);

    public abstract int m_6337_();

    public abstract int m_142062_();

    public abstract int m_214096_(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4, RandomState var5);

    public abstract NoiseColumn m_214184_(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int m_223221_(int p_223222_, int p_223223_, Heightmap.Types p_223224_, LevelHeightAccessor p_223225_, RandomState p_223226_) {
        return this.m_214096_(p_223222_, p_223223_, p_223224_, p_223225_, p_223226_);
    }

    public int m_223235_(int p_223236_, int p_223237_, Heightmap.Types p_223238_, LevelHeightAccessor p_223239_, RandomState p_223240_) {
        return this.m_214096_(p_223236_, p_223237_, p_223238_, p_223239_, p_223240_) - 1;
    }

    public abstract void m_213600_(List<String> var1, RandomState var2, BlockPos var3);

    @Deprecated
    public BiomeGenerationSettings m_223131_(Holder<Biome> p_223132_) {
        return this.f_223021_.apply(p_223132_);
    }

    private static /* synthetic */ void m_223171_(IntSet p_223172_, FeatureSorter.StepFeatureData p_223173_, PlacedFeature p_223174_) {
        p_223172_.add(p_223173_.f_220625_().applyAsInt(p_223174_));
    }

    private static /* synthetic */ void m_223090_(WorldGenLevel p_223091_, Set p_223092_, ChunkPos p_223093_) {
        ChunkAccess chunkaccess = p_223091_.m_6325_(p_223093_.f_45578_, p_223093_.f_45579_);
        for (LevelChunkSection levelchunksection : chunkaccess.m_7103_()) {
            levelchunksection.m_187996_().m_196879_(p_223092_::add);
        }
    }
}

