/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.util.Arrays;
import java.util.Collection;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingAnnotationAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class UnsortedRemappingMethodAdapter
extends MethodVisitor {
    private static final Collection<Handle> META_FACTORIES = Arrays.asList(new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"), new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;"));
    protected final CustomRemapper remapper;
    private final ClassRepo classRepo;

    public UnsortedRemappingMethodAdapter(int access, String desc, MethodVisitor mv, CustomRemapper remapper, ClassRepo classRepo) {
        this(327680, access, desc, mv, remapper, classRepo);
    }

    protected UnsortedRemappingMethodAdapter(int api, int access, String desc, MethodVisitor mv, CustomRemapper remapper, ClassRepo classRepo) {
        super(api, mv);
        this.remapper = remapper;
        this.classRepo = classRepo;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor av = this.mv.visitAnnotationDefault();
        return av == null ? av : new RemappingAnnotationAdapter(av, (Remapper)this.remapper);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = this.mv.visitAnnotation(this.remapper.mapDesc(desc), visible);
        return av == null ? av : new RemappingAnnotationAdapter(av, (Remapper)this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, this.remapper.mapDesc(desc), visible);
        return av == null ? av : new RemappingAnnotationAdapter(av, (Remapper)this.remapper);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        super.visitFrame(type, nLocal, this.remapEntries(nLocal, local), nStack, this.remapEntries(nStack, stack));
    }

    private Object[] remapEntries(int n, Object[] entries) {
        for (int i = 0; i < n; ++i) {
            if (!(entries[i] instanceof String)) continue;
            Object[] newEntries = new Object[n];
            if (i > 0) {
                System.arraycopy(entries, 0, newEntries, 0, i);
            }
            do {
                Object t = entries[i];
                Object object = newEntries[i++] = t instanceof String ? this.remapper.mapType((String)t) : t;
            } while (i < n);
            return newEntries;
        }
        return entries;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, this.remapper.mapType(owner), this.remapper.mapFieldName(owner, name, desc, this.findAccess(NodeType.FIELD, owner, name, desc)), this.remapper.mapDesc(desc));
    }

    private int findAccess(NodeType type, String owner, String name, String desc, ClassRepo repo) {
        ClassNode clazz;
        int access = -1;
        if (repo != null && (clazz = this.classRepo.findClass(owner)) != null) {
            block0 : switch (type) {
                case FIELD: {
                    for (FieldNode f : clazz.fields) {
                        if (!f.name.equals(name) || !f.desc.equals(desc)) continue;
                        access = f.access;
                        break block0;
                    }
                    break;
                }
                case METHOD: {
                    for (MethodNode m : this.classRepo.findClass((String)owner).methods) {
                        if (!m.name.equals(name) || !m.desc.equals(desc)) continue;
                        access = m.access;
                        break block0;
                    }
                    break;
                }
            }
        }
        return access;
    }

    public int findAccess(NodeType type, String owner, String name, String desc) {
        int access = this.findAccess(type, owner, name, desc, this.classRepo);
        if (access == -1) {
            access = this.findAccess(type, owner, name, desc, RuntimeRepo.getInstance());
        }
        return access;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, this.remapper.mapType(owner), this.remapper.mapMethodName(owner, name, desc, this.findAccess(NodeType.METHOD, owner, name, desc)), this.remapper.mapMethodDesc(desc), itf);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (META_FACTORIES.contains(bsm)) {
            String owner = Type.getReturnType((String)desc).getInternalName();
            String odesc = ((Type)bsmArgs[0]).getDescriptor();
            name = this.remapper.mapMethodName(owner, name, odesc, this.findAccess(NodeType.METHOD, owner, name, odesc));
        } else {
            name = this.remapper.mapInvokeDynamicMethodName(name, desc);
        }
        for (int i = 0; i < bsmArgs.length; ++i) {
            bsmArgs[i] = this.remapper.mapValue(bsmArgs[i]);
        }
        super.visitInvokeDynamicInsn(name, this.remapper.mapMethodDesc(desc), (Handle)this.remapper.mapValue(bsm), bsmArgs);
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, this.remapper.mapType(type));
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(this.remapper.mapValue(cst));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(desc), dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type == null ? null : this.remapper.mapType(type));
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), start, end, index);
    }
}

