/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteDoubleMapOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableLHashSeparateKVByteDoubleMapSO;
import com.koloboke.collect.impl.hash.SeparateKVByteDoubleLHash;
import com.koloboke.collect.map.ByteDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteDoubleConsumer;
import com.koloboke.function.ByteDoublePredicate;
import com.koloboke.function.ByteDoubleToDoubleFunction;
import com.koloboke.function.ByteToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableLHashSeparateKVByteDoubleMapGO
extends ImmutableLHashSeparateKVByteDoubleMapSO {
    @Override
    final void copy(SeparateKVByteDoubleLHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteDoubleLHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(byte key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(byte key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(byte key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept((Byte)key, (Double)Double.longBitsToDouble(vals[i]));
        }
    }

    public void forEach(ByteDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
    }

    public boolean forEachWhile(ByteDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ByteDoubleCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteDoubleMapOps.containsAllEntries((InternalByteDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Double put(Byte key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double put(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public Double putIfAbsent(Byte key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double putIfAbsent(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(byte key, long value) {
        throw new UnsupportedOperationException();
    }

    public Double compute(Byte key, BiFunction<? super Byte, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double compute(byte key, ByteDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double computeIfAbsent(Byte key, Function<? super Byte, ? extends Double> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfAbsent(byte key, ByteToDoubleFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double computeIfPresent(Byte key, BiFunction<? super Byte, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfPresent(byte key, ByteDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double merge(Byte key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double merge(byte key, double value, DoubleBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double addValue(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public double addValue(byte key, double addition, double initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Double> m) {
        CommonByteDoubleMapOps.putAll((InternalByteDoubleMapOps)this, m);
    }

    public Double replace(Byte key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double replace(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Byte key, Double oldValue, Double newValue) {
        return this.replace((byte)key, (double)oldValue, (double)newValue);
    }

    public boolean replace(byte key, double oldValue, double newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Byte, ? super Double, ? extends Double> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ByteDoubleToDoubleFunction function) {
        throw new UnsupportedOperationException();
    }

    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public double remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Double)value);
    }

    public boolean remove(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteDoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteDoubleCursor {
        final byte[] keys;
        final long[] vals;
        final byte free;
        int index;
        byte curKey;
        long curValue;

        NoRemovedMapCursor() {
            byte free;
            this.keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue);
        }

        public void forEachForward(ByteDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final byte[] keys;
        final long[] vals;
        final byte free;
        int index;
        byte curKey;
        long curValue;

        NoRemovedValueCursor() {
            byte free;
            this.keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue);
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final byte[] keys;
        final long[] vals;
        final byte free;
        int nextIndex;
        double next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            byte free = this.free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                double prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = Double.longBitsToDouble(this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Double>> {
        final byte[] keys;
        final long[] vals;
        final byte free;
        int index;
        byte curKey;
        long curValue;

        NoRemovedEntryCursor() {
            byte free;
            this.keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Double>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Double> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Double>> {
        final byte[] keys;
        final long[] vals;
        final byte free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            byte free = this.free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Double>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    byte key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public DoubleCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            ImmutableLHashSeparateKVByteDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteDoubleEntry {
        private byte key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ByteDoubleEntry {
        private final byte key;
        private final long value;

        ImmutableEntry(byte key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class ByteDoubleEntry
    extends AbstractEntry<Byte, Double> {
        ByteDoubleEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Double>>
    implements HashObjSet<Map.Entry<Byte, Double>>,
    InternalObjCollectionOps<Map.Entry<Byte, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVByteDoubleMapGO.this.containsEntry((byte)((Byte)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Double>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test((Map.Entry<Byte, Double>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Double>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Double>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVByteDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                double value = (Double)e.getValue();
                return ImmutableLHashSeparateKVByteDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

