/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.LongIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractLongValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonDoubleLongMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleLongMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashParallelKVDoubleLongMapSO;
import com.koloboke.collect.impl.hash.ParallelKVDoubleLongQHash;
import com.koloboke.collect.map.DoubleLongCursor;
import com.koloboke.collect.set.LongSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.DoubleLongConsumer;
import com.koloboke.function.DoubleLongPredicate;
import com.koloboke.function.DoubleLongToLongFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleToLongFunction;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashParallelKVDoubleLongMapGO
extends ImmutableQHashParallelKVDoubleLongMapSO {
    final void copy(ParallelKVDoubleLongQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVDoubleLongQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    public boolean containsEntry(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public Long get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return null;
    }

    public long get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return this.defaultValue();
    }

    public Long getOrDefault(Object key, Long defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public long getOrDefault(double key, long defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Double, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Long)tab[i + 1]);
        }
    }

    public void forEach(DoubleLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), tab[i + 1]);
        }
    }

    public boolean forEachWhile(DoubleLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), tab[i + 1])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public DoubleLongCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleLongMapOps.containsAllEntries((InternalDoubleLongMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalDoubleLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalDoubleLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, tab[i + 1]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Double, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(tab[i + 1]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Long put(Double key, Long value) {
        throw new UnsupportedOperationException();
    }

    public long put(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public Long putIfAbsent(Double key, Long value) {
        throw new UnsupportedOperationException();
    }

    public long putIfAbsent(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(long key, long value) {
        throw new UnsupportedOperationException();
    }

    public Long compute(Double key, BiFunction<? super Double, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long compute(double key, DoubleLongToLongFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Long computeIfAbsent(Double key, Function<? super Double, ? extends Long> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfAbsent(double key, DoubleToLongFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Long computeIfPresent(Double key, BiFunction<? super Double, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfPresent(double key, DoubleLongToLongFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Long merge(Double key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long merge(double key, long value, LongBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long addValue(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public long addValue(double key, long addition, long initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Double, ? extends Long> m) {
        CommonDoubleLongMapOps.putAll((InternalDoubleLongMapOps)this, m);
    }

    public Long replace(Double key, Long value) {
        throw new UnsupportedOperationException();
    }

    public long replace(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Double key, Long oldValue, Long newValue) {
        return this.replace((double)key, (long)oldValue, (long)newValue);
    }

    public boolean replace(double key, long oldValue, long newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Double, ? super Long, ? extends Long> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(DoubleLongToLongFunction function) {
        throw new UnsupportedOperationException();
    }

    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public long remove(double key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Long)value);
    }

    public boolean remove(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleLongCursor {
        final long[] tab;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor() {
            this.tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), tab[i + 1]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey == 0x7FFFFFFFFFFFFFFEL) {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final long[] tab;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor() {
            this.tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public long elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final long[] tab;
        int nextIndex;
        long next;

        NoRemovedValueIterator() {
            this.tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                long prev = this.next;
                while ((nextI -= 2) >= 0) {
                    if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = tab[nextI + 1];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Long>> {
        final long[] tab;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor() {
            this.tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Long>)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Long> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Long>> {
        final long[] tab;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new ImmutableEntry(key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Long>)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                ImmutableEntry prev = this.next;
                while ((nextI -= 2) >= 0) {
                    long key = tab[nextI];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = new ImmutableEntry(key, tab[nextI + 1]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Long)tab[i + 1]);
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(tab[i + 1]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeLong(tab[i + 1]);
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public LongCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = tab[i + 1];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = tab[i + 1];
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(tab[i + 1]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashParallelKVDoubleLongMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleLongEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends DoubleLongEntry {
        private final long key;
        private final long value;

        ImmutableEntry(long key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class DoubleLongEntry
    extends AbstractEntry<Double, Long> {
        DoubleLongEntry() {
        }

        abstract long key();

        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract long value();

        public final Long getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Long>>
    implements HashObjSet<Map.Entry<Double, Long>>,
    InternalObjCollectionOps<Map.Entry<Double, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Long>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashParallelKVDoubleLongMapGO.this.containsEntry((Double)e.getKey(), (long)((Long)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new ImmutableEntry(key, tab[i + 1]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new ImmutableEntry(key, tab[i + 1]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Long>)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Map.Entry<Double, Long>)((Object)new ImmutableEntry(key, tab[i + 1])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Double, Long>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Long>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new ImmutableEntry(key, tab[i + 1]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableQHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(tab[i + 1]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVDoubleLongMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                long value = (Long)e.getValue();
                return ImmutableQHashParallelKVDoubleLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

