/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ImmutableQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVByteQHash;

public abstract class ImmutableSeparateKVByteQHashSO
extends ImmutableQHash
implements SeparateKVByteQHash,
PrimitiveConstants,
UnsafeConstants {
    byte freeValue;
    byte[] set;

    void copy(SeparateKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (byte[])hash.keys().clone();
    }

    void move(SeparateKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, byte freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public byte freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public byte removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Byte)key);
    }

    public boolean contains(byte key) {
        return this.index(key) >= 0;
    }

    int index(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }
}

