/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.ImmutableLHash;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVFloatLHash;

public abstract class ImmutableSeparateKVFloatLHashSO
extends ImmutableLHash
implements SeparateKVFloatLHash,
PrimitiveConstants,
UnsafeConstants {
    int[] set;

    void copy(SeparateKVFloatLHash hash) {
        super.copy(hash);
        this.set = (int[])hash.keys().clone();
    }

    void move(SeparateKVFloatLHash hash) {
        super.copy(hash);
        this.set = hash.keys();
    }

    public boolean contains(Object key) {
        return this.contains(((Float)key).floatValue());
    }

    public boolean contains(float key) {
        return this.index(Float.floatToIntBits(key)) >= 0;
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)key) & capacityMask;
        int cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFE) {
            return -1;
        }
        do {
            if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
            return index;
        } while (cur != 0x7FFFFFFE);
        return -1;
    }
}

