/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ImmutableLHashObjSet;
import com.koloboke.collect.impl.hash.ImmutableLHashObjSetGO;
import com.koloboke.collect.impl.hash.MutableLHashObjSet;
import com.koloboke.collect.impl.hash.MutableLHashObjSetGO;
import com.koloboke.collect.impl.hash.ObjHashFactorySO;
import com.koloboke.collect.impl.hash.SeparateKVObjLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashObjSet;
import com.koloboke.collect.impl.hash.UpdatableLHashObjSetGO;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.collect.set.hash.HashObjSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashObjSetFactorySO<E>
extends ObjHashFactorySO<E>
implements HashObjSetFactory<E> {
    LHashObjSetFactorySO(HashConfig hashConf, int defaultExpectedSize, boolean isNullAllowed) {
        super(hashConf, defaultExpectedSize, isNullAllowed);
    }

    String keySpecialString() {
        return ",equivalence=" + this.getEquivalence() + ",nullKeyAllowed=" + this.isNullKeyAllowed();
    }

    boolean keySpecialEquals(HashObjSetFactory<?> other) {
        return this.getEquivalence().equals((Object)other.getEquivalence()) && this.isNullKeyAllowed() == other.isNullKeyAllowed();
    }

    @Override
    @Nonnull
    public Equivalence<E> getEquivalence() {
        return Equivalence.defaultEquality();
    }

    <E2 extends E> MutableLHashObjSetGO<E2> uninitializedMutableSet() {
        return new MutableLHashObjSet();
    }

    <E2 extends E> UpdatableLHashObjSetGO<E2> uninitializedUpdatableSet() {
        return new UpdatableLHashObjSet();
    }

    <E2 extends E> ImmutableLHashObjSetGO<E2> uninitializedImmutableSet() {
        return new ImmutableLHashObjSet();
    }

    @Nonnull
    public <E2 extends E> MutableLHashObjSetGO<E2> newMutableSet(int expectedSize) {
        MutableLHashObjSetGO<E2> set = this.uninitializedMutableSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(int expectedSize) {
        UpdatableLHashObjSetGO<E2> set = this.uninitializedUpdatableSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elements, int expectedSize) {
        if (elements instanceof ObjCollection) {
            int size;
            if (elements instanceof ObjSet) {
                SeparateKVObjLHash hash;
                ObjSet elemSet = (ObjSet)elements;
                if (elements instanceof SeparateKVObjLHash && (hash = (SeparateKVObjLHash)((Object)elements)).hashConfig().equals(this.hashConf) && elemSet.equivalence().equals(this.getEquivalence())) {
                    UpdatableLHashObjSetGO<E2> set = this.uninitializedUpdatableSet();
                    set.copy(hash);
                    return set;
                }
                size = elemSet.equivalence().equals(this.getEquivalence()) ? elemSet.size() : expectedSize;
            } else {
                size = expectedSize;
            }
            HashObjSet set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = this.getEquivalence() == null && elements instanceof Set ? ((Set)elements).size() : expectedSize;
        HashObjSet set = this.newUpdatableSet(size);
        for (E2 e : elements) {
            set.add(e);
        }
        return set;
    }
}

