/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonDoubleByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleByteMapOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVDoubleByteMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVDoubleLHashGO;
import com.koloboke.collect.impl.hash.SeparateKVDoubleByteLHash;
import com.koloboke.collect.map.DoubleByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashDoubleSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.DoubleByteConsumer;
import com.koloboke.function.DoubleBytePredicate;
import com.koloboke.function.DoubleByteToByteFunction;
import com.koloboke.function.DoubleToByteFunction;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableLHashSeparateKVDoubleByteMapGO
extends MutableLHashSeparateKVDoubleByteMapSO {
    @Override
    final void copy(SeparateKVDoubleByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public boolean containsEntry(long key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Byte get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(double key, byte defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Double, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleByteCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleByteMapOps.containsAllEntries((InternalDoubleByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalDoubleByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalDoubleByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Double, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        byte[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = LHash.SeparateKVDoubleKeyMixing.mix((long)key) & capacityMask;
            if (newKeys[index] != 0x7FFFFFFFFFFFFFFEL) {
                while (newKeys[index = index - 1 & capacityMask] != 0x7FFFFFFFFFFFFFFEL) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte put(Double key, Byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public byte put(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Byte putIfAbsent(Double key, Byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public byte putIfAbsent(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public void justPut(long key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Byte compute(Double key, BiFunction<? super Double, ? super Byte, ? extends Byte> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Byte)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte compute(double key, DoubleByteToByteFunction remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsByte(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(Double.longBitsToDouble(k), vals[index]);
        return newValue;
    }

    public Byte computeIfAbsent(Double key, Function<? super Double, ? extends Byte> mappingFunction) {
        Byte value;
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(double key, DoubleToByteFunction mappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        byte value = mappingFunction.applyAsByte(Double.longBitsToDouble(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    public Byte computeIfPresent(Double key, BiFunction<? super Double, ? super Byte, ? extends Byte> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            Byte newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Byte)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public byte computeIfPresent(double key, DoubleByteToByteFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte newValue;
            byte[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsByte(Double.longBitsToDouble(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Byte merge(Double key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte merge(double key, byte value, ByteBinaryOperator remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(double key, byte value) {
        block1: {
            k = Double.doubleToLongBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl11:
                // 2 sources

                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(double key, byte addition, byte initialValue) {
        block1: {
            k = Double.doubleToLongBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl11:
                // 2 sources

                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Double, ? extends Byte> m) {
        CommonDoubleByteMapOps.putAll((InternalDoubleByteMapOps)this, m);
    }

    public Byte replace(Double key, Byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    public byte replace(double key, byte value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Double key, Byte oldValue, Byte newValue) {
        return this.replace((double)key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(double key, byte oldValue, byte newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Double, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.apply((Double)Double.longBitsToDouble(key), (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.applyAsByte(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long keyToShift;
        int indexToRemove;
        long[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
    }

    public Byte remove(Object key) {
        long keyToShift;
        int indexToRemove;
        long k = Double.doubleToLongBits((Double)key);
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return null;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return null;
            }
        }
        byte[] vals = this.values;
        byte val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(double key) {
        long keyToShift;
        int indexToRemove;
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return false;
            }
        }
        byte[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(long key) {
        long keyToShift;
        int indexToRemove;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)key) & capacityMask;
        long cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return false;
            }
        }
        byte[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return true;
    }

    public byte remove(double key) {
        long keyToShift;
        int indexToRemove;
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return this.defaultValue();
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return this.defaultValue();
            }
        }
        byte[] vals = this.values;
        byte val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
        this.postRemoveHook();
        return val;
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Byte)value);
    }

    public boolean remove(double key, byte value) {
        byte[] vals;
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
                return false;
            }
        }
        if ((vals = this.values)[index] == value) {
            long keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(DoubleBytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(key), vals[i])) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Double> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Double)Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(DoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.removeAll(thisC, (InternalDoubleCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.removeAll(thisC, (InternalDoubleCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.retainAll(thisC, (DoubleCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.retainAll(thisC, (InternalDoubleCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                        if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Long.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                    this.postRemoveHook();
                } else {
                    keys[i] = Long.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved) {
        long[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            long keyToShift;
            int indexToRemove;
            if (keys[i] != Long.MAX_VALUE) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (keyToShift != Long.MAX_VALUE && (LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
            this.postRemoveHook();
        }
    }

    @Override
    public DoubleIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public DoubleCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements DoubleByteCursor {
        long[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(byte value) {
            if (this.curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = value;
            if (this.vals == MutableLHashSeparateKVDoubleByteMapGO.this.values) return;
            MutableLHashSeparateKVDoubleByteMapGO.this.values[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        long[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public byte elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        long[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = vals[indexToShift];
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(keys[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Byte>> {
        long[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Byte>)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Byte> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, byte value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(byte newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVDoubleByteMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVDoubleByteMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Byte>> {
        long[] keys;
        byte[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Byte>)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVDoubleByteMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(keys[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, byte value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(byte newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVDoubleByteMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVDoubleByteMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashSeparateKVDoubleByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return MutableLHashSeparateKVDoubleByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Byte)vals[i]);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeByte(vals[i]);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return MutableLHashSeparateKVDoubleByteMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableLHashSeparateKVDoubleByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Byte)vals[i])) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(BytePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test(vals[i])) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.removeAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.retainAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends DoubleByteEntry {
        private long key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleByteEntry {
        final int modCount;
        private final int index;
        final long key;
        private byte value;

        MutableEntry(int modCount, int index, long key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            MutableLHashSeparateKVDoubleByteMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class DoubleByteEntry
    extends AbstractEntry<Double, Byte> {
        DoubleByteEntry() {
        }

        abstract long key();

        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Byte>>
    implements HashObjSet<Map.Entry<Double, Byte>>,
    InternalObjCollectionOps<Map.Entry<Double, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVDoubleByteMapGO.this.containsEntry((Double)e.getKey(), (byte)((Byte)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Map.Entry<Double, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Double, Byte>> iterator() {
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Byte>> cursor() {
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVDoubleByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                byte value = (Byte)e.getValue();
                return MutableLHashSeparateKVDoubleByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Byte>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Map.Entry<Double, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVDoubleByteMapGO.this.modCount();
            long[] keys = MutableLHashSeparateKVDoubleByteMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte[] vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                            if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Long.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                        MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Long.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVDoubleByteMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashSeparateKVDoubleByteMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVDoubleLHashGO.NoRemovedCursor {
        byte[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVDoubleByteMapGO.this, mc);
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            long curKey = this.curKey;
            if (curKey == 0x7FFFFFFFFFFFFFFEL) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            int index = this.index;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVDoubleLHashGO.NoRemovedIterator {
        byte[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVDoubleByteMapGO.this, mc);
            this.vals = MutableLHashSeparateKVDoubleByteMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVDoubleByteMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            if (keys == MutableLHashSeparateKVDoubleByteMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVDoubleByteMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                    if ((LHash.SeparateKVDoubleKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Double.longBitsToDouble(keyToShift);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFFFFFFFFFEL;
                MutableLHashSeparateKVDoubleByteMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVDoubleByteMapGO.this.justRemove(keys[index]);
            }
        }
    }
}

