/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalDoubleByteMapOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVDoubleKeyMap;
import com.koloboke.collect.impl.hash.SeparateKVDoubleByteLHash;
import com.koloboke.collect.map.hash.HashDoubleByteMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class MutableLHashSeparateKVDoubleByteMapSO
extends MutableLHashSeparateKVDoubleKeyMap
implements HashDoubleByteMap,
InternalDoubleByteMapOps,
SeparateKVDoubleByteLHash {
    byte[] values;

    void copy(SeparateKVDoubleByteLHash hash) {
        super.copy(hash);
        this.values = (byte[])hash.valueArray().clone();
    }

    void move(SeparateKVDoubleByteLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public byte[] valueArray() {
        return this.values;
    }

    int valueIndex(byte value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(byte value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(byte value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue((Byte)value);
    }

    int insert(long key, byte value) {
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)key) & capacityMask;
        long cur = keys[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new byte[capacity];
    }
}

