/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.IntArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.MutableQHash;
import com.koloboke.collect.impl.hash.ParallelKVFloatQHash;
import com.koloboke.collect.impl.hash.QHash;

public abstract class MutableParallelKVFloatQHashSO
extends MutableQHash
implements ParallelKVFloatQHash,
PrimitiveConstants,
UnsafeConstants {
    long[] table;

    void copy(ParallelKVFloatQHash hash) {
        super.copy(hash);
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVFloatQHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    public boolean contains(Object key) {
        return this.contains(((Float)key).floatValue());
    }

    public boolean contains(float key) {
        return this.index(Float.floatToIntBits(key)) >= 0;
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFE) {
            return -1;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == key) {
                return bIndex;
            }
            if (cur == 0x7FFFFFFE) {
                return -1;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == key) {
                return fIndex;
            }
            if (cur == 0x7FFFFFFE) {
                return -1;
            }
            step += 2;
        }
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity];
        IntArrays.fillKeys((long[])this.table, (int)0x7FFFFFFE);
    }

    @Override
    public void clear() {
        super.clear();
        IntArrays.fillKeys((long[])this.table, (int)0x7FFFFFFE);
    }

    @Override
    void removeAt(int index) {
        U.putInt(this.table, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
    }
}

