/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalIntFloatMapOps;
import com.koloboke.collect.impl.hash.MutableQHashParallelKVIntKeyMap;
import com.koloboke.collect.impl.hash.ParallelKVIntFloatQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.hash.HashIntFloatMap;
import java.util.ConcurrentModificationException;

public abstract class MutableQHashParallelKVIntFloatMapSO
extends MutableQHashParallelKVIntKeyMap
implements HashIntFloatMap,
InternalIntFloatMapOps,
ParallelKVIntFloatQHash {
    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || value != (int)(entry >>> 32)) continue;
                index = i;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed || value != (int)(entry >>> 32)) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || val != (int)(entry >>> 32)) continue;
                index = i;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed || val != (int)(entry >>> 32)) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(int key, int value) {
        block24: {
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix((int)key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return index;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (int)(entry = tab[bIndex])) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return bIndex;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (int)(entry = tab[fIndex])) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return fIndex;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return bIndex;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return fIndex;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                tab[firstRemoved] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
        this.postFreeSlotInsertHook();
        return -1;
    }
}

