/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonIntObjMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalIntObjMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVIntObjMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVIntQHashGO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVIntObjQHash;
import com.koloboke.collect.map.IntObjCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashIntSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.IntObjConsumer;
import com.koloboke.function.IntObjFunction;
import com.koloboke.function.IntObjPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVIntObjMapGO<V>
extends MutableQHashSeparateKVIntObjMapSO<V> {
    @Override
    final void copy(SeparateKVIntObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    public boolean containsEntry(int key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    public V get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(int key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Integer, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntObjCursor<V> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntObjMapOps.containsAllEntries((InternalIntObjMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalIntObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalIntObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Integer, V>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                hashCode += key ^ this.nullableValueHashCode(vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += key ^ this.nullableValueHashCode(vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        Object[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public V put(Integer key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V put(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V putIfAbsent(Integer key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public V putIfAbsent(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public void justPut(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public V compute(Integer key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        V newValue;
        int index;
        Object[] vals;
        int removed;
        int k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                V newValue2;
                block29: {
                    if (cur != free) {
                        V newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(k, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        vals[index] = null;
        this.postRemoveHook();
        return null;
    }

    public V compute(int key, IntObjFunction<? super V, ? extends V> remappingFunction) {
        Object newValue;
        int index;
        Object[] vals;
        int removed;
        block28: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                Object newValue2;
                block29: {
                    if (cur != free) {
                        Object newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(key, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = key;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return (V)newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return (V)newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
            vals[index] = newValue;
            return (V)newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        vals[index] = null;
        this.postRemoveHook();
        return null;
    }

    public V computeIfAbsent(Integer key, Function<? super Integer, ? extends V> mappingFunction) {
        Object val;
        int index;
        Object[] vals;
        int k;
        block29: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                V value;
                block30: {
                    if (cur != free) {
                        V value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((value2 = mappingFunction.apply(k)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = value2;
                            this.postRemovedSlotInsertHook();
                            return value2;
                        }
                        return null;
                    }
                }
                if ((value = mappingFunction.apply(k)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = value;
                    this.postFreeSlotInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        V value = mappingFunction.apply(k);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        Object val;
        int index;
        Object[] vals;
        block29: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                V value;
                block30: {
                    if (cur != free) {
                        V value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((value2 = mappingFunction.apply(key)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = key;
                            vals[firstRemoved] = value2;
                            this.postRemovedSlotInsertHook();
                            return value2;
                        }
                        return null;
                    }
                }
                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postFreeSlotInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        V value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    public V computeIfPresent(Integer key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                V newValue = remappingFunction.apply(k, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return newValue;
                }
                this.incrementModCount();
                this.set[index] = this.removedValue;
                vals[index] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    public V computeIfPresent(int key, IntObjFunction<? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                Object newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return (V)newValue;
                }
                this.incrementModCount();
                this.set[index] = this.removedValue;
                vals[index] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    public V merge(Integer key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] vals;
        int removed;
        block28: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                block29: {
                    if (cur != free) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return null;
        }
        vals[index] = value;
        return value;
    }

    public V merge(int key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] vals;
        int removed;
        block28: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                block29: {
                    if (cur != free) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return null;
        }
        vals[index] = value;
        return value;
    }

    public void putAll(@Nonnull Map<? extends Integer, ? extends V> m) {
        CommonIntObjMapOps.putAll((InternalIntObjMapOps)this, m);
    }

    public V replace(Integer key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public V replace(int key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public boolean replace(Integer key, V oldValue, V newValue) {
        return this.replace((int)key, oldValue, newValue);
    }

    public boolean replace(int key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            if (this.nullableValueEquals(vals[index], oldValue)) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Integer, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntObjFunction<? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.values[index] = null;
        this.postRemoveHook();
    }

    public V remove(Object key) {
        int removed;
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    @Override
    public boolean justRemove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.values[index] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public V remove(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, value);
    }

    public boolean remove(int key, Object value) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            Object[] vals;
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.nullableValueEquals((vals = this.values)[index], value)) {
                this.incrementModCount();
                keys[index] = removed;
                vals[index] = null;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(IntObjPredicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Integer> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !filter.test((Integer)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !filter.test((Integer)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(IntPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.retainAll(thisC, (IntCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public IntIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyIterator(mc);
        }
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public IntCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyCursor(mc);
        }
        return new NoRemovedKeyCursor(mc);
    }

    class SomeRemovedMapCursor
    implements IntObjCursor<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements IntObjCursor<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ObjCursor<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ObjIterator<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    int removed = this.removed;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, V>> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, V> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, V>> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, V> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    int removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, V>> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, V> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, V>> {
        final int[] keys;
        final V[] vals;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, V> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return MutableQHashSeparateKVIntObjMapGO.this.valueEquivalence();
        }

        public int size() {
            return MutableQHashSeparateKVIntObjMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVIntObjMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVIntObjMapGO.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.remove(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object val;
                    if (keys[i] == free) continue;
                    sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object val;
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return MutableQHashSeparateKVIntObjMapGO.this.removeValue(o);
        }

        public void clear() {
            MutableQHashSeparateKVIntObjMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends IntObjEntry {
        private int key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntObjEntry {
        final int modCount;
        private final int index;
        final int key;
        private V value;

        MutableEntry(int modCount, int index, int key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        public V setValue(V newValue) {
            if (this.modCount != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            MutableQHashSeparateKVIntObjMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class IntObjEntry
    extends AbstractEntry<Integer, V> {
        IntObjEntry() {
        }

        abstract int key();

        public final Integer getKey() {
            return this.key();
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && MutableQHashSeparateKVIntObjMapGO.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ MutableQHashSeparateKVIntObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, V>>
    implements HashObjSet<Map.Entry<Integer, V>>,
    InternalObjCollectionOps<Map.Entry<Integer, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), MutableQHashSeparateKVIntObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVIntObjMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVIntObjMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVIntObjMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVIntObjMapGO.this.containsEntry((Integer)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Integer, V>> iterator() {
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, V>> cursor() {
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVIntObjMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    Object val = vals[i];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    Object val = vals[i];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVIntObjMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                Object value = e.getValue();
                return MutableQHashSeparateKVIntObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, V>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVIntObjMapGO.this.modCount();
            int free = MutableQHashSeparateKVIntObjMapGO.this.freeValue;
            int removed = MutableQHashSeparateKVIntObjMapGO.this.removedValue;
            int[] keys = MutableQHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVIntObjMapGO.this.values;
            if (MutableQHashSeparateKVIntObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVIntObjMapGO.this.doClear();
        }
    }

    class SomeRemovedKeyCursor
    extends MutableSeparateKVIntQHashGO.SomeRemovedCursor {
        final V[] vals;

        private SomeRemovedKeyCursor(int mc) {
            super(MutableQHashSeparateKVIntObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedKeyIterator
    extends MutableSeparateKVIntQHashGO.SomeRemovedIterator {
        final V[] vals;

        private SomeRemovedKeyIterator(int mc) {
            super(MutableQHashSeparateKVIntObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVIntQHashGO.NoRemovedCursor {
        final V[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableQHashSeparateKVIntObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVIntQHashGO.NoRemovedIterator {
        final V[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableQHashSeparateKVIntObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVIntObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVIntObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVIntObjMapGO.this.postRemoveHook();
        }
    }
}

