/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalShortDoubleMapOps;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVShortKeyMap;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVShortDoubleQHash;
import com.koloboke.collect.map.hash.HashShortDoubleMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class MutableQHashSeparateKVShortDoubleMapSO
extends MutableQHashSeparateKVShortKeyMap
implements HashShortDoubleMap,
InternalShortDoubleMapOps,
SeparateKVShortDoubleQHash {
    long[] values;

    void copy(SeparateKVShortDoubleQHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVShortDoubleQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || value != vals[i]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || value != vals[i]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || val != vals[i]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || val != vals[i]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(short key, long value) {
        block24: {
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            short[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVShortKeyMixing.mix((short)key) % capacity;
            short cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return index;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return bIndex;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return fIndex;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return bIndex;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return fIndex;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

