/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.DoubleQHashFactory;
import com.koloboke.collect.impl.hash.ImmutableQHashDoubleSet;
import com.koloboke.collect.impl.hash.ImmutableQHashDoubleSetGO;
import com.koloboke.collect.impl.hash.MutableQHashDoubleSet;
import com.koloboke.collect.impl.hash.MutableQHashDoubleSetGO;
import com.koloboke.collect.impl.hash.SeparateKVDoubleQHash;
import com.koloboke.collect.impl.hash.UpdatableQHashDoubleSet;
import com.koloboke.collect.impl.hash.UpdatableQHashDoubleSetGO;
import com.koloboke.collect.set.hash.HashDoubleSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class QHashDoubleSetFactorySO
extends DoubleQHashFactory
implements HashDoubleSetFactory {
    QHashDoubleSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableQHashDoubleSetGO uninitializedMutableSet() {
        return new MutableQHashDoubleSet();
    }

    UpdatableQHashDoubleSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashDoubleSet();
    }

    ImmutableQHashDoubleSetGO uninitializedImmutableSet() {
        return new ImmutableQHashDoubleSet();
    }

    @Nonnull
    public MutableQHashDoubleSetGO newMutableSet(int expectedSize) {
        MutableQHashDoubleSet set = new MutableQHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashDoubleSet set = new UpdatableQHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elements, int expectedSize) {
        if (elements instanceof DoubleCollection) {
            SeparateKVDoubleQHash hash;
            if (elements instanceof SeparateKVDoubleQHash && (hash = (SeparateKVDoubleQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashDoubleSet set = new UpdatableQHashDoubleSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashDoubleSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(size);
        for (double e : elements) {
            set.add(e);
        }
        return set;
    }
}

