/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.ShortCursor;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.CommonShortCollectionOps;
import com.koloboke.collect.impl.InternalShortCollectionOps;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVShortQHash;
import com.koloboke.collect.impl.hash.UpdatableShortQHashSetSO;
import com.koloboke.collect.set.hash.HashShortSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class UpdatableQHashShortSetGO
extends UpdatableShortQHashSetSO
implements HashShortSet,
InternalShortCollectionOps {
    @Override
    final void copy(SeparateKVShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonShortCollectionOps.containsAll((ShortCollection)this, c);
    }

    @Nonnull
    public ShortCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Short e) {
        return this.add((short)e);
    }

    public boolean add(short key) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        short[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVShortKeyMixing.mix((short)key) % capacity;
        short cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Short> c) {
        return CommonShortCollectionOps.addAll((ShortCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeShort((Short)key);
    }

    @Override
    boolean justRemove(short key) {
        return this.removeShort(key);
    }

    public boolean removeShort(short key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

