/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalCharFloatMapOps;
import com.koloboke.collect.map.CharFloatMap;
import com.koloboke.function.CharFloatConsumer;
import com.koloboke.function.CharFloatPredicate;
import java.util.Map;

public final class CommonCharFloatMapOps {
    public static boolean containsAllEntries(final InternalCharFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharFloatMap) {
            CharFloatMap m2 = (CharFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharFloatMapOps) {
                return ((InternalCharFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharFloatPredicate(){

                public boolean test(char a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharFloatMapOps map, Map<? extends Character, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharFloatMap) {
            if (another instanceof InternalCharFloatMapOps) {
                ((InternalCharFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((CharFloatMap)another).forEach(new CharFloatConsumer(){

                    public void accept(char key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Float> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue().floatValue());
            }
        }
    }

    private CommonCharFloatMapOps() {
    }
}

